/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableEmptyIntList;
import com.hivemq.client.internal.util.collections.ImmutableIntArray;
import com.hivemq.client.internal.util.collections.ImmutableIntElement;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ImmutableIntList {
    @NotNull
    public static ImmutableIntList of() {
        return ImmutableEmptyIntList.INSTANCE;
    }

    @NotNull
    public static ImmutableIntList of(int i) {
        return new ImmutableIntElement(i);
    }

    @NotNull
    public static ImmutableIntList of(int i1, int i2) {
        return new ImmutableIntArray(i1, i2);
    }

    @NotNull
    public static ImmutableIntList of(int i1, int i2, int i3) {
        return new ImmutableIntArray(i1, i2, i3);
    }

    @NotNull
    public static ImmutableIntList of(int i1, int i2, int i3, int ... others) {
        Checks.notNull(others, "Int array");
        int[] array = new int[3 + others.length];
        array[0] = i1;
        array[1] = i2;
        array[2] = i3;
        System.arraycopy(others, 0, array, 3, others.length);
        return new ImmutableIntArray(array);
    }

    @NotNull
    public static ImmutableIntList copyOf(int @NotNull [] array) {
        Checks.notNull(array, "Int array");
        switch (array.length) {
            case 0: {
                return ImmutableEmptyIntList.INSTANCE;
            }
            case 1: {
                return new ImmutableIntElement(array[0]);
            }
        }
        return new ImmutableIntArray((int[])array.clone());
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static Builder builder(int capacity) {
        return new Builder(capacity);
    }

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public int get(int var1);

    public static class Builder {
        private static final int INITIAL_CAPACITY = 4;
        private int i;
        private int @Nullable [] array;
        private int size;

        private Builder() {
        }

        private Builder(int capacity) {
            if (capacity > 1) {
                this.array = new int[capacity];
            }
        }

        private int newCapacity(int capacity) {
            return capacity + (capacity >> 1);
        }

        @NotNull
        public Builder add(int i) {
            if (this.size == 0) {
                this.i = i;
                this.size = 1;
            } else {
                if (this.array == null) {
                    this.array = new int[4];
                } else if (this.size == this.array.length) {
                    this.array = Arrays.copyOf(this.array, this.newCapacity(this.array.length));
                }
                if (this.size == 1) {
                    this.array[0] = this.i;
                }
                this.array[this.size++] = i;
            }
            return this;
        }

        @NotNull
        public ImmutableIntList build() {
            switch (this.size) {
                case 0: {
                    return ImmutableEmptyIntList.INSTANCE;
                }
                case 1: {
                    return new ImmutableIntElement(this.i);
                }
            }
            assert (this.array != null);
            if (this.array.length == this.size) {
                return new ImmutableIntArray(this.array);
            }
            return new ImmutableIntArray(Arrays.copyOfRange(this.array, 0, this.size));
        }
    }
}

