/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class NvsProtocolDecoder
extends BaseProtocolDecoder {
    public NvsProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, String response) {
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(Unpooled.copiedBuffer((CharSequence)response, (Charset)StandardCharsets.US_ASCII), remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getUnsignedByte(buf.readerIndex()) == 0) {
            buf.readUnsignedShort();
            String imei = buf.toString(buf.readerIndex(), 15, StandardCharsets.US_ASCII);
            if (this.getDeviceSession(channel, remoteAddress, imei) != null) {
                this.sendResponse(channel, remoteAddress, "OK");
            } else {
                this.sendResponse(channel, remoteAddress, "NO01");
            }
        } else {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            LinkedList<Position> positions = new LinkedList<Position>();
            buf.skipBytes(4);
            buf.readUnsignedShort();
            buf.readLong();
            buf.readUnsignedByte();
            int count = buf.readUnsignedByte();
            for (int i = 0; i < count; ++i) {
                int j;
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                position.setTime(new Date(buf.readUnsignedInt() * 1000L));
                position.set("reason", buf.readUnsignedByte());
                position.setLongitude((double)buf.readInt() / 1.0E7);
                position.setLatitude((double)buf.readInt() / 1.0E7);
                position.setAltitude(buf.readShort());
                position.setCourse(buf.readUnsignedShort());
                position.set("sat", buf.readUnsignedByte());
                position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShort()));
                position.setValid(buf.readUnsignedByte() != 0);
                buf.readUnsignedByte();
                buf.readUnsignedByte();
                int cnt = buf.readUnsignedByte();
                for (j = 0; j < cnt; ++j) {
                    position.set("io" + buf.readUnsignedByte(), buf.readUnsignedByte());
                }
                cnt = buf.readUnsignedByte();
                for (j = 0; j < cnt; ++j) {
                    position.set("io" + buf.readUnsignedByte(), buf.readUnsignedShort());
                }
                cnt = buf.readUnsignedByte();
                for (j = 0; j < cnt; ++j) {
                    position.set("io" + buf.readUnsignedByte(), buf.readUnsignedInt());
                }
                cnt = buf.readUnsignedByte();
                for (j = 0; j < cnt; ++j) {
                    position.set("io" + buf.readUnsignedByte(), buf.readLong());
                }
                positions.add(position);
            }
            return positions;
        }
        return null;
    }
}

