/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.util.logging.Logger;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.Attribute;
import org.ice4j.attribute.LifetimeAttribute;
import org.ice4j.attribute.MappedAddressAttribute;
import org.ice4j.ice.ComponentSocket;
import org.ice4j.ice.GoogleRelayedCandidate;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.harvest.GoogleTurnCandidateHarvester;
import org.ice4j.ice.harvest.StunCandidateHarvest;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.socket.GoogleRelayedCandidateDatagramSocket;
import org.ice4j.socket.GoogleRelayedCandidateSocket;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.RelayedCandidateDatagramSocket;
import org.ice4j.stack.TransactionID;

public class GoogleTurnCandidateHarvest
extends StunCandidateHarvest {
    private static final Logger logger = Logger.getLogger(GoogleTurnCandidateHarvest.class.getName());
    private Request requestToStartResolvingCandidate;
    private String password;

    public GoogleTurnCandidateHarvest(GoogleTurnCandidateHarvester harvester, HostCandidate hostCandidate, String password) {
        super(harvester, hostCandidate);
        this.password = password;
    }

    @Override
    protected void createCandidates(Response response) {
        this.createRelayedCandidate(response);
    }

    private void createRelayedCandidate(Response response) {
        Attribute attribute = response.getAttribute('\u0001');
        if (attribute != null) {
            GoogleRelayedCandidate relayedCandidate;
            TransportAddress relayedAddress = ((MappedAddressAttribute)attribute).getAddress();
            if (this.harvester.stunServer.getTransport() == Transport.TCP) {
                relayedAddress = new TransportAddress(relayedAddress.getAddress(), this.harvester.stunServer.getPort(), Transport.TCP);
            }
            if ((relayedCandidate = this.createRelayedCandidate(relayedAddress, this.getMappedAddress(response))) != null) {
                this.harvester.getStunStack().addSocket(relayedCandidate.getStunSocket(null));
                IceSocketWrapper candidateSocket = relayedCandidate.getCandidateIceSocketWrapper();
                ComponentSocket componentSocket = relayedCandidate.getParentComponent().getComponentSocket();
                if (componentSocket != null) {
                    componentSocket.add(candidateSocket);
                }
                this.addCandidate(relayedCandidate);
            }
        }
    }

    protected GoogleRelayedCandidate createRelayedCandidate(TransportAddress transportAddress, TransportAddress mappedAddress) {
        GoogleRelayedCandidate candidate = new GoogleRelayedCandidate(transportAddress, this, mappedAddress, this.harvester.getShortTermCredentialUsername(), this.password);
        candidate.setUfrag(this.harvester.getShortTermCredentialUsername());
        return candidate;
    }

    @Override
    protected Request createRequestToStartResolvingCandidate() {
        if (this.requestToStartResolvingCandidate == null) {
            this.requestToStartResolvingCandidate = MessageFactory.createGoogleAllocateRequest(this.harvester.getShortTermCredentialUsername());
            return this.requestToStartResolvingCandidate;
        }
        return null;
    }

    @Override
    protected boolean addShortTermCredentialAttributes(Request request) {
        return false;
    }

    @Override
    protected boolean completedResolvingCandidate(Request request, Response response) {
        if (response == null || !response.isSuccessResponse() && request.getMessageType() == '\u0003') {
            try {
                if (this.startResolvingCandidate()) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.completedResolvingCandidate(request, response);
    }

    public void close(GoogleRelayedCandidateDatagramSocket relayedCandidateSocket) {
        this.setSendKeepAliveMessageInterval(0L);
    }

    @Override
    protected boolean processErrorOrFailure(Response response, Request request, TransactionID transactionID) {
        logger.info("Google TURN processErrorOrFailure");
        Object applicationData = transactionID.getApplicationData();
        if (applicationData instanceof GoogleRelayedCandidateDatagramSocket && ((RelayedCandidateDatagramSocket)applicationData).processErrorOrFailure(response, request)) {
            return true;
        }
        if (applicationData instanceof GoogleRelayedCandidateDatagramSocket && ((RelayedCandidateDatagramSocket)applicationData).processErrorOrFailure(response, request)) {
            return true;
        }
        return super.processErrorOrFailure(response, request, transactionID);
    }

    @Override
    protected void processSuccess(Response response, Request request, TransactionID transactionID) {
        Object applicationData;
        super.processSuccess(response, request, transactionID);
        int lifetime = -1;
        switch (response.getMessageType()) {
            case '\u0103': {
                LifetimeAttribute lifetimeAttribute = (LifetimeAttribute)response.getAttribute('\r');
                lifetime = lifetimeAttribute == null ? 600 : lifetimeAttribute.getLifetime();
                logger.info("Successful Google TURN allocate");
                break;
            }
        }
        if (lifetime >= 0) {
            this.setSendKeepAliveMessageInterval(1000L * (long)lifetime);
        }
        if ((applicationData = transactionID.getApplicationData()) instanceof GoogleRelayedCandidateDatagramSocket) {
            ((GoogleRelayedCandidateDatagramSocket)applicationData).processSuccess(response, request);
        } else if (applicationData instanceof GoogleRelayedCandidateSocket) {
            ((GoogleRelayedCandidateSocket)applicationData).processSuccess(response, request);
        }
    }
}

