/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate;

import java.util.Collection;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidatorConfig;

public abstract class AbstractSimpleValidator
implements SimpleValidator {
    public static final String IGNORE_EMPTY_VALUE = "ignore.empty.value";

    @Override
    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        if (input instanceof Collection) {
            Collection values = (Collection)input;
            for (Object value : values) {
                this.validate(value, inputHint, context, config);
            }
            return context;
        }
        if (this.skipValidation(input, config)) {
            return context;
        }
        this.doValidate(input, inputHint, context, config);
        return context;
    }

    protected abstract void doValidate(Object var1, String var2, ValidationContext var3, ValidatorConfig var4);

    protected abstract boolean skipValidation(Object var1, ValidatorConfig var2);

    protected boolean isIgnoreEmptyValuesConfigured(ValidatorConfig config) {
        return config != null && config.getBooleanOrDefault(IGNORE_EMPTY_VALUE, false) != false;
    }
}

