/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwk;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.List;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.crypto.KeyUse;
import org.keycloak.jose.jwk.ECPublicJWK;
import org.keycloak.jose.jwk.EdECUtils;
import org.keycloak.jose.jwk.EdECUtilsUnsupportedImpl;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKUtil;
import org.keycloak.jose.jwk.RSAPublicJWK;

public class JWKBuilder {
    protected static final EdECUtils EdEC_UTILS;
    public static final KeyUse DEFAULT_PUBLIC_KEY_USE;
    protected String kid;
    protected String algorithm;

    private JWKBuilder() {
    }

    public static JWKBuilder create() {
        return new JWKBuilder();
    }

    public JWKBuilder kid(String kid) {
        this.kid = kid;
        return this;
    }

    public JWKBuilder algorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public JWK rs256(PublicKey key) {
        this.algorithm = "RS256";
        return this.rsa(key);
    }

    public JWK rsa(Key key) {
        return this.rsa(key, null, KeyUse.SIG);
    }

    public JWK rsa(Key key, X509Certificate certificate) {
        return this.rsa(key, Collections.singletonList(certificate), KeyUse.SIG);
    }

    public JWK rsa(Key key, List<X509Certificate> certificates) {
        return this.rsa(key, certificates, null);
    }

    public JWK rsa(Key key, List<X509Certificate> certificates, KeyUse keyUse) {
        RSAPublicKey rsaKey = (RSAPublicKey)key;
        RSAPublicJWK k = new RSAPublicJWK();
        String kid = this.kid != null ? this.kid : KeyUtils.createKeyId(key);
        k.setKeyId(kid);
        k.setKeyType("RSA");
        k.setAlgorithm(this.algorithm);
        k.setPublicKeyUse(keyUse == null ? KeyUse.SIG.getSpecName() : keyUse.getSpecName());
        k.setModulus(Base64Url.encode(JWKUtil.toIntegerBytes(rsaKey.getModulus())));
        k.setPublicExponent(Base64Url.encode(JWKUtil.toIntegerBytes(rsaKey.getPublicExponent())));
        if (certificates != null && !certificates.isEmpty()) {
            String[] certificateChain = new String[certificates.size()];
            for (int i = 0; i < certificates.size(); ++i) {
                certificateChain[i] = PemUtils.encodeCertificate(certificates.get(i));
            }
            k.setX509CertificateChain(certificateChain);
        }
        return k;
    }

    public JWK rsa(Key key, KeyUse keyUse) {
        String keyUseString;
        JWK k = this.rsa(key);
        String string = keyUseString = keyUse == null ? DEFAULT_PUBLIC_KEY_USE.getSpecName() : keyUse.getSpecName();
        if (KeyUse.ENC == keyUse) {
            keyUseString = "enc";
        }
        k.setPublicKeyUse(keyUseString);
        return k;
    }

    public JWK ec(Key key) {
        return this.ec(key, DEFAULT_PUBLIC_KEY_USE);
    }

    public JWK ec(Key key, KeyUse keyUse) {
        return this.ec(key, null, keyUse);
    }

    public JWK ec(Key key, List<X509Certificate> certificates, KeyUse keyUse) {
        ECPublicKey ecKey = (ECPublicKey)key;
        ECPublicJWK k = new ECPublicJWK();
        String kid = this.kid != null ? this.kid : KeyUtils.createKeyId(key);
        int fieldSize = ecKey.getParams().getCurve().getField().getFieldSize();
        k.setKeyId(kid);
        k.setKeyType("EC");
        k.setAlgorithm(this.algorithm);
        k.setPublicKeyUse(keyUse == null ? DEFAULT_PUBLIC_KEY_USE.getSpecName() : keyUse.getSpecName());
        k.setCrv("P-" + fieldSize);
        k.setX(Base64Url.encode(JWKUtil.toIntegerBytes(ecKey.getW().getAffineX(), fieldSize)));
        k.setY(Base64Url.encode(JWKUtil.toIntegerBytes(ecKey.getW().getAffineY(), fieldSize)));
        if (certificates != null && !certificates.isEmpty()) {
            String[] certificateChain = new String[certificates.size()];
            for (int i = 0; i < certificates.size(); ++i) {
                certificateChain[i] = PemUtils.encodeCertificate(certificates.get(i));
            }
            k.setX509CertificateChain(certificateChain);
        }
        return k;
    }

    public JWK okp(Key key) {
        return this.okp(key, DEFAULT_PUBLIC_KEY_USE);
    }

    public JWK okp(Key key, KeyUse keyUse) {
        return EdEC_UTILS.okp(this.kid, this.algorithm, key, keyUse);
    }

    static {
        EdECUtils tmp;
        try {
            tmp = (EdECUtils)Class.forName("org.keycloak.jose.jwk.EdECUtilsImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            tmp = new EdECUtilsUnsupportedImpl();
        }
        EdEC_UTILS = tmp;
        DEFAULT_PUBLIC_KEY_USE = KeyUse.SIG;
    }
}

