/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency.spi;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.dependency.ProjectReload;
import org.netbeans.modules.project.dependency.reload.ProjectReloadInternal;
import org.netbeans.modules.project.dependency.reload.ProjectStateListener;
import org.netbeans.modules.project.dependency.reload.Reloader;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

public interface ProjectReloadImplementation<D> {
    public static final ProjectStateData NOT_LOADED = ProjectStateData.builder(ProjectReload.Quality.NONE).state(false, false).build();

    default public boolean checkForModifications(ProjectStateData sd, FileObject f) {
        return true;
    }

    default public void projectDataReleased(ProjectStateData<D> data) {
    }

    @CheckForNull
    public CompletableFuture<ProjectStateData<D>> reload(Project var1, ProjectReload.StateRequest var2, LoadContext<D> var3);

    public static final class ProjectStateData<D> {
        public static final long TIME_UNSUPPORTED = -1L;
        public static final long TIME_RECHECK_ON_CHANGE = -2L;
        public static final long TIME_RELOAD = -3L;
        private static final Logger LOG = ProjectReloadInternal.LOG;
        private final Collection<FileObject> files;
        private final ProjectReload.Quality quality;
        private final long timestamp;
        private Lookup lookup;
        private D projectData;
        private Object privateData;
        private Throwable error;
        private volatile boolean consistent = true;
        private volatile boolean valid;
        private volatile Collection<FileObject> changedFiles;
        private Set<Class> inconsistencies;
        private final List<ProjectStateListener> listeners = new ArrayList<ProjectStateListener>();

        ProjectStateData(Collection<FileObject> files, boolean valid, ProjectReload.Quality quality, long timestamp, Lookup lkp, Throwable error, D projectData) {
            this.lookup = lkp;
            this.valid = valid;
            this.files = files;
            this.quality = quality;
            this.timestamp = timestamp;
            this.projectData = projectData;
            this.error = error;
            if (!valid && quality != ProjectReload.Quality.NONE && LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Created invalid state data {0}", this.toString());
                LOG.log(Level.FINER, "Origin", new Throwable());
            }
        }

        @CheckForNull
        public D getProjectData() {
            return this.projectData;
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        public Collection<FileObject> getFiles() {
            return this.files;
        }

        public ProjectReload.Quality getQuality() {
            return this.quality;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean isValid() {
            return this.valid;
        }

        public boolean isConsistent() {
            return this.consistent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fire() {
            ChangeListener[] ll;
            ProjectStateData projectStateData = this;
            synchronized (projectStateData) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                ll = this.listeners.toArray(new ChangeListener[0]);
            }
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : ll) {
                l.stateChanged(e);
            }
        }

        public Collection<FileObject> getChangedFiles() {
            return this.changedFiles == null ? Collections.emptySet() : this.changedFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireFileSetChanged(Collection<FileObject> files) {
            if (this.files != null && files.containsAll(this.files) && this.files.size() == files.size()) {
                return;
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "{0} got file set changed: {1}", new Object[]{this.toString(), files});
                LOG.log(Level.FINEST, "Origin:", new Throwable());
            }
            HashSet<FileObject> n = new HashSet<FileObject>(files);
            n.removeAll(this.files);
            if (n.isEmpty()) {
                return;
            }
            ProjectStateData projectStateData = this;
            synchronized (projectStateData) {
                HashSet<FileObject> newChanged;
                Collection<FileObject> changed = this.changedFiles;
                if (changed != null) {
                    if (changed.containsAll(n)) {
                        return;
                    }
                    newChanged = new HashSet<FileObject>(changed);
                } else {
                    newChanged = new HashSet<FileObject>();
                }
                newChanged.addAll(files);
                this.changedFiles = newChanged;
                this.consistent = false;
            }
            this.fire();
        }

        public <X> X getPrivateData() {
            return (X)this.privateData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDataInconsistent(Class dataClass) {
            ProjectStateListener[] ll;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "{0} got data inconsistent: {1}", new Object[]{this.toString(), dataClass});
                LOG.log(Level.FINEST, "Origin:", new Throwable());
            }
            ProjectStateData projectStateData = this;
            synchronized (projectStateData) {
                if (this.inconsistencies == null) {
                    this.inconsistencies = new HashSet<Class>();
                }
                this.inconsistencies.add(dataClass);
            }
            ProjectStateData projectStateData2 = this;
            synchronized (projectStateData2) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                ll = this.listeners.toArray(new ProjectStateListener[0]);
            }
            ChangeEvent e = new ChangeEvent(this);
            for (ProjectStateListener l : ll) {
                l.fireDataInconsistent(this, dataClass);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireChanged(boolean invalidate, boolean inconsistent) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "{0} got state change: invalidate={1}, inconsistent={2}", new Object[]{this.toString(), invalidate, inconsistent});
                LOG.log(Level.FINEST, "Origin:", new Throwable());
            }
            boolean changed = false;
            ProjectStateData projectStateData = this;
            synchronized (projectStateData) {
                if (invalidate && this.valid) {
                    this.valid = false;
                    changed = true;
                }
                if (inconsistent && this.consistent) {
                    changed = true;
                    this.consistent = false;
                }
            }
            if (changed) {
                this.fire();
            }
        }

        Set<Class> getInconsistencies() {
            return this.inconsistencies == null ? Collections.emptySet() : new HashSet<Class>(this.inconsistencies);
        }

        synchronized void addListener(ProjectStateListener l) {
            if (this == NOT_LOADED) {
                return;
            }
            this.listeners.add(l);
        }

        synchronized void removeListener(ProjectStateListener l) {
            this.listeners.remove(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.privateData instanceof Closeable) {
                try {
                    ((Closeable)this.privateData).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ProjectStateData projectStateData = this;
            synchronized (projectStateData) {
                this.projectData = null;
                this.changedFiles = null;
                this.privateData = null;
                this.lookup = null;
                this.projectData = null;
                this.valid = false;
            }
            LOG.log(Level.FINER, "{0}: cleared.", this.toString());
            this.listeners.clear();
        }

        public String toString() {
            return "StateData@" + Integer.toHexString(System.identityHashCode(this)) + "[quality=" + this.quality + ", consistent=" + this.consistent + ", valid=" + this.valid + ", timestamp: " + this.timestamp + ", files: " + this.files + "]";
        }

        public static ProjectStateBuilder builder(ProjectReload.Quality q) {
            return new ProjectStateBuilder(null, q);
        }

        public static ProjectStateBuilder builder(Object k, ProjectReload.Quality q) {
            return new ProjectStateBuilder(k, q);
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + (int)(this.timestamp ^ this.timestamp >>> 32);
            hash = 11 * hash + (int)(this.timestamp ^ this.timestamp >>> 32);
            hash = 11 * hash + Objects.hashCode(this.projectData);
            hash = 11 * hash + Objects.hashCode((Object)this.quality);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectStateData other = (ProjectStateData)obj;
            if (this.timestamp != other.timestamp) {
                return false;
            }
            return Objects.equals((Object)this.quality, (Object)other.quality) && Objects.equals(this.projectData, other.projectData);
        }
    }

    public static final class ProjectStateBuilder<D> {
        private long time = -1L;
        private boolean valid = true;
        private boolean consistent = true;
        private ProjectReload.Quality q;
        private Object key;
        private Lookup lkp;
        private Collection<FileObject> files;
        private D data;
        private Throwable error;
        private Function<ProjectStateData<D>, ?> privateDataSupplier;

        ProjectStateBuilder(Object key, ProjectReload.Quality q) {
            this.key = key;
            this.q = q;
        }

        public ProjectStateBuilder error(Throwable t) {
            this.error = t;
            return this;
        }

        public ProjectStateBuilder files(FileObject ... files) {
            return this.files(Arrays.asList(files).stream().filter(Objects::nonNull).toList());
        }

        public ProjectStateBuilder files(Collection<FileObject> files) {
            if (this.files == null) {
                this.files = Collections.unmodifiableCollection(new LinkedHashSet<FileObject>(files));
            } else {
                this.files.addAll(files);
            }
            return this;
        }

        public ProjectStateBuilder data(D data) {
            this.data = data;
            return this;
        }

        public ProjectStateBuilder timestamp(long time) {
            this.time = time;
            return this;
        }

        public ProjectStateBuilder state(boolean valid, boolean consistent) {
            this.valid = valid;
            this.consistent = consistent;
            return this;
        }

        public ProjectStateBuilder attachLookup(Lookup lkp) {
            this.lkp = lkp;
            return this;
        }

        public <X> ProjectStateBuilder privateData(Function<ProjectStateData<D>, X> creator) {
            this.privateDataSupplier = creator;
            return this;
        }

        public ProjectStateData build() {
            ProjectStateData<D> d = new ProjectStateData<D>(this.files == null ? Collections.emptyList() : this.files, this.valid, this.q, this.time, this.lkp, this.error, this.data);
            if (!this.consistent) {
                d.fireChanged(false, true);
            }
            if (!(d.isValid() && d.isConsistent() || !Reloader.LOG.isLoggable(Level.FINER))) {
                Reloader.LOG.log(Level.FINER, "Creating obsolete StateData: {0}", d.toString());
                Reloader.LOG.log(Level.FINER, "Origin:", new Throwable());
            }
            if (this.privateDataSupplier != null) {
                d.privateData = this.privateDataSupplier.apply(d);
            }
            return d;
        }
    }

    public static final class PartialLoadException
    extends IllegalStateException {
        private final ProjectStateData partialData;

        public PartialLoadException(ProjectStateData partialData) {
            this.partialData = partialData;
        }

        public PartialLoadException(ProjectStateData partialData, String message, Throwable cause) {
            super(message, cause);
            this.partialData = partialData;
        }

        public ProjectStateData getPartialData() {
            return this.partialData;
        }
    }

    public static final class LoadContext<D> {
        final Project project;
        final ProjectReload.StateRequest request;
        final ProjectStateData<D> originalData;
        volatile boolean reloadRequested;
        volatile Object loadContext;
        Reloader.LoadContextImpl impl;

        LoadContext(Reloader.LoadContextImpl impl, Project project, ProjectReload.StateRequest request, ProjectStateData<D> original) {
            this.impl = impl;
            this.project = project;
            this.request = request;
            this.originalData = original;
        }

        public Project getProject() {
            return this.project;
        }

        public ProjectReload.StateRequest getRequest() {
            return this.request;
        }

        public Lookup stateLookup() {
            return this.impl.partialStateImpl().getLookup();
        }

        public void setCancellable(Cancellable c) throws CancellationException {
            this.impl.setCancellable(c);
        }

        public boolean isCancelled() {
            return this.impl.getCancelled() != null;
        }

        public CancellationException getCancelled() {
            return this.impl.getCancelled();
        }

        @NonNull
        public ProjectReload.ProjectState getPartialState() {
            return this.impl.partialStateImpl();
        }

        @CheckForNull
        public ProjectReload.ProjectState getPreviousState() {
            return this.impl.getOriginalState();
        }

        public void retryReload() {
            this.impl.retryReloadImpl();
        }

        public void markForReload(Class c) {
            this.impl.markForReload(c);
        }

        @CheckForNull
        public ProjectStateData<D> getProjectData() {
            return this.impl.getProjectData();
        }

        @CheckForNull
        public ProjectStateData<D> getOriginalData() {
            return this.originalData;
        }

        public <T> T getLoadContext(Class<T> clazz) {
            return (T)this.loadContext;
        }

        public <T> T ensureLoadContext(Class<T> clazz, Supplier<T> factory) {
            T lc = this.getLoadContext(clazz);
            if (lc == null) {
                this.loadContext = factory.get();
            }
            return (T)this.loadContext;
        }

        public <T> void saveLoadContext(T ctx) {
            this.loadContext = ctx;
        }
    }

    public static interface ExtendedQuery<D> {
        public Object createVariant(Lookup var1);

        public boolean satisfies(ProjectReload.StateRequest var1, ProjectReload.StateRequest var2);

        public boolean checkState(ProjectReload.StateRequest var1, ProjectStateData<D> var2);
    }
}

