/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BaseProperty;
import org.netbeans.modules.schema2beans.Bean;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDFactory;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.DOMBinding;
import org.netbeans.modules.schema2beans.NodeFactory;
import org.netbeans.modules.schema2beans.NullEntityResolver;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansNestedException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beans.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GraphManager {
    Document document = null;
    NodeFactory factory = null;
    HashMap bindingsMap = new HashMap();
    BaseBean root;
    private boolean writeCData = false;
    private Factory docFactory;
    private Writer docWriter;
    private String docTypePublic;
    private String docTypeSystem;
    static Map factoryMap = Collections.synchronizedMap(new HashMap(2));
    static Map writerMap = Collections.synchronizedMap(new HashMap(2));

    public GraphManager(BaseBean root) {
        this.root = root;
    }

    public static void setFactory(InputStream in, Factory factory) throws Schema2BeansException {
        GraphManager.setFactory(in, factory, null);
    }

    public static void setFactory(InputStream in, Factory factory, Writer writer) throws Schema2BeansException {
        if (in == null) {
            throw new Schema2BeansException(Common.getMessage("InputStreamCantBeNull_msg"));
        }
        if (factory != null) {
            factoryMap.put(in, factory);
        } else {
            factoryMap.remove(in);
        }
        if (writer != null) {
            writerMap.put(in, writer);
        } else {
            writerMap.remove(in);
        }
    }

    public void setWriter(Writer writer) {
        this.docWriter = writer;
    }

    public void setWriteCData(boolean value) {
        this.writeCData = value;
    }

    public static Node createRootElementNode(String name) throws Schema2BeansRuntimeException {
        String s = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<" + name + "/>";
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes());
        Document doc = GraphManager.createXmlDocument(in, false);
        NodeList children = doc.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (!(node instanceof DocumentType)) continue;
            doc.removeChild(node);
            --length;
        }
        return doc;
    }

    public void setXmlDocument(Node doc) throws Schema2BeansRuntimeException {
        if (doc instanceof Document) {
            this.document = (Document)doc;
            this.setNodeFactory((Document)doc);
            Object o = factoryMap.get(doc);
            if (o != null) {
                this.docFactory = (Factory)o;
                factoryMap.remove(doc);
            }
            if ((o = writerMap.get(doc)) != null) {
                this.docWriter = (Writer)o;
                writerMap.remove(doc);
            }
        } else {
            throw new Schema2BeansRuntimeException(Common.getMessage("CantFindFactory_msg"));
        }
    }

    public Document getXmlDocument() {
        return this.document;
    }

    public void setDoctype(String publicId, String systemId) {
        this.docTypePublic = publicId;
        this.docTypeSystem = systemId;
    }

    public static Node getElementNode(String name, Node doc) {
        Node n;
        for (n = doc.getFirstChild(); !(n == null || n.getNodeType() == 1 && n.getNodeName().equals(name)); n = n.getNextSibling()) {
        }
        return n;
    }

    public void createRootBinding(BaseBean beanRoot, BeanProp prop, Node doc) throws Schema2BeansException {
        prop.registerDomNode(doc, null, beanRoot);
        if (doc != null) {
            this.bindingsMap.put(doc, beanRoot.binding);
        }
    }

    public void completeRootBinding(BaseBean beanRoot, Node doc) {
        this.bindingsMap.put(doc, beanRoot.binding);
        beanRoot.binding.setNode(doc);
    }

    public void setNodeFactory(Document doc) {
        this.factory = new NodeFactory(doc);
    }

    public NodeFactory getNodeFactory() {
        return this.factory;
    }

    public BaseBean getBeanRoot() {
        return this.root;
    }

    void write(OutputStream out) throws IOException, Schema2BeansException {
        if (this.document == null) {
            throw new Schema2BeansException(Common.getMessage("CantGetDocument_msg"));
        }
        if (this.docWriter != null) {
            this.docWriter.write(out, this.document);
        } else {
            XMLUtil.DOMWriter domWriter = this.getDOMWriter();
            domWriter.write(out, this.document);
        }
    }

    protected void write(OutputStream out, String encoding) throws IOException {
        XMLUtil.DOMWriter domWriter = this.getDOMWriter();
        domWriter.write(out, encoding, this.document);
    }

    protected void write(java.io.Writer out) throws IOException {
        XMLUtil.DOMWriter domWriter = this.getDOMWriter();
        domWriter.setWriter(out);
        domWriter.write(this.document);
    }

    protected void write(java.io.Writer out, String encoding) throws IOException {
        XMLUtil.DOMWriter domWriter = this.getDOMWriter();
        domWriter.setWriter(out);
        domWriter.write(this.document, encoding);
    }

    public void write(java.io.Writer out, Node node) throws IOException, Schema2BeansException {
        XMLUtil.DOMWriter domWriter = this.getDOMWriter();
        domWriter.setWriter(out);
        domWriter.write(node);
    }

    protected XMLUtil.DOMWriter getDOMWriter() {
        XMLUtil.DOMWriter domWriter = new XMLUtil.DOMWriter();
        domWriter.setDocTypePublic(this.docTypePublic);
        domWriter.setDocTypeSystem(this.docTypeSystem);
        domWriter.setWriteCData(this.writeCData);
        return domWriter;
    }

    public void reindent(String indent) {
        XMLUtil.reindent(this.document, indent);
    }

    protected static void printLevel(java.io.Writer out, int level, String indent) throws IOException {
        StringBuffer outBuf = new StringBuffer();
        GraphManager.printLevel(outBuf, level, indent);
        out.write(outBuf.toString());
    }

    protected static void printLevel(StringBuffer out, int level, String indent) {
        for (int i = 0; i < level; ++i) {
            out.append(indent);
        }
    }

    protected static void printLevel(java.io.Writer out, int level, String indent, String text) throws IOException {
        StringBuffer outBuf = new StringBuffer();
        GraphManager.printLevel(outBuf, level, indent, text);
        out.write(outBuf.toString());
    }

    protected static void printLevel(OutputStream out, int level, String indent, String text) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out);
        GraphManager.printLevel(w, level, indent, text);
        w.flush();
    }

    protected static void printLevel(StringBuffer out, int level, String indent, String text) {
        GraphManager.printLevel(out, level, indent);
        out.append(text);
    }

    public static Document createXmlDocument(InputStream in, boolean validate) throws Schema2BeansRuntimeException {
        return GraphManager.createXmlDocument(in, validate, null);
    }

    private static InputStream tee(InputStream in) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        int totalLength = 0;
        while ((len = in.read(buf, 0, 4096)) > 0) {
            ba.write(buf, 0, len);
            totalLength += len;
        }
        System.out.println("schema2beans: in (length=" + totalLength + "):");
        System.out.println(ba.toString());
        ByteArrayInputStream bain = new ByteArrayInputStream(ba.toByteArray());
        return bain;
    }

    public static Document createXmlDocument(InputStream in, boolean validate, EntityResolver er) throws Schema2BeansRuntimeException {
        if (in == null) {
            throw new IllegalArgumentException("in == null");
        }
        try {
            Object o;
            if (DDLogFlags.debug) {
                in = GraphManager.tee(in);
            }
            if ((o = factoryMap.get(in)) != null) {
                Factory f = (Factory)o;
                Document doc = f.createDocument(in, validate);
                factoryMap.remove(in);
                factoryMap.put(doc, o);
                Object o2 = writerMap.get(in);
                if (o2 != null) {
                    writerMap.remove(in);
                    writerMap.put(doc, o2);
                }
                return doc;
            }
            return GraphManager.createXmlDocument(new InputSource(in), validate, er, null);
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException(e);
        }
        catch (IOException e) {
            throw new Schema2BeansRuntimeException(e);
        }
    }

    public static Document createXmlDocument(InputSource in, boolean validate) throws Schema2BeansException {
        return GraphManager.createXmlDocument(in, validate, null, null);
    }

    public static Document createXmlDocument(InputSource in, boolean validate, EntityResolver er, ErrorHandler eh) throws Schema2BeansException {
        if (in == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (!validate && er == null) {
            er = NullEntityResolver.newInstance();
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(validate);
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (er != null) {
                db.setEntityResolver(er);
            }
            if (eh != null) {
                db.setErrorHandler(eh);
            }
            if (DDLogFlags.debug) {
                System.out.println("createXmlDocument: validate=" + validate + " dbf=" + dbf + " db=" + db + " er=" + er);
            }
            return db.parse(in);
        }
        catch (ParserConfigurationException e) {
            throw new Schema2BeansNestedException(Common.getMessage("CantCreateXMLDOMDocument_msg"), e);
        }
        catch (SAXException e) {
            throw new Schema2BeansNestedException(Common.getMessage("CantCreateXMLDOMDocument_msg"), e);
        }
        catch (IOException e) {
            throw new Schema2BeansNestedException(Common.getMessage("CantCreateXMLDOMDocument_msg"), e);
        }
    }

    public void fillProperties(BeanProp[] prop, Node node) throws Schema2BeansException {
        if (prop == null || node == null) {
            return;
        }
        if (this.bindingsMap.get(node) == null) {
            throw new Schema2BeansException(Common.getMessage("CurrentNodeHasNoBinding_msg", (Object)node.hashCode()));
        }
        HashMap<String, BeanProp> dtdName2Prop = new HashMap<String, BeanProp>();
        HashMap<String, ArrayList<BeanProp>> dupDtdNames = new HashMap<String, ArrayList<BeanProp>>();
        for (int i = 0; i < prop.length; ++i) {
            String dtdName = prop[i].dtdName;
            if (dtdName2Prop.containsKey(dtdName)) {
                ArrayList<BeanProp> dupList = (ArrayList<BeanProp>)dupDtdNames.get(dtdName);
                if (dupList == null) {
                    dupList = new ArrayList<BeanProp>();
                    dupDtdNames.put(dtdName, dupList);
                }
                dupList.add(prop[i]);
                continue;
            }
            dtdName2Prop.put(dtdName, prop[i]);
        }
        HashMap dupDtdNameIterators = new HashMap();
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() == 1) {
                String eltName = n.getNodeName();
                BeanProp matchingProp = (BeanProp)dtdName2Prop.get(eltName);
                if (matchingProp != null) {
                    DOMBinding newBinding;
                    String s;
                    List dupList = (List)dupDtdNames.get(eltName);
                    if (dupList != null && !Common.isArray(matchingProp.type)) {
                        Iterator propIt = (Iterator)dupDtdNameIterators.get(eltName);
                        if (propIt == null) {
                            propIt = dupList.iterator();
                            dupDtdNameIterators.put(eltName, propIt);
                        } else if (propIt.hasNext()) {
                            matchingProp = (BeanProp)propIt.next();
                        }
                    }
                    DOMBinding binding = (DOMBinding)this.bindingsMap.get(n);
                    if (DDLogFlags.debug) {
                        s = eltName + " N(" + n.hashCode() + ") - " + (binding == null ? "new node" : "already bound B(" + binding.hashCode() + ")");
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 9, s);
                    }
                    if ((newBinding = matchingProp.registerDomNode(n, binding, null)) == null) continue;
                    BaseBean bean = Common.isBean(matchingProp.type) ? (BaseBean)newBinding.getBean(matchingProp) : null;
                    if (DDLogFlags.debug) {
                        s = "B(" + newBinding.hashCode() + ") - " + matchingProp.getPropClass().getName();
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 10, s);
                    }
                    if (bean == null) continue;
                    if (binding == null) {
                        this.bindingsMap.put(n, newBinding);
                    }
                    bean.createBean(n, this);
                    continue;
                }
                if (!DDLogFlags.debug) continue;
                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 11, eltName);
                continue;
            }
            short t = n.getNodeType();
            String v = n.getNodeValue();
            if (!DDLogFlags.debug) continue;
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 12, DDFactory.typeToString(t) + " = " + Common.dumpHex(v));
        }
    }

    public BaseBean getPropertyParent(String name) {
        return (BaseBean)GraphManager.getPropertyParent(this.root, name);
    }

    public static Bean getPropertyParent(Bean theRoot, String name) {
        String[] path = name.split("/", -1);
        int n = path.length;
        if (n < 2 || path[0].length() > 0) {
            throw new IllegalArgumentException(Common.getMessage("NameShouldStartWithSlash_msg", name));
        }
        if (n == 2) {
            return null;
        }
        Bean curBean = theRoot;
        for (int i = 2; i < n - 1; ++i) {
            int index;
            String[] element = path[i].split("[.]", 2);
            String beanName = element[0];
            if (element.length == 1) {
                index = 0;
            } else {
                String indexName = element[1];
                if (indexName.indexOf(105) != -1) {
                    throw new IllegalStateException(Common.getMessage("CantFindBeanBecausePartOfNameRemoved_msg", beanName, name));
                }
                index = Integer.parseInt(indexName, 16);
            }
            curBean = curBean.propertyById(beanName, index);
            if (curBean != null) continue;
            throw new IllegalStateException(Common.getMessage("CantFindBeanMayHaveBeenRemoved_msg", beanName, name));
        }
        return curBean;
    }

    public String getKeyPropertyName(String propName, String[] prop, String[] key) {
        return this.getKeyPropertyName(propName, prop, key, false);
    }

    public String getKeyPropertyName(String propName) {
        return this.getKeyPropertyName(propName, null, null, true);
    }

    public String getKeyPropertyName(String propName, String[] prop, String[] key, boolean keyName) {
        return GraphManager.getKeyPropertyName(this.root, propName, prop, key, keyName);
    }

    public static String getKeyPropertyName(Bean theRoot, String propName, String[] prop, String[] key, boolean keyName) {
        StringBuffer keyPropName = new StringBuffer();
        Bean curBean = theRoot;
        String name = propName;
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        do {
            String indexName;
            String beanName;
            int i;
            if ((i = name.indexOf(47)) != -1) {
                beanName = name.substring(0, i);
                name = name.substring(i + 1);
            } else {
                beanName = name;
                name = null;
            }
            i = beanName.indexOf(46);
            if (i != -1) {
                indexName = beanName.substring(i + 1);
                beanName = beanName.substring(0, i);
                if (indexName.indexOf(105) != -1) {
                    throw new IllegalStateException(Common.getMessage("CantFindBeanBecausePartOfNameRemoved_msg", beanName, propName));
                }
            } else {
                indexName = "0";
            }
            curBean = theRoot.hasName(beanName) ? theRoot : (curBean.getProperty(beanName).isBean() ? curBean.propertyById(beanName, Integer.parseInt(indexName, 16)) : null);
            keyPropName.append(beanName);
            if (prop != null && curBean != null) {
                for (i = 0; i < prop.length; ++i) {
                    if (!prop[i].equals(beanName)) continue;
                    keyPropName.append(".");
                    keyPropName.append(key[i]);
                    keyPropName.append("=");
                    String v = (String)curBean.getValue(key[i], 0);
                    if (v == null) break;
                    keyPropName.append(v);
                    break;
                }
            } else if (keyName && curBean != null) {
                BaseProperty[] l = curBean.listProperties();
                for (i = 0; i < l.length; ++i) {
                    String n = l[i].getName();
                    if (n.toLowerCase().indexOf("name") == -1) continue;
                    keyPropName.append(".");
                    keyPropName.append(n);
                    keyPropName.append("=");
                    String v = (String)curBean.getValue(n, 0);
                    if (v == null) break;
                    keyPropName.append(v);
                    break;
                }
            }
            if (name == null) continue;
            keyPropName.append("/");
        } while (name != null && curBean != null);
        return keyPropName.toString();
    }

    public static String trimPropertyName(String propName) {
        int j;
        StringBuffer name = new StringBuffer();
        int i = 0;
        do {
            if ((j = propName.indexOf(46, i)) == -1) {
                name.append(propName.substring(i));
                continue;
            }
            name.append(propName.substring(i, j));
            i = propName.indexOf(47, j);
        } while (j != -1 && i != -1);
        return name.toString();
    }

    public static String getPropertyParentName(String name) {
        int i = name.lastIndexOf(47);
        if (i != -1) {
            name = name.substring(0, i);
        }
        if ((i = name.lastIndexOf(47)) != -1) {
            name = name.substring(i + 1);
        }
        if ((i = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    public static String getPropertyName(String name) {
        int i = name.lastIndexOf(47);
        if (i != -1) {
            name = name.substring(i + 1);
        }
        if ((i = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, i);
        }
        if ((i = name.lastIndexOf(58)) != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    public String getAttributeName(String name) {
        int i = name.lastIndexOf(58);
        name = i != -1 ? name.substring(i + 1) : null;
        return name;
    }

    public boolean isAttribute(String name) {
        int i = name.lastIndexOf(58);
        return i != -1;
    }

    private static String extractPropertyIndex(String name) {
        int i = name.lastIndexOf(47);
        if (i != -1) {
            name = name.substring(i + 1);
        }
        if ((i = name.lastIndexOf(46)) != -1) {
            if ((i = (name = name.substring(i + 1)).lastIndexOf(58)) != -1) {
                name = name.substring(0, i);
            }
        } else {
            name = null;
        }
        return name;
    }

    public int getPropertyIndex(String name) {
        return GraphManager.getPropertyIndex(this.root, name);
    }

    public static int getPropertyIndex(Bean theRoot, String name) {
        String index = GraphManager.extractPropertyIndex(name);
        if (index != null) {
            BeanProp bp;
            int i = index.lastIndexOf(105);
            if (i != -1) {
                return Integer.parseInt(index.substring(i + 1));
            }
            Bean bean = GraphManager.getPropertyParent(theRoot, name);
            if (bean != null && (bp = bean.beanProp(GraphManager.getPropertyName(name))) != null) {
                return bp.idToIndex(Integer.parseInt(index, 16));
            }
        }
        return -1;
    }

    public static void debug(boolean d) {
        DDLogFlags.debug = d;
    }

    public Object defaultScalarValue(int type) {
        switch (type & 0xFF00) {
            case 256: {
                return "";
            }
            case 768: {
                return Boolean.FALSE;
            }
            case 1024: {
                return (byte)0;
            }
            case 1280: {
                return Character.valueOf('\u0000');
            }
            case 1536: {
                return (short)0;
            }
            case 1792: {
                return 0;
            }
            case 2048: {
                return 0L;
            }
            case 2304: {
                return Float.valueOf(0.0f);
            }
            case 2560: {
                return 0.0;
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType", type));
    }

    public static interface Factory {
        public Document createDocument(InputStream var1, boolean var2);
    }

    public static interface Writer {
        public void write(OutputStream var1, Document var2);
    }
}

