/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.dbgp.breakpoints.LineBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.modules.php.dbgp.ui.Bundle;
import org.netbeans.modules.php.dbgp.ui.ControllerProvider;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class DbgpLineBreakpointCustomizerPanel
extends JPanel
implements ControllerProvider {
    private static final Logger LOGGER = Logger.getLogger(DbgpLineBreakpointCustomizerPanel.class.getName());
    private static final int MAX_SAVED_CONDITIONS = 10;
    private static final String BP_CONDITIONS = "BPConditions";
    private static final String DEBUGGER_PHP = "debugger.php";
    private static final long serialVersionUID = 6364512868561614302L;
    private final LineBreakpoint lineBreakpoint;
    private final CustomizerController controller;
    private boolean createBreakpoint;
    private JCheckBox conditionCheckBox;
    private JComboBox<String> conditionComboBox;
    private JPanel conditionPanel;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JLabel lineNumberLabel;
    private JTextField lineNumberTextField;
    private JPanel settingsPanel;

    private static LineBreakpoint createLineBreakpoint() {
        Line currentLine = Utils.getCurrentLine();
        return DbgpLineBreakpointCustomizerPanel.createLineBreakpoint(currentLine);
    }

    private static LineBreakpoint createLineBreakpoint(Line line) {
        if (line != null) {
            return new LineBreakpoint(line);
        }
        return null;
    }

    public DbgpLineBreakpointCustomizerPanel() {
        this(DbgpLineBreakpointCustomizerPanel.createLineBreakpoint(), true);
        this.createBreakpoint = true;
    }

    public DbgpLineBreakpointCustomizerPanel(Line line) {
        this(DbgpLineBreakpointCustomizerPanel.createLineBreakpoint(line), true);
        this.createBreakpoint = true;
    }

    public DbgpLineBreakpointCustomizerPanel(LineBreakpoint lineBreakpoint) {
        this(lineBreakpoint, false);
    }

    private DbgpLineBreakpointCustomizerPanel(LineBreakpoint lineBreakpoint, boolean isEditable) {
        this.lineBreakpoint = lineBreakpoint;
        this.controller = this.createController();
        this.initComponents();
        DocumentListener defaultDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                DbgpLineBreakpointCustomizerPanel.this.controller.checkValid();
            }
        };
        this.fileTextField.setEditable(isEditable);
        this.fileTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.lineNumberTextField.setEditable(isEditable);
        this.lineNumberTextField.getDocument().addDocumentListener(defaultDocumentListener);
        Object[] conditions = DbgpLineBreakpointCustomizerPanel.getSavedConditions();
        this.conditionComboBox.setModel(new DefaultComboBoxModel<Object>(conditions));
        if (lineBreakpoint != null) {
            Line line = lineBreakpoint.getLine();
            FileObject fo = (FileObject)line.getLookup().lookup(FileObject.class);
            this.updateComponents(fo, line.getLineNumber() + 1, lineBreakpoint.getCondition());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DbgpLineBreakpointCustomizerPanel.this.controller.checkValid();
            }
        });
    }

    private void updateComponents(FileObject fileObject, int lineNumber, String condition) {
        assert (SwingUtilities.isEventDispatchThread());
        if (fileObject != null) {
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file != null) {
                this.fileTextField.setText(file.getAbsolutePath());
            } else {
                this.fileTextField.setText(fileObject.toURL().toExternalForm());
            }
        }
        this.lineNumberTextField.setText(Integer.toString(lineNumber));
        if (condition != null && !condition.isEmpty()) {
            this.conditionCheckBox.setSelected(true);
            this.conditionComboBox.setEnabled(true);
            this.conditionComboBox.getEditor().setItem(condition);
        } else {
            this.conditionCheckBox.setSelected(false);
            this.conditionComboBox.setEnabled(false);
        }
    }

    private static Object[] getSavedConditions() {
        return Properties.getDefault().getProperties(DEBUGGER_PHP).getArray(BP_CONDITIONS, new Object[0]);
    }

    private static void saveCondition(String condition) {
        Object[] savedConditions = DbgpLineBreakpointCustomizerPanel.getSavedConditions();
        Object[] conditions = null;
        boolean containsCondition = false;
        for (int i = 0; i < savedConditions.length; ++i) {
            Object c = savedConditions[i];
            if (!condition.equals(c)) continue;
            containsCondition = true;
            conditions = savedConditions;
            if (i <= 0) break;
            System.arraycopy(conditions, 0, conditions, 1, i);
            conditions[0] = condition;
            break;
        }
        if (!containsCondition) {
            if (savedConditions.length < 10) {
                conditions = new Object[savedConditions.length + 1];
                conditions[0] = condition;
                System.arraycopy(savedConditions, 0, conditions, 1, savedConditions.length);
            } else {
                conditions = savedConditions;
                System.arraycopy(conditions, 0, conditions, 1, conditions.length - 1);
                conditions[0] = condition;
            }
        }
        Properties.getDefault().getProperties(DEBUGGER_PHP).setArray(BP_CONDITIONS, conditions);
    }

    private CustomizerController createController() {
        return new CustomizerController();
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    private static int findNumLines(FileObject file) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            LOGGER.log(Level.WARNING, "Can''t find DataObject for {0}", file.getPath());
            return 0;
        }
        EditorCookie editortCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editortCookie == null) {
            return 0;
        }
        editortCookie.prepareDocument().waitFinished();
        StyledDocument document = editortCookie.getDocument();
        if (!(document instanceof StyledDocument)) {
            return 0;
        }
        StyledDocument styledDocument = document;
        return NbDocument.findLineNumber((StyledDocument)styledDocument, (int)styledDocument.getLength()) + 1;
    }

    private void initComponents() {
        this.settingsPanel = new JPanel();
        this.fileLabel = new JLabel();
        this.lineNumberLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.lineNumberTextField = new JTextField();
        this.conditionPanel = new JPanel();
        this.conditionCheckBox = new JCheckBox();
        this.conditionComboBox = new JComboBox();
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DbgpLineBreakpointCustomizerPanel.class, (String)"LBL_Settings")));
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(DbgpLineBreakpointCustomizerPanel.class, (String)"DbgpLineBreakpointCustomizerPanel.fileLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.lineNumberLabel, (String)NbBundle.getMessage(DbgpLineBreakpointCustomizerPanel.class, (String)"DbgpLineBreakpointCustomizerPanel.lineNumberLabel.text"));
        this.fileTextField.setText(NbBundle.getMessage(DbgpLineBreakpointCustomizerPanel.class, (String)"DbgpLineBreakpointCustomizerPanel.fileTextField.text"));
        this.lineNumberTextField.setText(NbBundle.getMessage(DbgpLineBreakpointCustomizerPanel.class, (String)"DbgpLineBreakpointCustomizerPanel.lineNumberTextField.text"));
        GroupLayout settingsPanelLayout = new GroupLayout(this.settingsPanel);
        this.settingsPanel.setLayout(settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lineNumberLabel).addComponent(this.fileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileTextField).addComponent(this.lineNumberTextField))));
        settingsPanelLayout.setVerticalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.fileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lineNumberLabel).addComponent(this.lineNumberTextField, -2, -1, -2))));
        this.conditionPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DbgpLineBreakpointCustomizerPanel.class, (String)"LBL_Condition")));
        Mnemonics.setLocalizedText((AbstractButton)this.conditionCheckBox, (String)NbBundle.getMessage(DbgpLineBreakpointCustomizerPanel.class, (String)"DbgpLineBreakpointCustomizerPanel.conditionCheckBox.text"));
        this.conditionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbgpLineBreakpointCustomizerPanel.this.conditionCheckBoxActionPerformed(evt);
            }
        });
        this.conditionComboBox.setEditable(true);
        this.conditionComboBox.setToolTipText(NbBundle.getMessage(DbgpLineBreakpointCustomizerPanel.class, (String)"DbgpLineBreakpointCustomizerPanel.conditionComboBox.toolTipText"));
        GroupLayout conditionPanelLayout = new GroupLayout(this.conditionPanel);
        this.conditionPanel.setLayout(conditionPanelLayout);
        conditionPanelLayout.setHorizontalGroup(conditionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(conditionPanelLayout.createSequentialGroup().addComponent(this.conditionCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.conditionComboBox, 0, 281, Short.MAX_VALUE)));
        conditionPanelLayout.setVerticalGroup(conditionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(conditionPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(conditionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.conditionCheckBox).addComponent(this.conditionComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.settingsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.conditionPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.settingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.conditionPanel, -1, -1, Short.MAX_VALUE)));
    }

    private void conditionCheckBoxActionPerformed(ActionEvent evt) {
        this.conditionComboBox.setEnabled(this.conditionCheckBox.isSelected());
        if (this.conditionCheckBox.isSelected()) {
            this.conditionComboBox.requestFocusInWindow();
        }
    }

    private class CustomizerController
    implements Controller {
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
        private String errorMessage;
        private volatile boolean valid;

        private CustomizerController() {
        }

        public boolean ok() {
            if (!this.valid) {
                String message = this.getErrorMessage();
                if (message != null) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.showMessageDialog(message);
                    } else {
                        SwingUtilities.invokeLater(() -> this.showMessageDialog(message));
                    }
                }
                return false;
            }
            String condition = null;
            if (DbgpLineBreakpointCustomizerPanel.this.conditionCheckBox.isSelected()) {
                condition = DbgpLineBreakpointCustomizerPanel.this.conditionComboBox.getSelectedItem().toString().trim();
            }
            if (DbgpLineBreakpointCustomizerPanel.this.createBreakpoint) {
                String fileName = DbgpLineBreakpointCustomizerPanel.this.fileTextField.getText();
                String lineNumberString = DbgpLineBreakpointCustomizerPanel.this.lineNumberTextField.getText();
                if (fileName == null) {
                    return false;
                }
                File file = new File(fileName.trim());
                FileObject fileObject = FileUtil.toFileObject((File)file);
                if (fileObject == null) {
                    return false;
                }
                Line line = Utils.getLine(fileObject, Integer.parseInt(lineNumberString) - 1);
                LineBreakpoint lb = DbgpLineBreakpointCustomizerPanel.createLineBreakpoint(line);
                this.setCondition(lb, condition);
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)lb);
            } else {
                this.setCondition(DbgpLineBreakpointCustomizerPanel.this.lineBreakpoint, condition);
            }
            return true;
        }

        private void setCondition(LineBreakpoint lb, String condition) {
            if (condition != null && !condition.isEmpty()) {
                lb.setCondition(condition);
                DbgpLineBreakpointCustomizerPanel.saveCondition(condition);
            } else {
                lb.setCondition(null);
            }
        }

        public boolean cancel() {
            return true;
        }

        public void checkValid() {
            boolean isValid = true;
            String fileName = DbgpLineBreakpointCustomizerPanel.this.fileTextField.getText();
            if (fileName == null || fileName.trim().length() == 0) {
                this.setErrorMessage(Bundle.CustomizerController_invalid_file());
                this.setValid(false);
                return;
            }
            File file = new File(fileName.trim());
            if (!file.exists()) {
                this.setErrorMessage(Bundle.CustomizerController_invalid_file());
                this.setValid(false);
                return;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) {
                this.setErrorMessage(Bundle.CustomizerController_invalid_file());
                this.setValid(false);
                return;
            }
            if (!FileUtils.isPhpFile((FileObject)fileObject)) {
                this.setErrorMessage(Bundle.CustomizerController_non_php_file());
                this.setValid(false);
                return;
            }
            String lineNumberString = DbgpLineBreakpointCustomizerPanel.this.lineNumberTextField.getText();
            if (lineNumberString == null || lineNumberString.trim().length() == 0) {
                this.setErrorMessage(Bundle.CustomizerController_invalid_line());
                this.setValid(false);
                return;
            }
            try {
                int lineNumber = Integer.parseInt(DbgpLineBreakpointCustomizerPanel.this.lineNumberTextField.getText());
                if (lineNumber <= 0) {
                    this.setErrorMessage(Bundle.CustomizerController_invalid_line());
                    this.setValid(false);
                    return;
                }
                int maxLine = DbgpLineBreakpointCustomizerPanel.findNumLines(fileObject);
                if (maxLine == 0) {
                    maxLine = 0x7FFFFFFE;
                }
                if (lineNumber > maxLine) {
                    this.setErrorMessage(Bundle.CustomizerController_too_big_line_number(Integer.toString(lineNumber), Integer.toString(maxLine)));
                    this.setValid(false);
                    return;
                }
            }
            catch (NumberFormatException nfe) {
                this.setErrorMessage(Bundle.CustomizerController_invalid_line());
                this.setValid(false);
                isValid = false;
            }
            if (isValid) {
                this.setErrorMessage(null);
                this.setValid(true);
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.propertyChangeSupport.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.propertyChangeSupport.removePropertyChangeListener(l);
        }

        void setErrorMessage(String message) {
            this.errorMessage = message;
            this.propertyChangeSupport.firePropertyChange("errorNotification", null, message);
        }

        private void setValid(boolean valid) {
            this.valid = valid;
            this.propertyChangeSupport.firePropertyChange("valid", !valid, valid);
        }

        String getErrorMessage() {
            return this.errorMessage;
        }

        private void showMessageDialog(String message) {
            NotifyDescriptor.Message descr = new NotifyDescriptor.Message((Object)message);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
        }
    }
}

