/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.bower.file;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.web.clientproject.api.json.JsonFile;
import org.openide.filesystems.FileObject;

public final class BowerJson {
    public static final String FILE_NAME = "bower.json";
    public static final String PROP_DEPENDENCIES = "DEPENDENCIES";
    public static final String PROP_DEV_DEPENDENCIES = "DEV_DEPENDENCIES";
    public static final String FIELD_DEPENDENCIES = "dependencies";
    public static final String FIELD_DEV_DEPENDENCIES = "devDependencies";
    private final JsonFile bowerJson;

    public BowerJson(FileObject directory) {
        this(directory, FILE_NAME);
    }

    BowerJson(FileObject directory, String filename) {
        assert (directory != null);
        this.bowerJson = new JsonFile(filename, directory, JsonFile.WatchedFields.create().add(PROP_DEPENDENCIES, new String[]{FIELD_DEPENDENCIES}).add(PROP_DEV_DEPENDENCIES, new String[]{FIELD_DEV_DEPENDENCIES}));
    }

    public BowerDependencies getDependencies() {
        Map dependencies = (Map)this.bowerJson.getContentValue(Map.class, new String[]{FIELD_DEPENDENCIES});
        Map devDependencies = (Map)this.bowerJson.getContentValue(Map.class, new String[]{FIELD_DEV_DEPENDENCIES});
        return new BowerDependencies(this.sanitizeDependencies(dependencies), this.sanitizeDependencies(devDependencies));
    }

    @CheckForNull
    private Map<String, String> sanitizeDependencies(@NullAllowed Map<Object, Object> data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        HashMap<String, String> sanitized = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            sanitized.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return sanitized;
    }

    public boolean exists() {
        return this.bowerJson.exists();
    }

    public String getPath() {
        return this.bowerJson.getPath();
    }

    public File getFile() {
        return this.bowerJson.getFile();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.bowerJson.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.bowerJson.removePropertyChangeListener(listener);
    }

    public void refresh() {
        this.bowerJson.refresh();
    }

    public void setContent(List<String> fieldHierarchy, Object value) throws IOException {
        this.bowerJson.setContent(fieldHierarchy, value);
    }

    void cleanup() {
        this.bowerJson.cleanup();
    }

    public static final class BowerDependencies {
        public final Map<String, String> dependencies = new ConcurrentHashMap<String, String>();
        public final Map<String, String> devDependencies = new ConcurrentHashMap<String, String>();

        BowerDependencies(@NullAllowed Map<String, String> dependencies, @NullAllowed Map<String, String> devDependencies) {
            if (dependencies != null) {
                this.dependencies.putAll(dependencies);
            }
            if (devDependencies != null) {
                this.devDependencies.putAll(devDependencies);
            }
        }

        public boolean isEmpty() {
            return this.dependencies.isEmpty() && this.devDependencies.isEmpty();
        }

        public int getCount() {
            return this.dependencies.size() + this.devDependencies.size();
        }

        public String toString() {
            return "BowerDependencies{dependencies=" + this.dependencies + ", devDependencies=" + this.devDependencies + '}';
        }
    }
}

