/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class MouseCenteredZoomAction
extends WidgetAction.Adapter {
    private double zoomMultiplier;

    public MouseCenteredZoomAction(double zoomMultiplier) {
        this.zoomMultiplier = zoomMultiplier;
    }

    @Override
    public WidgetAction.State mouseWheelMoved(Widget widget, WidgetAction.WidgetMouseWheelEvent event) {
        int amount;
        Scene scene = widget.getScene();
        int modifiers = scene.getInputBindings().getZoomActionModifiers();
        if ((event.getModifiers() & modifiers) != modifiers) {
            return WidgetAction.State.REJECTED;
        }
        double scale = 1.0;
        for (amount = event.getWheelRotation(); amount > 0; --amount) {
            scale /= this.zoomMultiplier;
        }
        while (amount < 0) {
            scale *= this.zoomMultiplier;
            ++amount;
        }
        JComponent view = scene.getView();
        if (view != null) {
            Rectangle viewBounds = view.getVisibleRect();
            Point center = widget.convertLocalToScene(event.getPoint());
            Point mouseLocation = scene.convertSceneToView(center);
            scene.setZoomFactor(scale * scene.getZoomFactor());
            scene.validate();
            center = scene.convertSceneToView(center);
            view.scrollRectToVisible(new Rectangle(center.x - (mouseLocation.x - viewBounds.x), center.y - (mouseLocation.y - viewBounds.y), viewBounds.width, viewBounds.height));
        } else {
            scene.setZoomFactor(scale * scene.getZoomFactor());
        }
        return WidgetAction.State.CONSUMED;
    }
}

