/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.completion;

import java.util.function.Consumer;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.lsp.Completion;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.modules.micronaut.MicronautConfigProperties;
import org.netbeans.modules.micronaut.MicronautConfigUtilities;
import org.netbeans.modules.micronaut.completion.MicronautConfigCompletionTask;
import org.netbeans.modules.micronaut.completion.MicronautConfigDocumentation;
import org.netbeans.spi.lsp.CompletionCollector;
import org.openide.filesystems.FileObject;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;

public class MicronautConfigCompletionCollector
implements CompletionCollector {
    public static MicronautConfigCompletionCollector createYamlCollector() {
        return new MicronautConfigCompletionCollector();
    }

    public static MicronautConfigCompletionCollector createPropertiesCollector() {
        return new MicronautConfigCompletionCollector();
    }

    public boolean collectCompletions(Document doc, int offset, Completion.Context context, Consumer<Completion> consumer) {
        Project project;
        FileObject fo = EditorDocumentUtils.getFileObject((Document)doc);
        if (MicronautConfigUtilities.isMicronautConfigFile(fo) && (project = FileOwnerQuery.getOwner((FileObject)fo)) != null && MicronautConfigProperties.hasConfigMetadata(project)) {
            new MicronautConfigCompletionTask().query(doc, offset, project, new MicronautConfigCompletionTask.ItemFactory<Completion>(){

                @Override
                public Completion createTopLevelPropertyItem(String propName, int offset, int baseIndent, int indentLevelSize) {
                    StringBuilder insertText = new StringBuilder();
                    Completion.TextFormat insertTextFormat = Completion.TextFormat.PlainText;
                    if (baseIndent < 0) {
                        if ("*".equals(propName)) {
                            insertText.append("$1.");
                            insertTextFormat = Completion.TextFormat.Snippet;
                        } else {
                            insertText.append(propName).append(".");
                        }
                    } else if ("*".equals(propName)) {
                        insertText.append("$1:\n");
                        ArrayUtilities.appendSpaces((StringBuilder)insertText, (int)(baseIndent + indentLevelSize));
                        insertTextFormat = Completion.TextFormat.Snippet;
                    } else {
                        insertText.append(propName).append(":\n");
                        ArrayUtilities.appendSpaces((StringBuilder)insertText, (int)indentLevelSize);
                    }
                    return CompletionCollector.newBuilder((String)propName).kind(Completion.Kind.Property).sortText(String.format("%04d%s", 10, propName)).insertText(insertText.toString()).insertTextFormat(insertTextFormat).build();
                }

                @Override
                public Completion createPropertyItem(ConfigurationMetadataProperty property, int offset, int baseIndent, int indentLevelSize, int idx) {
                    String[] parts = property.getId().substring(idx).split("\\.");
                    StringBuilder insertText = new StringBuilder();
                    int num = 1;
                    int indent = 0;
                    Completion.TextFormat insertTextFormat = Completion.TextFormat.PlainText;
                    for (int i = 0; i < parts.length; ++i) {
                        String part = parts[i];
                        if ("*".equals(part)) {
                            insertText.append("$" + num++);
                            insertTextFormat = Completion.TextFormat.Snippet;
                        } else {
                            insertText.append(part);
                        }
                        if (baseIndent < 0) {
                            if (i < parts.length - 1) {
                                insertText.append(".");
                                continue;
                            }
                            insertText.append("=");
                            continue;
                        }
                        if (i < parts.length - 1) {
                            insertText.append(":\n");
                            ArrayUtilities.appendSpaces((StringBuilder)insertText, (int)(indent += indentLevelSize));
                            continue;
                        }
                        insertText.append(": ");
                    }
                    CompletionCollector.Builder builder = CompletionCollector.newBuilder((String)property.getId()).kind(Completion.Kind.Property).sortText(String.format("%04d%s", property.isDeprecated() ? 30 : 20, property.getId())).insertText(insertText.toString()).insertTextFormat(insertTextFormat).documentation(new MicronautConfigDocumentation(property).getText());
                    if (property.isDeprecated()) {
                        builder.addTag(Completion.Tag.Deprecated);
                    }
                    return builder.build();
                }

                @Override
                public Completion createValueItem(String value, int offset, boolean isEnum) {
                    return CompletionCollector.newBuilder((String)value).kind(isEnum ? Completion.Kind.EnumMember : Completion.Kind.Keyword).sortText(String.format("%04d%s", 5, value)).build();
                }
            }).stream().forEach(consumer);
        }
        return true;
    }
}

