/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class LayoutPersistenceManager
implements LayoutConstants {
    private LayoutModel layoutModel;
    private LayoutComponent layoutContainer;
    private int rootIndex;
    private int dimension;
    private Map<String, String> idNameMap;
    private boolean humanReadable;
    private int indent;
    private StringBuilder sb;
    static final String XML_DIMENSION_LAYOUT = "DimensionLayout";
    static final String XML_GROUP = "Group";
    static final String XML_COMPONENT = "Component";
    static final String XML_EMPTY_SPACE = "EmptySpace";
    static final String ATTR_DIMENSION_DIM = "dim";
    static final String ATTR_GROUP_TYPE = "type";
    static final String ATTR_PADDING_TYPE = "type";
    static final String ATTR_SIZE_MIN = "min";
    static final String ATTR_SIZE_PREF = "pref";
    static final String ATTR_SIZE_MAX = "max";
    static final String ATTR_ALIGNMENT = "alignment";
    static final String ATTR_GROUP_ALIGNMENT = "groupAlignment";
    static final String ATTR_LINK_SIZE = "linkSize";
    static final String ATTR_COMPONENT_ID = "id";
    static final String ATTR_ATTRIBUTES = "attributes";
    static final String ATTR_ROOT_INDEX = "rootIndex";
    static final String VALUE_DIMENSION_HORIZONTAL = "horizontal";
    static final String VALUE_DIMENSION_VERTICAL = "vertical";
    static final String VALUE_ALIGNMENT_LEADING = "leading";
    static final String VALUE_ALIGNMENT_TRAILING = "trailing";
    static final String VALUE_ALIGNMENT_CENTER = "center";
    static final String VALUE_ALIGNMENT_BASELINE = "baseline";
    static final String VALUE_SIZE_PREFERRED = "$pref";
    static final String VALUE_SIZE_MAX = "Short.MAX_VALUE";
    static final String VALUE_GROUP_PARALLEL = "parallel";
    static final String VALUE_GROUP_SEQUENTIAL = "sequential";
    static final String VALUE_PADDING_RELATED = "related";
    static final String VALUE_PADDING_UNRELATED = "unrelated";
    static final String VALUE_PADDING_SEPARATE = "separate";
    static final String VALUE_PADDING_INDENT = "indent";
    private final String TEMPORARY_ID = "<temp_id>";
    private String missingNameH;
    private String missingNameV;

    private LayoutPersistenceManager(LayoutModel layoutModel) {
        this.layoutModel = layoutModel;
    }

    static String saveContainer(LayoutModel layoutModel, LayoutComponent container, Map<String, String> idToNameMap, int indent, boolean humanReadable) {
        LayoutPersistenceManager lpm = new LayoutPersistenceManager(layoutModel);
        lpm.layoutContainer = container;
        lpm.idNameMap = idToNameMap;
        lpm.indent = indent;
        lpm.humanReadable = humanReadable;
        return lpm.saveLayout();
    }

    private String saveLayout() {
        this.sb = new StringBuilder();
        this.dimension = 0;
        while (this.dimension < 2) {
            this.indent().append('<').append(XML_DIMENSION_LAYOUT);
            this.sb.append(' ').append(ATTR_DIMENSION_DIM).append("=\"");
            if (this.humanReadable) {
                switch (this.dimension) {
                    case 0: {
                        this.sb.append(VALUE_DIMENSION_HORIZONTAL);
                        break;
                    }
                    case 1: {
                        this.sb.append(VALUE_DIMENSION_VERTICAL);
                        break;
                    }
                    default: {
                        this.sb.append(this.dimension);
                        break;
                    }
                }
            } else {
                this.sb.append(this.dimension);
            }
            this.sb.append("\">\n");
            this.rootIndex = 0;
            this.saveInterval(this.layoutContainer.getLayoutRoot(0, this.dimension));
            this.indent().append("</").append(XML_DIMENSION_LAYOUT).append(">\n");
            ++this.dimension;
        }
        return this.sb.toString();
    }

    static String dumpInterval(LayoutModel layoutModel, LayoutInterval interval, int dimension, int indent) {
        LayoutPersistenceManager lpm = new LayoutPersistenceManager(layoutModel);
        lpm.indent = indent;
        lpm.humanReadable = true;
        lpm.dimension = dimension;
        lpm.sb = new StringBuilder();
        lpm.saveInterval(interval);
        return lpm.sb.toString();
    }

    private void saveInterval(LayoutInterval interval) {
        ++this.indent;
        this.indent();
        if (interval.isGroup()) {
            this.sb.append('<').append(XML_GROUP).append(' ');
            this.sb.append("type").append("=\"");
            if (this.humanReadable) {
                this.sb.append(interval.isParallel() ? VALUE_GROUP_PARALLEL : VALUE_GROUP_SEQUENTIAL);
            } else {
                this.sb.append(interval.getType());
            }
            this.sb.append("\"");
            if (interval.getParent() == null && this.rootIndex > 0) {
                this.sb.append(" ").append(ATTR_ROOT_INDEX).append("=\"");
                this.sb.append(this.rootIndex);
                this.sb.append("\"");
            }
            this.saveAlignment(interval.getRawAlignment(), false);
            if (interval.isParallel()) {
                this.saveAlignment(interval.getGroupAlignment(), true);
            }
            this.saveSize(interval.getMinimumSize(), ATTR_SIZE_MIN);
            this.saveSize(interval.getMaximumSize(), ATTR_SIZE_MAX);
            this.saveAttributes(interval.getAttributes());
            this.sb.append(">\n");
            ++this.indent;
            Iterator<LayoutInterval> iter = interval.getSubIntervals();
            while (iter.hasNext()) {
                LayoutInterval subInterval = iter.next();
                this.saveInterval(subInterval);
            }
            if (interval.getParent() == null && this.rootIndex == 0 && this.layoutContainer != null) {
                int i = 1;
                while (i < this.layoutContainer.getLayoutRootCount()) {
                    this.rootIndex = i++;
                    this.saveInterval(this.layoutContainer.getLayoutRoot(this.rootIndex, this.dimension));
                }
            }
            --this.indent;
            this.indent().append("</").append(XML_GROUP).append(">\n");
        } else {
            if (interval.isComponent()) {
                String name = interval.getComponent().getId();
                if (this.idNameMap != null) {
                    name = this.idNameMap.get(name);
                    assert (name != null);
                }
                this.sb.append('<').append(XML_COMPONENT).append(' ');
                this.sb.append(ATTR_COMPONENT_ID).append("=\"").append(name).append("\"");
                this.saveLinkSize(interval.getComponent().getLinkSizeId(this.dimension));
                this.saveAlignment(interval.getRawAlignment(), false);
            } else if (interval.isEmptySpace()) {
                this.sb.append('<').append(XML_EMPTY_SPACE);
                if (interval.isDefaultPadding()) {
                    this.savePaddingType(interval.getPaddingType());
                }
            } else assert (false);
            this.saveSize(interval.getMinimumSize(), ATTR_SIZE_MIN);
            this.saveSize(interval.getPreferredSize(), ATTR_SIZE_PREF);
            this.saveSize(interval.getMaximumSize(), ATTR_SIZE_MAX);
            this.saveAttributes(interval.getAttributes());
            this.sb.append("/>\n");
        }
        --this.indent;
    }

    private void saveLinkSize(int linkSizeId) {
        if (linkSizeId != -1) {
            this.sb.append(" ").append(ATTR_LINK_SIZE).append("=\"").append(linkSizeId).append("\"");
        }
    }

    private void saveAlignment(int alignment, boolean group) {
        String attrPrefix = " " + (group ? ATTR_GROUP_ALIGNMENT : ATTR_ALIGNMENT) + "=\"";
        if (this.humanReadable) {
            if (alignment != -1) {
                this.sb.append(attrPrefix);
                switch (alignment) {
                    case 0: {
                        this.sb.append(VALUE_ALIGNMENT_LEADING);
                        break;
                    }
                    case 1: {
                        this.sb.append(VALUE_ALIGNMENT_TRAILING);
                        break;
                    }
                    case 2: {
                        this.sb.append(VALUE_ALIGNMENT_CENTER);
                        break;
                    }
                    case 3: {
                        this.sb.append(VALUE_ALIGNMENT_BASELINE);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.sb.append("\"");
            }
        } else if (alignment != -1) {
            this.sb.append(attrPrefix).append(alignment).append("\"");
        }
    }

    private void saveSize(int size, String attr) {
        String attrPrefix = " " + attr + "=\"";
        if (this.humanReadable) {
            if (size != -1) {
                this.sb.append(attrPrefix);
                if (size == -2) {
                    this.sb.append(VALUE_SIZE_PREFERRED);
                } else if (size == Short.MAX_VALUE) {
                    this.sb.append(VALUE_SIZE_MAX);
                } else {
                    this.sb.append(size);
                }
                this.sb.append("\"");
            }
        } else if (size != -1) {
            this.sb.append(attrPrefix).append(size).append("\"");
        }
    }

    private void savePaddingType(LayoutConstants.PaddingType paddingType) {
        if (paddingType != null && paddingType != LayoutConstants.PaddingType.RELATED) {
            String str;
            this.sb.append(' ').append("type").append("=\"");
            switch (paddingType) {
                case UNRELATED: {
                    str = VALUE_PADDING_UNRELATED;
                    break;
                }
                case SEPARATE: {
                    str = VALUE_PADDING_SEPARATE;
                    break;
                }
                case INDENT: {
                    str = VALUE_PADDING_INDENT;
                    break;
                }
                default: {
                    str = VALUE_PADDING_RELATED;
                }
            }
            this.sb.append(str).append("\"");
        }
    }

    private void saveAttributes(int attributes) {
        if (!this.humanReadable) {
            attributes &= 0x23;
        }
        this.sb.append(' ').append(ATTR_ATTRIBUTES).append("=\"");
        this.sb.append(attributes).append("\"");
    }

    private StringBuilder indent() {
        char[] spaces = new char[2 * this.indent];
        Arrays.fill(spaces, ' ');
        return this.sb.append(spaces);
    }

    static void loadContainer(LayoutModel layoutModel, String containerId, NodeList layoutNodeList, Map<String, String> nameToIdMap) throws IOException {
        LayoutPersistenceManager lpm = new LayoutPersistenceManager(layoutModel);
        lpm.idNameMap = nameToIdMap;
        lpm.loadLayout(containerId, layoutNodeList);
    }

    private void loadLayout(String containerId, NodeList layoutNodeList) throws IOException {
        this.layoutContainer = this.layoutModel.getLayoutComponent(containerId);
        if (this.layoutContainer == null) {
            this.layoutContainer = new LayoutComponent(containerId, true);
            this.layoutModel.addRootComponent(this.layoutContainer);
        }
        block0: for (int i = 0; i < layoutNodeList.getLength(); ++i) {
            Node dimLayoutNode = layoutNodeList.item(i);
            if (!(dimLayoutNode instanceof Element) || !dimLayoutNode.getNodeName().equals(XML_DIMENSION_LAYOUT)) continue;
            Node dimAttrNode = dimLayoutNode.getAttributes().getNamedItem(ATTR_DIMENSION_DIM);
            this.dimension = LayoutPersistenceManager.integerFromNode(dimAttrNode);
            this.rootIndex = 0;
            LayoutInterval layoutRoot = this.layoutContainer.getLayoutRoot(0, this.dimension);
            NodeList subNodes = dimLayoutNode.getChildNodes();
            for (int j = 0; j < subNodes.getLength(); ++j) {
                Node node = subNodes.item(j);
                if (!(node instanceof Element)) continue;
                this.loadGroup(layoutRoot, node);
                continue block0;
            }
        }
        this.correctMissingName();
        this.checkMissingComponentsInDimension();
    }

    private void loadGroup(LayoutInterval group, Node groupNode) throws IOException {
        NamedNodeMap attrMap = groupNode.getAttributes();
        Node alignmentNode = attrMap.getNamedItem(ATTR_ALIGNMENT);
        Node groupAlignmentNode = attrMap.getNamedItem(ATTR_GROUP_ALIGNMENT);
        Node minNode = attrMap.getNamedItem(ATTR_SIZE_MIN);
        Node maxNode = attrMap.getNamedItem(ATTR_SIZE_MAX);
        int alignment = alignmentNode == null ? -1 : LayoutPersistenceManager.integerFromNode(alignmentNode);
        group.setAlignment(alignment);
        if (group.isParallel()) {
            int groupAlignment;
            int n = groupAlignment = groupAlignmentNode == null ? -1 : LayoutPersistenceManager.integerFromNode(groupAlignmentNode);
            if (groupAlignment != -1) {
                group.setGroupAlignment(groupAlignment);
            }
        }
        int min = minNode == null ? -1 : LayoutPersistenceManager.integerFromNode(minNode);
        int max = maxNode == null ? -1 : LayoutPersistenceManager.integerFromNode(maxNode);
        group.setMinimumSize(min);
        group.setMaximumSize(max);
        this.loadAttributes(group, attrMap);
        NodeList subNodes = groupNode.getChildNodes();
        for (int i = 0; i < subNodes.getLength(); ++i) {
            Node subNode = subNodes.item(i);
            if (!(subNode instanceof Element)) continue;
            String nodeName = subNode.getNodeName();
            if (XML_GROUP.equals(nodeName)) {
                Node rootIndexNode;
                LayoutInterval subGroup = null;
                int groupType = LayoutPersistenceManager.integerFromNode(subNode.getAttributes().getNamedItem("type"));
                if (group.getParent() == null && groupType == 103 && (rootIndexNode = subNode.getAttributes().getNamedItem(ATTR_ROOT_INDEX)) != null) {
                    this.rootIndex = LayoutPersistenceManager.integerFromNode(rootIndexNode);
                    while (this.rootIndex >= this.layoutContainer.getLayoutRootCount()) {
                        this.layoutContainer.addNewLayoutRoots();
                    }
                    subGroup = this.layoutContainer.getLayoutRoot(this.rootIndex, this.dimension);
                }
                if (subGroup == null) {
                    subGroup = new LayoutInterval(groupType);
                    group.add(subGroup, -1);
                }
                this.loadGroup(subGroup, subNode);
                continue;
            }
            if (XML_EMPTY_SPACE.equals(nodeName)) {
                this.loadEmptySpace(group, subNode);
                continue;
            }
            assert (XML_COMPONENT.equals(nodeName));
            this.loadComponent(group, subNode);
        }
        if (this.dimension == 1) {
            this.checkAndFixGroup(group);
        }
    }

    private void loadEmptySpace(LayoutInterval parent, Node spaceNode) {
        LayoutInterval space = new LayoutInterval(101);
        NamedNodeMap attrMap = spaceNode.getAttributes();
        this.loadSizes(space, attrMap);
        this.loadAttributes(space, attrMap);
        parent.add(space, -1);
    }

    private void loadComponent(LayoutInterval parent, Node componentNode) throws IOException {
        LayoutInterval interval;
        Node alignmentNode;
        NamedNodeMap attrMap = componentNode.getAttributes();
        String name = attrMap.getNamedItem(ATTR_COMPONENT_ID).getNodeValue();
        Node linkSizeId = attrMap.getNamedItem(ATTR_LINK_SIZE);
        String id = this.idNameMap.get(name);
        if (id == null) {
            id = this.useTemporaryId(name);
        }
        int alignment = (alignmentNode = attrMap.getNamedItem(ATTR_ALIGNMENT)) == null ? -1 : LayoutPersistenceManager.integerFromNode(alignmentNode);
        LayoutComponent layoutComponent = this.layoutModel.getLayoutComponent(id);
        if (layoutComponent == null) {
            layoutComponent = new LayoutComponent(id, false);
        }
        if (layoutComponent.getParent() == null) {
            this.layoutModel.addComponent(layoutComponent, this.layoutContainer, -1);
        }
        if ((interval = layoutComponent.getLayoutInterval(this.dimension)).getParent() != null) {
            System.err.println("WARNING: Component " + name + " found more than once in the " + (this.dimension == 0 ? VALUE_DIMENSION_HORIZONTAL : VALUE_DIMENSION_VERTICAL) + " layout definition. Removing superfluous occurrences.");
            this.layoutModel.setCorrected();
            return;
        }
        interval.setAlignment(alignment);
        if (linkSizeId != null) {
            this.layoutModel.addComponentToLinkSizedGroup(LayoutPersistenceManager.integerFromNode(linkSizeId), layoutComponent.getId(), this.dimension);
        }
        this.loadSizes(interval, attrMap);
        this.loadAttributes(interval, attrMap);
        parent.add(interval, -1);
    }

    private void loadSizes(LayoutInterval interval, NamedNodeMap attrMap) {
        int max;
        Node minNode = attrMap.getNamedItem(ATTR_SIZE_MIN);
        Node prefNode = attrMap.getNamedItem(ATTR_SIZE_PREF);
        Node maxNode = attrMap.getNamedItem(ATTR_SIZE_MAX);
        int min = minNode == null ? -1 : LayoutPersistenceManager.integerFromNode(minNode);
        int pref = prefNode == null ? -1 : LayoutPersistenceManager.integerFromNode(prefNode);
        int n = max = maxNode == null ? -1 : LayoutPersistenceManager.integerFromNode(maxNode);
        if (pref != -1 && pref < 0) {
            System.err.println("WARNING: Invalid preferred size (" + Integer.toString(pref) + ") of a layout interval encountered, reset to default.");
            pref = -1;
            this.layoutModel.setCorrected();
        }
        interval.setSizes(min, pref, max);
        if (max == Short.MAX_VALUE) {
            interval.setLastActualSize(Integer.MIN_VALUE);
        }
        if (interval.isDefaultPadding()) {
            Node paddingNode = attrMap.getNamedItem("type");
            String paddingStr = paddingNode != null ? paddingNode.getNodeValue() : null;
            LayoutConstants.PaddingType paddingType = null;
            if (paddingStr != null && !paddingStr.equals(VALUE_PADDING_RELATED)) {
                if (paddingStr.equals(VALUE_PADDING_UNRELATED)) {
                    paddingType = LayoutConstants.PaddingType.UNRELATED;
                } else if (paddingStr.equals(VALUE_PADDING_SEPARATE)) {
                    paddingType = LayoutConstants.PaddingType.SEPARATE;
                } else if (paddingStr.equals(VALUE_PADDING_INDENT)) {
                    paddingType = LayoutConstants.PaddingType.INDENT;
                }
            }
            if (paddingType != null) {
                interval.setPaddingType(paddingType);
            }
        }
    }

    private void loadAttributes(LayoutInterval interval, NamedNodeMap attrMap) {
        Node attributesNode = attrMap.getNamedItem(ATTR_ATTRIBUTES);
        int attributes = 0;
        if (attributesNode != null) {
            attributes = LayoutPersistenceManager.integerFromNode(attributesNode);
            attributes &= 0x23;
        }
        interval.setAttributes(attributes);
    }

    private static int integerFromNode(Node node) {
        String nodeStr = node.getNodeValue();
        return Integer.parseInt(nodeStr);
    }

    private void checkAndFixGroup(LayoutInterval group) {
        if (group.isParallel()) {
            int groupAlign = group.getGroupAlignment();
            int baselineCount = 0;
            Iterator<LayoutInterval> iter = group.getSubIntervals();
            while (iter.hasNext()) {
                LayoutInterval subInterval = iter.next();
                if (subInterval.getAlignment() != 3) continue;
                if (!subInterval.isComponent()) {
                    subInterval.setAlignment(groupAlign == 3 ? 0 : -1);
                    this.layoutModel.setCorrected();
                    System.err.println("WARNING: Invalid use of BASELINE [1], corrected automatically");
                    continue;
                }
                ++baselineCount;
            }
            if (baselineCount > 0) {
                if (baselineCount < group.getSubIntervalCount()) {
                    LayoutInterval subGroup = new LayoutInterval(103);
                    subGroup.setGroupAlignment(3);
                    int i = 0;
                    while (i < group.getSubIntervalCount()) {
                        LayoutInterval subInterval = group.getSubInterval(i);
                        if (subInterval.getAlignment() == 3) {
                            group.remove(i);
                            subGroup.add(subInterval, -1);
                            continue;
                        }
                        ++i;
                    }
                    if (groupAlign == 3) {
                        group.setGroupAlignment(0);
                    }
                    group.add(subGroup, -1);
                    this.layoutModel.setCorrected();
                    System.err.println("WARNING: Invalid use of BASELINE [2], corrected automatically");
                } else if (groupAlign != 3) {
                    group.setGroupAlignment(3);
                    this.layoutModel.setCorrected();
                    System.err.println("WARNING: Invalid use of BASELINE [3], corrected automatically");
                }
            } else if (groupAlign == 3 && group.getSubIntervalCount() > 0) {
                group.setGroupAlignment(0);
                this.layoutModel.setCorrected();
                System.err.println("WARNING: Invalid use of BASELINE [4], corrected automatically");
            }
        }
    }

    private String useTemporaryId(String name) throws IOException {
        if (this.dimension == 0) {
            if (this.missingNameH == null && (this.missingNameV == null || this.missingNameV.equals(name))) {
                this.missingNameH = name;
                return "<temp_id>";
            }
        } else if (this.dimension == 1 && this.missingNameV == null && (this.missingNameH == null || this.missingNameH.equals(name))) {
            this.missingNameV = name;
            return "<temp_id>";
        }
        throw new IOException("Undefined component referenced in layout: " + name);
    }

    private void correctMissingName() throws IOException {
        if (this.missingNameH == null && this.missingNameV == null) {
            return;
        }
        if (this.missingNameH != null && this.missingNameV != null && this.missingNameH.equals(this.missingNameV) && this.idNameMap.size() == this.layoutContainer.getSubComponentCount()) {
            for (Map.Entry<String, String> e : this.idNameMap.entrySet()) {
                String id = e.getValue();
                LayoutComponent comp = this.layoutModel.getLayoutComponent(id);
                if (comp == null) {
                    comp = this.layoutModel.getLayoutComponent("<temp_id>");
                    this.layoutModel.changeComponentId(comp, id);
                } else {
                    if (comp.getParent() != null) continue;
                    LayoutComponent tempComp = this.layoutModel.getLayoutComponent("<temp_id>");
                    this.layoutModel.replaceComponent(tempComp, comp);
                }
                this.layoutModel.setCorrected();
                System.err.println("WARNING: Invalid component name in layout: " + this.missingNameH + ", corrected automatically to: " + e.getKey());
                return;
            }
        }
        this.layoutModel.removeComponent("<temp_id>", true);
        throw new IOException("Undefined component referenced in layout: " + (this.missingNameH != null ? this.missingNameH : this.missingNameV));
    }

    private void checkMissingComponentsInDimension() throws IOException {
        for (LayoutComponent comp : this.layoutContainer.getSubcomponents()) {
            for (int dim = 0; dim < 2; ++dim) {
                LayoutInterval inOtherDim;
                LayoutInterval li = comp.getLayoutInterval(dim);
                if (li.getParent() != null || (inOtherDim = comp.getLayoutInterval(dim ^ 1)).getParent() == null) continue;
                String id = comp.getId();
                String name = "unknown";
                for (Map.Entry<String, String> e : this.idNameMap.entrySet()) {
                    if (!e.getValue().equals(id)) continue;
                    name = e.getKey();
                    break;
                }
                throw new IOException("Layout corrupted, component " + name + " missing in one dimension.");
            }
        }
    }
}

