/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.SourceForBinaryQueryImpl;
import org.netbeans.modules.java.freeform.jdkselection.JdkConfiguration;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PathMatcher;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class Classpaths
implements ClassPathProvider,
AntProjectListener,
PropertyChangeListener {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance(Classpaths.class.getName());
    static CountDownLatch TESTING_LATCH = null;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final AuxiliaryConfiguration aux;
    private final SourceForBinaryQueryImpl sfbqImpl;
    private final Map<String, Map<FileObject, ClassPath>> classpaths = new HashMap<String, Map<FileObject, ClassPath>>();
    private final Map<String, Map<List<String>, MutableClassPathImplementation>> mutablePathImpls = new HashMap<String, Map<List<String>, MutableClassPathImplementation>>();
    private final Map<MutableClassPathImplementation, ClassPath> mutableClassPathImpl2ClassPath = new HashMap<MutableClassPathImplementation, ClassPath>();
    private Map<String, Set<ClassPath>> registeredClasspaths = null;
    private static final String[] TYPES = new String[]{"classpath/source", "classpath/boot", "classpath/execute", "classpath/compile", "classpath/processor"};

    public Classpaths(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator evaluator, @NonNull AuxiliaryConfiguration aux, @NonNull SourceForBinaryQueryImpl sfbqImpl) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.aux = aux;
        this.sfbqImpl = sfbqImpl;
        helper.addAntProjectListener((AntProjectListener)this);
        evaluator.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public ClassPath findClassPath(final FileObject file, final String type) {
        return (ClassPath)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ClassPath>(){

            public ClassPath run() {
                return Classpaths.this.findClassPathImpl(file, type);
            }
        });
    }

    private synchronized ClassPath findClassPathImpl(FileObject file, String type) {
        Map<FileObject, ClassPath> classpathsByType;
        if (TESTING_LATCH != null) {
            TESTING_LATCH.countDown();
            try {
                TESTING_LATCH.await(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            this.classpaths.clear();
        }
        if ((classpathsByType = this.classpaths.get(type)) == null) {
            classpathsByType = new WeakHashMap<FileObject, ClassPath>();
            this.classpaths.put(type, classpathsByType);
        }
        for (Map.Entry<FileObject, ClassPath> entry : classpathsByType.entrySet()) {
            FileObject root = entry.getKey();
            if (root != file && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return entry.getValue();
        }
        Element java = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/5", true);
        if (java == null) {
            return null;
        }
        List compilationUnits = XMLUtil.findSubElements((Element)java);
        for (Element compilationUnitEl : compilationUnits) {
            assert (compilationUnitEl.getLocalName().equals("compilation-unit")) : compilationUnitEl;
            List<FileObject> packageRoots = Classpaths.findPackageRoots(this.helper, this.evaluator, compilationUnitEl);
            for (FileObject root : packageRoots) {
                if (root != file && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
                ClassPath cp = this.getPath(compilationUnitEl, packageRoots, type);
                for (FileObject root2 : packageRoots) {
                    classpathsByType.put(root2, cp);
                }
                return cp;
            }
        }
        return null;
    }

    public void opened() {
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                Classpaths.this.openedImpl();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openedImpl() {
        HashMap<String, Set<ClassPath>> _registeredClasspaths;
        Classpaths classpaths = this;
        synchronized (classpaths) {
            if (this.registeredClasspaths != null) {
                return;
            }
            _registeredClasspaths = new HashMap<String, Set<ClassPath>>();
            for (String type : TYPES) {
                _registeredClasspaths.put(type, new HashSet());
            }
            Element java = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/5", true);
            if (java == null) {
                return;
            }
            for (Element compilationUnitEl : XMLUtil.findSubElements((Element)java)) {
                assert (compilationUnitEl.getLocalName().equals("compilation-unit")) : compilationUnitEl;
                List<FileObject> packageRoots = Classpaths.findPackageRoots(this.helper, this.evaluator, compilationUnitEl);
                for (String type : TYPES) {
                    FileObject root2;
                    Map<FileObject, ClassPath> classpathsByType = this.classpaths.get(type);
                    if (classpathsByType == null) {
                        classpathsByType = new WeakHashMap<FileObject, ClassPath>();
                        this.classpaths.put(type, classpathsByType);
                    }
                    Set registeredClasspathsOfType = (Set)_registeredClasspaths.get(type);
                    assert (registeredClasspathsOfType != null);
                    ClassPath cp = null;
                    Iterator<FileObject> iterator = packageRoots.iterator();
                    while (iterator.hasNext() && (cp = classpathsByType.get(root2 = iterator.next())) == null) {
                    }
                    if (cp == null) {
                        cp = this.getPath(compilationUnitEl, packageRoots, type);
                        for (FileObject root2 : packageRoots) {
                            classpathsByType.put(root2, cp);
                        }
                    }
                    assert (cp != null);
                    registeredClasspathsOfType.add(cp);
                }
            }
            if (err.isLoggable(1)) {
                err.log("classpaths for " + this.helper.getProjectDirectory() + ": " + this.classpaths);
            }
            this.registeredClasspaths = _registeredClasspaths;
        }
        assert (_registeredClasspaths != null);
        GlobalPathRegistry gpr = GlobalPathRegistry.getDefault();
        for (String type : TYPES) {
            Set registeredClasspathsOfType = (Set)_registeredClasspaths.get(type);
            gpr.register(type, registeredClasspathsOfType.toArray(new ClassPath[0]));
        }
    }

    private synchronized void registerNewClasspath(String type, ClassPath cp) {
        if (this.registeredClasspaths == null) {
            return;
        }
        Set<ClassPath> s = this.registeredClasspaths.get(type);
        s.add(cp);
        GlobalPathRegistry.getDefault().register(type, new ClassPath[]{cp});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed() {
        HashMap<String, Set<ClassPath>> toUnregister;
        Classpaths classpaths = this;
        synchronized (classpaths) {
            if (this.registeredClasspaths == null) {
                return;
            }
            toUnregister = new HashMap<String, Set<ClassPath>>(this.registeredClasspaths);
            this.registeredClasspaths = null;
        }
        GlobalPathRegistry gpr = GlobalPathRegistry.getDefault();
        for (String type : TYPES) {
            Set registeredClasspathsOfType = (Set)toUnregister.get(type);
            gpr.unregister(type, registeredClasspathsOfType.toArray(new ClassPath[0]));
        }
    }

    static List<String> findPackageRootNames(Element compilationUnitEl) {
        ArrayList<String> names = new ArrayList<String>();
        for (Element e : XMLUtil.findSubElements((Element)compilationUnitEl)) {
            if (!e.getLocalName().equals("package-root")) continue;
            String location = XMLUtil.findText((Node)e);
            names.add(location);
        }
        return names;
    }

    static Map<String, FileObject> findPackageRootsByName(AntProjectHelper helper, PropertyEvaluator evaluator, List<String> packageRootNames) {
        LinkedHashMap<String, FileObject> roots = new LinkedHashMap<String, FileObject>();
        for (String location : packageRootNames) {
            File locationFile;
            FileObject locationFileObject;
            String locationEval = evaluator.evaluate(location);
            if (locationEval == null || (locationFileObject = FileUtil.toFileObject((File)(locationFile = helper.resolveFile(locationEval)))) == null) continue;
            if (FileUtil.isArchiveFile((FileObject)locationFileObject)) {
                locationFileObject = FileUtil.getArchiveRoot((FileObject)locationFileObject);
            }
            roots.put(location, locationFileObject);
        }
        return roots;
    }

    private static List<FileObject> findPackageRoots(AntProjectHelper helper, PropertyEvaluator evaluator, List<String> packageRootNames) {
        return new ArrayList<FileObject>(Classpaths.findPackageRootsByName(helper, evaluator, packageRootNames).values());
    }

    public static List<FileObject> findPackageRoots(AntProjectHelper helper, PropertyEvaluator evaluator, Element compilationUnitEl) {
        return Classpaths.findPackageRoots(helper, evaluator, Classpaths.findPackageRootNames(compilationUnitEl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getPath(Element compilationUnitEl, List<FileObject> packageRoots, String type) {
        if (type.equals("classpath/source") || type.equals("classpath/compile") || type.equals("classpath/execute") || type.equals("classpath/boot") || type.equals("classpath/processor")) {
            List<String> packageRootNames = Classpaths.findPackageRootNames(compilationUnitEl);
            Classpaths classpaths = this;
            synchronized (classpaths) {
                ClassPath cp;
                MutableClassPathImplementation impl;
                Map<List<String>, MutableClassPathImplementation> mutablePathImplsByType = this.mutablePathImpls.get(type);
                if (mutablePathImplsByType == null) {
                    mutablePathImplsByType = new HashMap<List<String>, MutableClassPathImplementation>();
                    this.mutablePathImpls.put(type, mutablePathImplsByType);
                }
                if ((impl = mutablePathImplsByType.get(packageRootNames)) == null) {
                    impl = new MutableClassPathImplementation(packageRootNames, type, compilationUnitEl);
                    mutablePathImplsByType.put(packageRootNames, impl);
                }
                if ((cp = this.mutableClassPathImpl2ClassPath.get(impl)) == null) {
                    cp = ClassPathFactory.createClassPath((ClassPathImplementation)impl);
                    this.mutableClassPathImpl2ClassPath.put(impl, cp);
                    this.registerNewClasspath(type, cp);
                }
                return cp;
            }
        }
        return null;
    }

    private List<URL> createSourcePath(List<String> packageRootNames) {
        ArrayList<URL> roots = new ArrayList<URL>(packageRootNames.size());
        for (String location : packageRootNames) {
            String locationEval = this.evaluator.evaluate(location);
            if (locationEval == null) continue;
            roots.add(this.createClasspathEntry(locationEval));
        }
        return roots;
    }

    private List<URL> createCompileClasspath(Element compilationUnitEl) {
        for (Element e : XMLUtil.findSubElements((Element)compilationUnitEl)) {
            if (!e.getLocalName().equals("classpath") || !e.getAttribute("mode").equals("compile")) continue;
            return this.createClasspath(e, new RemoveSources(this.helper, this.sfbqImpl));
        }
        return Collections.emptyList();
    }

    private List<URL> createClasspath(Element classpathEl, Function<URL, Collection<URL>> translate) {
        String cpEval;
        String cp = XMLUtil.findText((Node)classpathEl);
        if (cp == null) {
            cp = "";
        }
        if ((cpEval = this.evaluator.evaluate(cp)) == null) {
            return Collections.emptyList();
        }
        String[] path = PropertyUtils.tokenizePath((String)cpEval);
        ArrayList<URL> res = new ArrayList<URL>();
        for (String pathElement : path) {
            res.addAll(translate.apply(this.createClasspathEntry(pathElement)));
        }
        return res;
    }

    private URL createClasspathEntry(String text) {
        File entryFile = this.helper.resolveFile(text);
        return FileUtil.urlForArchiveOrDir((File)entryFile);
    }

    private List<URL> createExecuteClasspath(List<String> packageRoots, Element compilationUnitEl) {
        for (Element e : XMLUtil.findSubElements((Element)compilationUnitEl)) {
            if (!e.getLocalName().equals("classpath") || !e.getAttribute("mode").equals("execute")) continue;
            return this.createClasspath(e, new RemoveSources(this.helper, this.sfbqImpl));
        }
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        urls.addAll(this.createCompileClasspath(compilationUnitEl));
        Project prj = FileOwnerQuery.getOwner((FileObject)this.helper.getProjectDirectory());
        if (prj != null) {
            for (URL src : this.createSourcePath(packageRoots)) {
                urls.addAll(this.sfbqImpl.findBinaryRoots(src));
            }
        }
        return new ArrayList<URL>(urls);
    }

    private List<URL> createProcessorClasspath(Element compilationUnitEl) {
        Element path;
        Element ap = XMLUtil.findElement((Element)compilationUnitEl, (String)"annotation-processing", (String)"http://www.netbeans.org/ns/freeform-project-java/5");
        if (ap != null && (path = XMLUtil.findElement((Element)ap, (String)"processor-path", (String)"http://www.netbeans.org/ns/freeform-project-java/5")) != null) {
            return this.createClasspath(path, new RemoveSources(this.helper, this.sfbqImpl));
        }
        return this.createCompileClasspath(compilationUnitEl);
    }

    private List<URL> createBootClasspath(Element compilationUnitEl) {
        for (Element e : XMLUtil.findSubElements((Element)compilationUnitEl)) {
            if (!e.getLocalName().equals("classpath") || !e.getAttribute("mode").equals("boot")) continue;
            return this.createClasspath(e, new Function<URL, Collection<URL>>(){

                @Override
                public Collection<URL> apply(URL p) {
                    return Collections.singleton(p);
                }
            });
        }
        JavaPlatform platform = new JdkConfiguration(null, this.helper, this.evaluator).getSelectedPlatform();
        if (platform == null) {
            JavaPlatformManager jpm = JavaPlatformManager.getDefault();
            platform = jpm.getDefaultPlatform();
        }
        if (platform != null) {
            List entries = platform.getBootstrapLibraries().entries();
            ArrayList<URL> urls = new ArrayList<URL>(entries.size());
            for (ClassPath.Entry entry : entries) {
                urls.add(entry.getURL());
            }
            return urls;
        }
        assert (false) : "JavaPlatformManager has no default platform";
        return Collections.emptyList();
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.pathsChanged();
    }

    public void propertiesChanged(AntProjectEvent ev) {
        this.pathsChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.pathsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pathsChanged() {
        Classpaths classpaths = this;
        synchronized (classpaths) {
            this.classpaths.clear();
            for (Map<List<String>, MutableClassPathImplementation> m : this.mutablePathImpls.values()) {
                for (MutableClassPathImplementation impl : m.values()) {
                    impl.change();
                }
            }
        }
    }

    private final class MutableClassPathImplementation
    implements ClassPathImplementation {
        private final List<String> packageRootNames;
        private final String type;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private List<URL> roots;
        private List<PathResourceImplementation> resources;

        public MutableClassPathImplementation(List<String> packageRootNames, String type, Element initialCompilationUnit) {
            this.packageRootNames = packageRootNames;
            this.type = type;
            this.initRoots(initialCompilationUnit);
        }

        private Element findCompilationUnit() {
            Element java = Classpaths.this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/5", true);
            if (java == null) {
                return null;
            }
            List compilationUnits = XMLUtil.findSubElements((Element)java);
            for (Element compilationUnitEl : compilationUnits) {
                assert (compilationUnitEl.getLocalName().equals("compilation-unit")) : compilationUnitEl;
                if (!this.packageRootNames.equals(Classpaths.findPackageRootNames(compilationUnitEl))) continue;
                return compilationUnitEl;
            }
            return null;
        }

        private boolean initRoots(Element compilationUnitEl) {
            List<URL> oldRoots = this.roots;
            if (compilationUnitEl != null) {
                if (this.type.equals("classpath/source")) {
                    this.roots = Classpaths.this.createSourcePath(this.packageRootNames);
                } else if (this.type.equals("classpath/compile")) {
                    this.roots = Classpaths.this.createCompileClasspath(compilationUnitEl);
                } else if (this.type.equals("classpath/execute")) {
                    this.roots = Classpaths.this.createExecuteClasspath(this.packageRootNames, compilationUnitEl);
                } else if (this.type.equals("classpath/processor")) {
                    this.roots = Classpaths.this.createProcessorClasspath(compilationUnitEl);
                } else {
                    assert (this.type.equals("classpath/boot")) : this.type;
                    this.roots = Classpaths.this.createBootClasspath(compilationUnitEl);
                }
            } else {
                this.roots = Collections.emptyList();
            }
            assert (this.roots != null);
            if (!this.roots.equals(oldRoots)) {
                this.resources = new ArrayList<PathResourceImplementation>(this.roots.size());
                for (URL root : this.roots) {
                    if (root == null) continue;
                    assert (root.toExternalForm().endsWith("/")) : "Had bogus roots " + this.roots + " for type " + this.type + " in " + Classpaths.access$800(Classpaths.this).getProjectDirectory();
                    Object pri = this.type.equals("classpath/source") ? new SourcePRI(root) : ClassPathSupport.createResource((URL)root);
                    this.resources.add((PathResourceImplementation)pri);
                }
                return true;
            }
            return false;
        }

        public List<PathResourceImplementation> getResources() {
            assert (this.resources != null);
            return this.resources;
        }

        public void change() {
            if (this.initRoots(this.findCompilationUnit())) {
                if (err.isLoggable(1)) {
                    err.log("MutableClassPathImplementation.change: packageRootNames=" + this.packageRootNames + " type=" + this.type + " roots=" + this.roots);
                }
                this.pcs.firePropertyChange("resources", null, null);
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    private static final class RemoveSources
    implements Function<URL, Collection<URL>> {
        private final Set<URL> sourceRoots = new HashSet<URL>();
        private final SourceForBinaryQueryImpl sfbqImpl;

        RemoveSources(@NonNull AntProjectHelper helper, @NonNull SourceForBinaryQueryImpl sfbqImpl) {
            this.sfbqImpl = sfbqImpl;
            Project prj = FileOwnerQuery.getOwner((FileObject)helper.getProjectDirectory());
            if (prj != null) {
                for (SourceGroup sg : ProjectUtils.getSources((Project)prj).getSourceGroups("java")) {
                    FileObject root = sg.getRootFolder();
                    if (root == null) continue;
                    this.sourceRoots.add(root.toURL());
                }
            }
        }

        @Override
        public Collection<URL> apply(URL p) {
            Collection<URL> res = Collections.emptySet();
            if (this.sourceRoots.contains(p)) {
                res = this.sfbqImpl.findBinaryRoots(p);
            }
            if (res.isEmpty()) {
                res = Collections.singletonList(p);
            }
            return res;
        }
    }

    private final class SourcePRI
    implements FilteringPathResourceImplementation,
    PropertyChangeListener,
    AntProjectListener {
        private final URL root;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private PathMatcher matcher;
        private String includes;
        private String excludes;

        public SourcePRI(URL root) {
            this.root = root;
            Classpaths.this.helper.addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this, (Object)Classpaths.this.helper));
            Classpaths.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)Classpaths.this.evaluator));
            this.computeMatcher();
        }

        private boolean computeMatcher() {
            File rootFolder;
            String incl = null;
            String excl = null;
            URI rootURI = URI.create(this.root.toExternalForm());
            try {
                rootFolder = Utilities.toFile((URI)rootURI);
            }
            catch (IllegalArgumentException x) {
                Logger.getLogger(Classpaths.class.getName()).warning("Illegal source root: " + rootURI);
                rootFolder = null;
            }
            Element genldata = Util.getPrimaryConfigurationData((AntProjectHelper)Classpaths.this.helper);
            Element foldersE = XMLUtil.findElement((Element)genldata, (String)"folders", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (foldersE != null) {
                for (Element folderE : XMLUtil.findSubElements((Element)foldersE)) {
                    Element excludesE;
                    String type;
                    Element typeE;
                    if (!folderE.getLocalName().equals("source-folder") || (typeE = XMLUtil.findElement((Element)folderE, (String)"type", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null || !(type = XMLUtil.findText((Node)typeE)).equals("java")) continue;
                    Element locationE = XMLUtil.findElement((Element)folderE, (String)"location", (String)"http://www.netbeans.org/ns/freeform-project/2");
                    String location = Classpaths.this.evaluator.evaluate(XMLUtil.findText((Node)locationE));
                    if (location == null || !Classpaths.this.helper.resolveFile(location).equals(rootFolder)) continue;
                    Element includesE = XMLUtil.findElement((Element)folderE, (String)"includes", (String)"http://www.netbeans.org/ns/freeform-project/2");
                    if (includesE != null && (incl = Classpaths.this.evaluator.evaluate(XMLUtil.findText((Node)includesE))) != null && incl.matches("\\$\\{[^}]+\\}")) {
                        incl = null;
                    }
                    if ((excludesE = XMLUtil.findElement((Element)folderE, (String)"excludes", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null) continue;
                    excl = Classpaths.this.evaluator.evaluate(XMLUtil.findText((Node)excludesE));
                }
            }
            if (!Utilities.compareObjects(incl, (Object)this.includes) || !Utilities.compareObjects(excl, (Object)this.excludes)) {
                this.includes = incl;
                this.excludes = excl;
                this.matcher = new PathMatcher(incl, excl, rootFolder);
                return true;
            }
            if (this.matcher == null) {
                this.matcher = new PathMatcher(incl, excl, rootFolder);
            }
            return false;
        }

        public URL[] getRoots() {
            return new URL[]{this.root};
        }

        public boolean includes(URL root, String resource) {
            return this.matcher.matches(resource, true);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        public ClassPathImplementation getContent() {
            return null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            this.change(ev);
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            this.change(ev);
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }

        private void change(Object propid) {
            if (this.computeMatcher()) {
                PropertyChangeEvent ev = new PropertyChangeEvent(this, "includes", null, null);
                ev.setPropagationId(propid);
                this.pcs.firePropertyChange(ev);
            }
        }
    }
}

