/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.ContainedProjectFilter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.spi.actions.ReplaceTokenProvider;
import org.openide.util.Lookup;

public class ProjectsTokenProvider
implements ReplaceTokenProvider {
    private static final String TASK_WITH_PROJECTS = "taskWithProjects";
    private static final Set<String> SUPPORTED = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("taskWithProjects")));

    public Set<String> getSupportedTokens() {
        return SUPPORTED;
    }

    public Map<String, String> createReplacements(String action, Lookup context) {
        String taskName = this.getTaskForAction(action);
        if (taskName == null) {
            return new HashMap<String, String>();
        }
        return this.getProjectsWithTaskReplacement(taskName, context);
    }

    private String getTaskForAction(String action) {
        return switch (action) {
            case "test.parallel" -> "test";
            default -> null;
        };
    }

    private Map<String, String> getProjectsWithTaskReplacement(String taskName, Lookup context) {
        List projects;
        ContainedProjectFilter parameters = (ContainedProjectFilter)context.lookup(ContainedProjectFilter.class);
        List list = projects = parameters == null ? null : parameters.getProjectsToProcess();
        if (projects == null || projects.isEmpty()) {
            return Map.of(TASK_WITH_PROJECTS, taskName);
        }
        StringBuilder resultTask = new StringBuilder();
        List<String> projectReplacements = this.createProjectsReplacement(projects);
        for (String project : projectReplacements) {
            resultTask.append(project).append(":").append(taskName).append(" ");
        }
        return Map.of(TASK_WITH_PROJECTS, resultTask.toString().trim());
    }

    private List<String> createProjectsReplacement(List<Project> projects) {
        return projects.stream().map(prj -> prj.getProjectDirectory().getName()).toList();
    }
}

