/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.JspServletDataObject;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;

public class ServletEditor
extends CloneableEditorSupport
implements EditorCookie.Observable,
CloseCookie,
PrintCookie,
PropertyChangeListener {
    static final String ATTR_FILE_ENCODING = "Content-Encoding";

    public ServletEditor(JspDataObject jspdo) {
        super((CloneableEditorSupport.Env)new JspEnv(jspdo));
        jspdo.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jspdo));
    }

    protected CloneableEditor createCloneableEditor() {
        return new ServletEditorComponent(this);
    }

    protected JspEnv jspEnv() {
        return (JspEnv)this.env;
    }

    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        FileObject fo = this.getServlet().getPrimaryFile();
        String encoding = (String)fo.getAttribute(ATTR_FILE_ENCODING);
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        InputStreamReader reader = new InputStreamReader(stream, encoding);
        kit.read(reader, (Document)doc, 0);
    }

    protected JspServletDataObject getServlet() {
        return this.jspEnv().getJspDataObject().getServletDataObject();
    }

    protected String messageSave() {
        return "";
    }

    protected String messageName() {
        JspServletDataObject dobj = this.getServlet();
        if (dobj == null) {
            return "...";
        }
        if (!dobj.isValid()) {
            return "";
        }
        if (DataNode.getShowFileExtensions()) {
            return dobj.getPrimaryFile().getNameExt();
        }
        return dobj.getPrimaryFile().getName();
    }

    protected String messageToolTip() {
        JspServletDataObject dobj = this.getServlet();
        if (dobj != null) {
            return FileUtil.getFileDisplayName((FileObject)dobj.getPrimaryFile());
        }
        return "...";
    }

    protected String messageOpening() {
        JspServletDataObject obj = this.getServlet();
        if (obj == null) {
            return "";
        }
        return NbBundle.getMessage(ServletEditor.class, (String)"CTL_ObjectOpen", (Object)obj.getPrimaryFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)obj.getPrimaryFile()));
    }

    protected String messageOpened() {
        JspServletDataObject obj = this.getServlet();
        if (obj == null) {
            return "";
        }
        return NbBundle.getMessage(ServletEditor.class, (String)"CTL_ObjectOpened", (Object)obj.getPrimaryFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)obj.getPrimaryFile()));
    }

    MultiDataObject.Entry getJavaEntry() {
        return this.getServlet().getPrimaryEntry();
    }

    protected StyledDocument createStyledDocument(EditorKit kit) {
        StyledDocument doc = super.createStyledDocument(kit);
        this.setDocumentProperties(doc);
        return doc;
    }

    void setDocumentProperties(Document doc) {
        JspServletDataObject obj = this.getServlet();
        if (obj != null) {
            doc.putProperty("title", obj.getPrimaryFile().getPath());
            doc.putProperty("stream", (Object)obj);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        StyledDocument doc;
        if (evt.getPropertyName().equals("servlet_do") && (doc = this.getDocument()) != null) {
            this.setDocumentProperties(doc);
        }
    }

    private static class JspEnv
    extends FileChangeAdapter
    implements CloneableEditorSupport.Env,
    Serializable,
    PropertyChangeListener {
        private static final long serialVersionUID = -5748207023470614141L;
        protected JspDataObject jspdo;
        private DataObject servlet;
        private transient PropertyChangeSupport propSupp;

        public JspEnv(JspDataObject jspdo) {
            this.jspdo = jspdo;
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DataObject getServlet() {
            JspDataObject jspDataObject = this.jspdo;
            synchronized (jspDataObject) {
                JspServletDataObject newServlet = this.jspdo.getServletDataObject();
                if (this.servlet != newServlet) {
                    if (this.servlet != null) {
                        this.servlet.getPrimaryFile().removeFileChangeListener((FileChangeListener)this);
                    }
                    if (newServlet != null) {
                        newServlet.getPrimaryFile().addFileChangeListener((FileChangeListener)this);
                    }
                    this.servlet = newServlet;
                }
                return this.servlet;
            }
        }

        private void init() {
            this.jspdo.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.jspdo));
        }

        public JspDataObject getJspDataObject() {
            return this.jspdo;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if ("servlet_do".equals(ev.getPropertyName())) {
                DataObject servlet = this.getServlet();
                if (servlet == null) {
                    this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
                } else {
                    this.firePropertyChange("time", null, null);
                }
            }
            this.firePropertyChange(ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
        }

        protected void firePropertyChange(String name, Object oldValue, Object newValue) {
            this.prop().firePropertyChange(name, oldValue, newValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PropertyChangeSupport prop() {
            JspEnv jspEnv = this;
            synchronized (jspEnv) {
                if (this.propSupp == null) {
                    this.propSupp = new PropertyChangeSupport(this);
                }
                return this.propSupp;
            }
        }

        public InputStream inputStream() throws IOException {
            DataObject servlet = this.getServlet();
            if (servlet != null) {
                return servlet.getPrimaryFile().getInputStream();
            }
            return null;
        }

        public OutputStream outputStream() throws IOException {
            return null;
        }

        public Date getTime() {
            DataObject servlet = this.getServlet();
            if (servlet != null) {
                return servlet.getPrimaryFile().lastModified();
            }
            return new Date(System.currentTimeMillis());
        }

        public String getMimeType() {
            return "text/x-java";
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.prop().addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.prop().removePropertyChangeListener(l);
        }

        public void addVetoableChangeListener(VetoableChangeListener l) {
        }

        public void removeVetoableChangeListener(VetoableChangeListener l) {
        }

        public boolean isValid() {
            DataObject servlet = this.getServlet();
            return servlet != null;
        }

        public boolean isModified() {
            return false;
        }

        public void markModified() throws IOException {
        }

        public void unmarkModified() {
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.jspdo.getServletEditor();
        }

        public void fileDeleted(FileEvent fe) {
            fe.getFile().removeFileChangeListener((FileChangeListener)this);
            this.jspdo.refreshPlugin(true);
        }

        public void fileChanged(FileEvent fe) {
            this.firePropertyChange("time", null, null);
        }
    }

    public static class ServletEditorComponent
    extends CloneableEditor {
        static final int SELECTED_NODES_DELAY = 1000;
        Timer timerSelNodes;
        CaretListener caretListener;
        int lastCaretOffset = -1;

        public ServletEditorComponent() {
        }

        public ServletEditorComponent(ServletEditor support) {
            super((CloneableEditorSupport)support);
            this.init();
        }

        protected void componentShowing() {
            super.componentShowing();
            this.pane.setEditable(false);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.init();
        }

        protected JEditorPane getPane() {
            return this.pane;
        }

        private void init() {
            ServletEditor se;
            if (null != this.getPane()) {
                this.getPane().setEditable(false);
            }
            if ((se = (ServletEditor)this.cloneableEditorSupport()) != null) {
                se.jspEnv().addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("time".equals(evt.getPropertyName())) {
                            this.initializeJavaNodes();
                        }
                        this.updateName();
                    }
                });
            }
            this.initializeJavaNodes();
        }

        protected void componentActivated() {
            this.pane.addCaretListener(this.caretListener);
            super.componentActivated();
        }

        void selectElementsAtOffset(int offset) {
            ServletEditor se = (ServletEditor)this.cloneableEditorSupport();
            if (se != null) {
                JspDataObject jspdo = se.jspEnv().getJspDataObject();
                if (SwingUtilities.isEventDispatchThread()) {
                    this.setNodes(jspdo, offset);
                } else {
                    SwingUtilities.invokeLater(new NodesThread(jspdo, offset));
                }
            }
        }

        private void setNodes(JspDataObject jspdo, int offset) {
            JspServletDataObject servlet = jspdo.getServletDataObject();
            if (servlet == null) {
                this.setActivatedNodes(new Node[]{jspdo.getNodeDelegate()});
                return;
            }
        }

        private void initializeJavaNodes() {
            Caret caret;
            ServletEditor se = (ServletEditor)this.cloneableEditorSupport();
            if (se != null) {
                this.timerSelNodes = new Timer(100, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Caret caret;
                        if (lastCaretOffset == -1 && pane != null && (caret = pane.getCaret()) != null) {
                            lastCaretOffset = caret.getDot();
                        }
                        this.selectElementsAtOffset(lastCaretOffset);
                    }
                });
                this.timerSelNodes.setInitialDelay(100);
                this.timerSelNodes.setRepeats(false);
                this.timerSelNodes.restart();
                this.caretListener = new CaretListener(){

                    @Override
                    public void caretUpdate(CaretEvent e) {
                        this.restartTimerSelNodes(e.getDot());
                    }
                };
            }
            if (this.lastCaretOffset == -1 && this.pane != null && (caret = this.pane.getCaret()) != null) {
                this.lastCaretOffset = caret.getDot();
            }
            this.selectElementsAtOffset(this.lastCaretOffset);
        }

        public SystemAction[] getSystemActions() {
            this.selectElementsAtOffset(this.lastCaretOffset);
            this.timerSelNodes.stop();
            return super.getSystemActions();
        }

        void restartTimerSelNodes(int pos) {
            this.timerSelNodes.setInitialDelay(1000);
            this.timerSelNodes.restart();
            this.lastCaretOffset = pos;
        }

        private class NodesThread
        implements Runnable {
            JspDataObject jspdo;
            int offset;

            NodesThread(JspDataObject jspdo, int offset) {
                this.jspdo = jspdo;
                this.offset = offset;
            }

            @Override
            public void run() {
                ServletEditorComponent.this.setNodes(this.jspdo, this.offset);
            }
        }
    }
}

