/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateVnicDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateVnicRequest
extends BmcRequest<UpdateVnicDetails> {
    private String vnicId;
    private UpdateVnicDetails updateVnicDetails;
    private String ifMatch;

    public String getVnicId() {
        return this.vnicId;
    }

    public UpdateVnicDetails getUpdateVnicDetails() {
        return this.updateVnicDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateVnicDetails getBody$() {
        return this.updateVnicDetails;
    }

    public Builder toBuilder() {
        return new Builder().vnicId(this.vnicId).updateVnicDetails(this.updateVnicDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",vnicId=").append(String.valueOf(this.vnicId));
        sb.append(",updateVnicDetails=").append(String.valueOf((Object)this.updateVnicDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateVnicRequest)) {
            return false;
        }
        UpdateVnicRequest other = (UpdateVnicRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.vnicId, other.vnicId) && Objects.equals((Object)this.updateVnicDetails, (Object)other.updateVnicDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vnicId == null ? 43 : this.vnicId.hashCode());
        result = result * 59 + (this.updateVnicDetails == null ? 43 : this.updateVnicDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateVnicRequest, UpdateVnicDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String vnicId = null;
        private UpdateVnicDetails updateVnicDetails = null;
        private String ifMatch = null;

        public Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            return this;
        }

        public Builder updateVnicDetails(UpdateVnicDetails updateVnicDetails) {
            this.updateVnicDetails = updateVnicDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateVnicRequest o) {
            this.vnicId(o.getVnicId());
            this.updateVnicDetails(o.getUpdateVnicDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateVnicRequest build() {
            UpdateVnicRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateVnicDetails body) {
            this.updateVnicDetails(body);
            return this;
        }

        public UpdateVnicRequest buildWithoutInvocationCallback() {
            UpdateVnicRequest request = new UpdateVnicRequest();
            request.vnicId = this.vnicId;
            request.updateVnicDetails = this.updateVnicDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

