/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HeadBucketResponse
extends BmcResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String eTag;
    private boolean isNotModified;

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public boolean isNotModified() {
        return this.isNotModified;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcClientRequestId", "opcRequestId", "eTag", "isNotModified"})
    private HeadBucketResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcClientRequestId, String opcRequestId, String eTag, boolean isNotModified) {
        super(__httpStatusCode__, headers);
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.eTag = eTag;
        this.isNotModified = isNotModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",eTag=").append(String.valueOf(this.eTag));
        sb.append(",isNotModified=").append(this.isNotModified);
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeadBucketResponse)) {
            return false;
        }
        HeadBucketResponse other = (HeadBucketResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.eTag, other.eTag) && this.isNotModified == other.isNotModified;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.eTag == null ? 43 : this.eTag.hashCode());
        result = result * 59 + (this.isNotModified ? 79 : 97);
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<HeadBucketResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcClientRequestId;
        private String opcRequestId;
        private String eTag;
        private boolean isNotModified;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder isNotModified(boolean isNotModified) {
            this.isNotModified = isNotModified;
            return this;
        }

        public Builder copy(HeadBucketResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.eTag(o.getETag());
            this.isNotModified(o.isNotModified());
            return this;
        }

        public HeadBucketResponse build() {
            return new HeadBucketResponse(this.__httpStatusCode__, this.headers, this.opcClientRequestId, this.opcRequestId, this.eTag, this.isNotModified);
        }
    }
}

