/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.DecompilationMode;
import jadx.gui.jobs.BackgroundExecutor;
import jadx.gui.treemodel.JClass;
import jadx.gui.ui.TabbedPane;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.AbstractCodeContentPanel;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.codearea.CodePanel;
import jadx.gui.ui.codearea.EditorViewState;
import jadx.gui.ui.codearea.SmaliArea;
import jadx.gui.ui.codearea.mode.JCodeMode;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.panel.IViewStateSupport;
import jadx.gui.utils.NLS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JCheckBox;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassCodeContentPanel
extends AbstractCodeContentPanel
implements IViewStateSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ClassCodeContentPanel.class);
    private static final long serialVersionUID = -7229931102504634591L;
    private final transient CodePanel javaCodePanel;
    private final transient CodePanel smaliCodePanel;
    private final transient JTabbedPane areaTabbedPane;
    private boolean splitView = false;

    public ClassCodeContentPanel(TabbedPane panel, JClass jCls) {
        super(panel, jCls);
        this.javaCodePanel = new CodePanel(new CodeArea(this, jCls));
        this.smaliCodePanel = new CodePanel(new SmaliArea((ContentPanel)this, jCls));
        this.areaTabbedPane = this.buildTabbedPane(jCls, false);
        this.addCustomControls(this.areaTabbedPane);
        this.initView();
        this.javaCodePanel.load();
    }

    private void initView() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (this.splitView) {
            JTabbedPane splitPaneView = this.buildTabbedPane((JClass)this.node, true);
            JSplitPane splitPane = new JSplitPane(1, this.areaTabbedPane, splitPaneView);
            this.add(splitPane);
            splitPane.setDividerLocation(0.5);
            splitPaneView.setSelectedIndex(1);
        } else {
            this.add(this.areaTabbedPane);
        }
        this.invalidate();
    }

    private JTabbedPane buildTabbedPane(JClass jCls, boolean split) {
        JTabbedPane areaTabbedPane = new JTabbedPane(3);
        areaTabbedPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        areaTabbedPane.setTabLayoutPolicy(1);
        if (split) {
            areaTabbedPane.add((Component)new CodePanel(new CodeArea(this, jCls)), NLS.str("tabs.code"));
            areaTabbedPane.add((Component)new CodePanel(new SmaliArea((ContentPanel)this, jCls)), NLS.str("tabs.smali"));
        } else {
            areaTabbedPane.add((Component)this.javaCodePanel, NLS.str("tabs.code"));
            areaTabbedPane.add((Component)this.smaliCodePanel, NLS.str("tabs.smali"));
        }
        areaTabbedPane.add((Component)new CodePanel(new CodeArea(this, new JCodeMode(jCls, DecompilationMode.SIMPLE))), "Simple");
        areaTabbedPane.add((Component)new CodePanel(new CodeArea(this, new JCodeMode(jCls, DecompilationMode.FALLBACK))), "Fallback");
        areaTabbedPane.addChangeListener(e -> {
            CodePanel selectedPanel = (CodePanel)areaTabbedPane.getSelectedComponent();
            selectedPanel.load();
        });
        return areaTabbedPane;
    }

    private void addCustomControls(JTabbedPane tabbedPane) {
        JCheckBox splitCheckBox = new JCheckBox("Split view", this.splitView);
        splitCheckBox.addItemListener(e -> {
            this.splitView = splitCheckBox.isSelected();
            this.initView();
        });
        JToolBar trailing = new JToolBar();
        trailing.setFloatable(false);
        trailing.setBorder(null);
        trailing.addSeparator(new Dimension(50, 1));
        trailing.add(splitCheckBox);
        tabbedPane.putClientProperty("JTabbedPane.trailingComponent", trailing);
    }

    private void execInBackground(Runnable runnable) {
        BackgroundExecutor bgExec = this.tabbedPane.getMainWindow().getBackgroundExecutor();
        bgExec.execute("Loading", runnable);
    }

    @Override
    public void loadSettings() {
        this.javaCodePanel.loadSettings();
        this.smaliCodePanel.loadSettings();
        this.updateUI();
    }

    @Override
    public AbstractCodeArea getCodeArea() {
        return this.javaCodePanel.getCodeArea();
    }

    public CodePanel getJavaCodePanel() {
        return this.javaCodePanel;
    }

    public void switchPanel() {
        boolean toSmali = this.areaTabbedPane.getSelectedComponent() == this.javaCodePanel;
        this.areaTabbedPane.setSelectedComponent(toSmali ? this.smaliCodePanel : this.javaCodePanel);
    }

    public AbstractCodeArea getCurrentCodeArea() {
        return ((CodePanel)this.areaTabbedPane.getSelectedComponent()).getCodeArea();
    }

    public AbstractCodeArea getSmaliCodeArea() {
        return this.smaliCodePanel.getCodeArea();
    }

    public void showSmaliPane() {
        this.areaTabbedPane.setSelectedComponent(this.smaliCodePanel);
    }

    @Override
    public EditorViewState getEditorViewState() {
        CodePanel codePanel = (CodePanel)this.areaTabbedPane.getSelectedComponent();
        int caretPos = codePanel.getCodeArea().getCaretPosition();
        Point viewPoint = codePanel.getCodeScrollPane().getViewport().getViewPosition();
        String subPath = codePanel == this.javaCodePanel ? "java" : "smali";
        return new EditorViewState(this.getNode(), subPath, caretPos, viewPoint);
    }

    @Override
    public void restoreEditorViewState(EditorViewState viewState) {
        boolean isJava = viewState.getSubPath().equals("java");
        CodePanel activePanel = isJava ? this.javaCodePanel : this.smaliCodePanel;
        this.areaTabbedPane.setSelectedComponent(activePanel);
        try {
            activePanel.getCodeScrollPane().getViewport().setViewPosition(viewState.getViewPoint());
        }
        catch (Exception e) {
            LOG.debug("Failed to restore view position: {}", (Object)viewState.getViewPoint(), (Object)e);
        }
        int caretPos = viewState.getCaretPos();
        try {
            AbstractCodeArea codeArea = activePanel.getCodeArea();
            int codeLen = codeArea.getDocument().getLength();
            if (caretPos >= 0 && caretPos < codeLen) {
                codeArea.setCaretPosition(caretPos);
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to restore caret position: {}", (Object)caretPos, (Object)e);
        }
    }

    @Override
    public void dispose() {
        this.javaCodePanel.dispose();
        this.smaliCodePanel.dispose();
        for (Component component : this.areaTabbedPane.getComponents()) {
            if (!(component instanceof CodePanel)) continue;
            ((CodePanel)component).dispose();
        }
        super.dispose();
    }
}

