/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.server;

import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import org.eclipse.jetty.compression.Compression;
import org.eclipse.jetty.compression.server.CompressionConfig;
import org.eclipse.jetty.compression.server.internal.CompressionResponse;
import org.eclipse.jetty.compression.server.internal.DecompressionRequest;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.EtagUtils;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.QuotedQualityCSV;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionHandler
extends Handler.Wrapper {
    public static final String HANDLER_ETAGS = CompressionHandler.class.getPackageName() + ".ETag";
    private static final Logger LOG = LoggerFactory.getLogger(CompressionHandler.class);
    private final HttpField varyAcceptEncoding = new PreEncodedHttpField(HttpHeader.VARY, HttpHeader.ACCEPT_ENCODING.asString());
    private final Map<String, Compression> supportedEncodings = new TreeMap<String, Compression>(String.CASE_INSENSITIVE_ORDER);
    private final PathMappings<CompressionConfig> pathConfigs = new PathMappings();

    public CompressionHandler() {
        this.installBean(this.pathConfigs);
    }

    public CompressionHandler(Handler handler) {
        super(handler);
        this.installBean(this.pathConfigs);
    }

    public Compression putCompression(Compression compression) {
        Compression previous = this.supportedEncodings.put(compression.getEncodingName(), compression);
        compression.setContainer((Container)this);
        this.updateBean(previous, compression, true);
        return previous;
    }

    public Compression removeCompression(String encodingName) {
        Compression compression = this.supportedEncodings.remove(encodingName);
        this.removeBean(compression);
        return compression;
    }

    public CompressionConfig ensureConfiguration(PathSpec pathSpec) {
        return (CompressionConfig)((Object)this.pathConfigs.computeIfAbsent((Object)pathSpec, spec -> CompressionConfig.builder().build()));
    }

    public CompressionConfig ensureConfiguration(String pathSpecString) {
        PathSpec pathSpec = PathSpec.from((String)pathSpecString);
        return this.ensureConfiguration(pathSpec);
    }

    public CompressionConfig getConfiguration(PathSpec pathSpec) {
        return (CompressionConfig)((Object)this.pathConfigs.get(pathSpec));
    }

    public CompressionConfig getConfiguration(String pathSpecString) {
        PathSpec pathSpec = PathSpec.from((String)pathSpecString);
        return this.getConfiguration(pathSpec);
    }

    public CompressionConfig putConfiguration(PathSpec pathSpec, CompressionConfig config) {
        return (CompressionConfig)((Object)this.pathConfigs.put(pathSpec, (Object)config));
    }

    public CompressionConfig putConfiguration(String pathSpecString, CompressionConfig config) {
        PathSpec pathSpec = PathSpec.from((String)pathSpecString);
        return this.putConfiguration(pathSpec, config);
    }

    protected void doStart() throws Exception {
        if (this.supportedEncodings.isEmpty()) {
            TypeUtil.serviceStream(ServiceLoader.load(Compression.class)).forEach(this::putCompression);
        }
        this.supportedEncodings.values().forEach(compression -> {
            if (compression.getByteBufferPool() == null) {
                compression.setByteBufferPool(this.getServer().getByteBufferPool());
            }
        });
        if (this.pathConfigs.isEmpty()) {
            this.pathConfigs.put("/", (Object)CompressionConfig.builder().defaults().build());
        }
        super.doStart();
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String compressEncoding;
        Handler next;
        if (LOG.isDebugEnabled()) {
            LOG.debug("handling {} {} {}", new Object[]{request, response, this});
        }
        if ((next = this.getHandler()) == null) {
            return false;
        }
        if (Request.as((Request)request, DecompressionRequest.class) != null) {
            return next.handle(request, response, callback);
        }
        String pathInContext = Request.getPathInContext((Request)request);
        MatchedResource matchedConfig = this.pathConfigs.getMatched(pathInContext);
        if (matchedConfig == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("skipping compression: path {} has no matching compression config", (Object)pathInContext);
            }
            return next.handle(request, response, callback);
        }
        CompressionConfig config = (CompressionConfig)((Object)matchedConfig.getResource());
        String requestContentEncoding = null;
        List requestAcceptEncoding = List.of();
        boolean etagMatches = false;
        QuotedQualityCSV qualityCSV = null;
        HttpFields fields = request.getHeaders();
        for (HttpField field : fields) {
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case CONTENT_ENCODING: {
                    String contentEncoding = field.getValue();
                    if (this.supportedEncodings.containsKey(contentEncoding)) {
                        requestContentEncoding = contentEncoding;
                        break;
                    }
                    requestContentEncoding = null;
                    break;
                }
                case ACCEPT_ENCODING: {
                    if (qualityCSV == null) {
                        final HttpConfiguration httpConfiguration = request.getConnectionMetaData().getHttpConfiguration();
                        qualityCSV = new QuotedQualityCSV(this){
                            final /* synthetic */ CompressionHandler this$0;
                            {
                                this.this$0 = this$0;
                            }

                            protected void onComplianceViolation(ComplianceViolation violation) {
                                if (!HttpCompliance.Violation.WHITESPACE_IN_PARAMETER.equals((Object)violation) || !httpConfiguration.getHttpCompliance().allows((ComplianceViolation)HttpCompliance.Violation.WHITESPACE_IN_PARAMETER)) {
                                    throw new BadMessageException(violation.toString());
                                }
                                httpConfiguration.notifyViolation(violation, this.toString());
                            }
                        };
                    }
                    qualityCSV.addValue(field.getValue());
                    break;
                }
                case IF_MATCH: 
                case IF_NONE_MATCH: {
                    etagMatches |= field.getValue().contains(EtagUtils.ETAG_SEPARATOR);
                }
            }
        }
        if (qualityCSV != null) {
            requestAcceptEncoding = qualityCSV.getQualityValues();
        }
        String decompressEncoding = config.getDecompressionEncoding(this.supportedEncodings.keySet(), request, requestContentEncoding, pathInContext);
        try {
            compressEncoding = config.getCompressionEncoding(this.supportedEncodings.keySet(), request, requestAcceptEncoding, pathInContext);
        }
        catch (Throwable x) {
            HttpException http;
            int statusCode;
            if (x instanceof HttpException && (statusCode = (http = (HttpException)x).getCode()) == 415) {
                String accepted = http.getReason();
                if (StringUtil.isNotBlank((String)accepted)) {
                    response.getHeaders().put(HttpHeader.ACCEPT_ENCODING, accepted);
                }
                Response.writeError((Request)request, (Response)response, (Callback)callback, (int)http.getCode(), null, (Throwable)x);
                return true;
            }
            throw x;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("request[{}] Content-Encoding={}, Accept-Encoding={}, decompressEncoding={}, compressEncoding={}", new Object[]{request, requestContentEncoding, requestAcceptEncoding, decompressEncoding, compressEncoding});
        }
        if (decompressEncoding == null && compressEncoding == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("skipping compression and decompression: no request encoding matches");
            }
            return next.handle(request, response, callback);
        }
        Request decompressionRequest = request;
        Response compressionResponse = response;
        if (decompressEncoding != null || etagMatches) {
            decompressionRequest = this.newDecompressionRequest(request, decompressEncoding);
        }
        if (compressEncoding != null) {
            response.getHeaders().ensureField(this.varyAcceptEncoding);
            compressionResponse = this.newCompressionResponse(request, response, compressEncoding, config);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("handle {} {} {}", new Object[]{decompressionRequest, compressionResponse, this});
        }
        if (next.handle(decompressionRequest, compressionResponse, callback)) {
            return true;
        }
        if (request instanceof DecompressionRequest) {
            DecompressionRequest decompressRequest = (DecompressionRequest)request;
            decompressRequest.destroy();
        }
        return false;
    }

    private Compression getCompression(String encoding) {
        Compression compression = this.supportedEncodings.get(encoding);
        if (compression == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("no compression found for encoding type {}", (Object)encoding);
            }
            return null;
        }
        return compression;
    }

    private Response newCompressionResponse(Request request, Response response, String compressEncoding, CompressionConfig config) {
        Compression compression = this.getCompression(compressEncoding);
        if (compression == null) {
            return response;
        }
        return new CompressionResponse(request, response, compression, config);
    }

    private Request newDecompressionRequest(Request request, String decompressEncoding) {
        Compression compression = this.getCompression(decompressEncoding);
        if (compression == null) {
            return request;
        }
        return new DecompressionRequest(compression, request);
    }

    public String toString() {
        return String.format("%s@%x{%s,supported=%s}", TypeUtil.toShortName(((Object)((Object)this)).getClass()), ((Object)((Object)this)).hashCode(), this.getState(), String.join((CharSequence)",", this.supportedEncodings.keySet()));
    }
}

