/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql.jdbcwrapper;

import ca.sqlpower.sql.CachedRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class IndexedCachedRowSet
extends CachedRowSet {
    private final Map<String, Integer> tableStartRows;
    private final int tableNameColumn;

    public IndexedCachedRowSet(ResultSet rs, int tableNameColumn) throws SQLException {
        this.tableNameColumn = tableNameColumn;
        super.populate(rs);
        this.tableStartRows = this.buildIndex();
    }

    private IndexedCachedRowSet() throws SQLException {
        this.tableStartRows = null;
        this.tableNameColumn = -1;
    }

    private Map<String, Integer> buildIndex() throws SQLException {
        String currentTableName = "";
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        while (this.next()) {
            String tableNameThisRow = this.getString(this.tableNameColumn);
            if (currentTableName.equals(tableNameThisRow)) continue;
            currentTableName = tableNameThisRow;
            index.put(tableNameThisRow, this.getRow());
        }
        return index;
    }

    public boolean containsTable(String tableName) {
        return this.tableStartRows.containsKey(tableName);
    }

    public synchronized CachedRowSet extractSingleTable(String tableName) throws SQLException {
        Integer row = this.tableStartRows.get(tableName);
        if (row == null) {
            throw new IllegalArgumentException("Table " + tableName + " is not in this rowset");
        }
        this.absolute(row - 1);
        IndexedCachedRowSet extracted = new IndexedCachedRowSet();
        extracted.rsmd = this.rsmd;
        extracted.data = new ArrayList();
        while (this.next() && tableName.equals(this.getString(this.tableNameColumn))) {
            extracted.data.add(this.curRow);
        }
        return extracted;
    }
}

