/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download.overpass;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.gui.download.OverpassQueryWizardDialog;
import org.openstreetmap.josm.tools.I18n;

public final class OverpassWizardRegistration {
    private static List<OverpassQueryWizard> wizards = Collections.synchronizedList(new ArrayList());

    public static void registerWizard(OverpassQueryWizard wizard) {
        Objects.requireNonNull(wizard, "wizard");
        wizards.add(wizard);
    }

    public static List<OverpassQueryWizard> getWizards() {
        return Collections.unmodifiableList(wizards);
    }

    private OverpassWizardRegistration() {
    }

    static {
        OverpassWizardRegistration.registerWizard(new OverpassQueryWizard(){

            @Override
            public void startWizard(OverpassWizardCallbacks callbacks) {
                new OverpassQueryWizardDialog(callbacks).showDialog();
            }

            @Override
            public Optional<String> getWizardTooltip() {
                return Optional.of(I18n.tr("Build an Overpass query using the Overpass Turbo Query Wizard tool", new Object[0]));
            }

            @Override
            public String getWizardName() {
                return I18n.tr("Query Wizard", new Object[0]);
            }
        });
    }

    public static interface OverpassWizardCallbacks {
        public void submitWizardResult(String var1);

        public Component getParent();
    }

    public static interface OverpassQueryWizard {
        public String getWizardName();

        public Optional<String> getWizardTooltip();

        public void startWizard(OverpassWizardCallbacks var1);
    }
}

