/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import processing.xml.XMLElement;
import processing.xml.XMLParseException;

public class StdXMLBuilder {
    private Stack<XMLElement> stack;
    private XMLElement root;
    private XMLElement parent;

    public StdXMLBuilder() {
        this(new XMLElement());
        this.stack = null;
        this.root = null;
    }

    public StdXMLBuilder(XMLElement xMLElement) {
        this.parent = xMLElement;
    }

    protected void finalize() throws Throwable {
        this.root = null;
        this.stack.clear();
        this.stack = null;
        super.finalize();
    }

    public void startBuilding(String string, int n) {
        this.stack = new Stack();
        this.root = null;
    }

    public void newProcessingInstruction(String string, Reader reader) {
    }

    public void startElement(String string, String string2, String string3, String string4, int n) {
        String string5 = string;
        if (string2 != null) {
            string5 = string2 + ':' + string;
        }
        if (this.stack.empty()) {
            this.parent.init(string5, string3, string4, n);
            this.stack.push(this.parent);
            this.root = this.parent;
        } else {
            XMLElement xMLElement = this.stack.peek();
            XMLElement xMLElement2 = new XMLElement(string5, string3, string4, n);
            xMLElement.addChild(xMLElement2);
            this.stack.push(xMLElement2);
        }
    }

    public void elementAttributesProcessed(String string, String string2, String string3) {
    }

    public void endElement(String string, String string2, String string3) {
        XMLElement xMLElement;
        XMLElement xMLElement2 = this.stack.pop();
        if (xMLElement2.getChildCount() == 1 && (xMLElement = xMLElement2.getChild(0)).getLocalName() == null) {
            xMLElement2.setContent(xMLElement.getContent());
            xMLElement2.removeChild(0);
        }
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) throws Exception {
        XMLElement xMLElement;
        String string6 = string;
        if (string2 != null) {
            string6 = string2 + ':' + string;
        }
        if ((xMLElement = this.stack.peek()).hasAttribute(string6)) {
            throw new XMLParseException(xMLElement.getSystemID(), xMLElement.getLine(), "Duplicate attribute: " + string);
        }
        xMLElement.setString(string6, string4);
    }

    public void addPCData(Reader reader, String string, int n) {
        int n2 = 2048;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(n2);
        char[] cArray = new char[n2];
        while (true) {
            int n4;
            if (n3 >= n2) {
                stringBuffer.ensureCapacity(n2 *= 2);
            }
            try {
                n4 = reader.read(cArray);
            }
            catch (IOException iOException) {
                break;
            }
            if (n4 < 0) break;
            stringBuffer.append(cArray, 0, n4);
            n3 += n4;
        }
        XMLElement xMLElement = new XMLElement(null, null, string, n);
        xMLElement.setContent(stringBuffer.toString());
        if (!this.stack.empty()) {
            XMLElement xMLElement2 = this.stack.peek();
            xMLElement2.addChild(xMLElement);
        }
    }

    public Object getResult() {
        return this.root;
    }
}

