/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.integer;

import de.rub.nds.modifiablevariable.VariableModification;
import java.util.Random;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"shift", "modificationFilter", "postModification"})
public class IntegerShiftLeftModification
extends VariableModification<Integer> {
    private static final int MAX_SHIFT_MODIFIER = 32;
    private int shift;

    public IntegerShiftLeftModification() {
    }

    public IntegerShiftLeftModification(int shift) {
        this.shift = shift;
    }

    @Override
    protected Integer modifyImplementationHook(Integer input) {
        return input == null ? 0 : input << this.shift;
    }

    public int getShift() {
        return this.shift;
    }

    public void setShift(int shift) {
        this.shift = shift;
    }

    @Override
    public VariableModification<Integer> getModifiedCopy() {
        Random r = new Random();
        int newShift = r.nextBoolean() ? this.shift + r.nextInt(32) : this.shift - r.nextInt(32);
        if (newShift < 0) {
            newShift = 31;
        } else if (newShift > 31) {
            newShift = 0;
        }
        return new IntegerShiftLeftModification(newShift);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.shift;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerShiftLeftModification other = (IntegerShiftLeftModification)obj;
        return this.shift == other.shift;
    }
}

