/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class SmoothScrollPaneUI
extends BasicScrollPaneUI {
    private static final double EPSILON = 1.0E-5;

    private SmoothScrollPaneUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SmoothScrollPaneUI();
    }

    @Override
    protected MouseWheelListener createMouseWheelListener() {
        final MouseWheelListener mouseWheelListener = super.createMouseWheelListener();
        return new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                SmoothScrollPaneUI.this.handleMouseWheelEvent(mouseWheelEvent, mouseWheelListener);
            }
        };
    }

    private void handleMouseWheelEvent(MouseWheelEvent mouseWheelEvent, MouseWheelListener mouseWheelListener) {
        if (this.scrollpane.isWheelScrollingEnabled() && mouseWheelEvent.getScrollType() == 0) {
            this.mouseWheelMoved(mouseWheelEvent);
            mouseWheelEvent.consume();
        } else {
            mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
        }
    }

    private void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        JScrollBar jScrollBar = mouseWheelEvent.isShiftDown() ? this.scrollpane.getHorizontalScrollBar() : this.scrollpane.getVerticalScrollBar();
        int n = jScrollBar.getOrientation();
        JViewport jViewport = this.scrollpane.getViewport();
        if (jViewport == null || !(jViewport.getView() instanceof Scrollable)) {
            return;
        }
        Scrollable scrollable = (Scrollable)((Object)jViewport.getView());
        double d = mouseWheelEvent.getPreciseWheelRotation();
        Rectangle rectangle = new Rectangle(new Point(0, 0), jViewport.getViewSize());
        int n2 = scrollable.getScrollableUnitIncrement(rectangle, n, 1);
        double d2 = d * (double)mouseWheelEvent.getScrollAmount() * (double)n2;
        boolean bl = Math.abs(d) < 1.00001;
        int n3 = scrollable.getScrollableBlockIncrement(rectangle, n, 1);
        double d3 = bl ? Math.max(-((double)n3), Math.min(d2, (double)n3)) : d2;
        int n4 = jScrollBar.getValue();
        int n5 = Math.max(jScrollBar.getMinimum(), Math.min((int)Math.round((double)n4 + d3), jScrollBar.getMaximum()));
        if (n5 != n4) {
            jScrollBar.setValue(n5);
        }
    }
}

