/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.network;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.ConnectionParam;
import org.zaproxy.zap.network.SocksProxy;

public class ZapAuthenticator
extends Authenticator {
    private static final ZapAuthenticator SINGLETON = new ZapAuthenticator();
    private static final Logger logger = LogManager.getLogger(ZapAuthenticator.class);
    private static ConnectionParam connectionOptions;

    private ZapAuthenticator() {
    }

    public static ZapAuthenticator getSingleton() {
        return SINGLETON;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication passwordAuthentication = this.getPasswordAuthenticationImpl();
        if (logger.isDebugEnabled()) {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("Getting password authentication for:").append('\n');
            strBuilder.append("Host      = ").append(this.getRequestingHost()).append('\n');
            strBuilder.append("Site      = ").append(this.getRequestingSite()).append('\n');
            strBuilder.append("Port      = ").append(this.getRequestingPort()).append('\n');
            strBuilder.append("Protocol  = ").append(this.getRequestingProtocol()).append('\n');
            strBuilder.append("Prompt    = ").append(this.getRequestingPrompt()).append('\n');
            strBuilder.append("Scheme    = ").append(this.getRequestingScheme()).append('\n');
            strBuilder.append("URL       = ").append(this.getRequestingURL()).append('\n');
            strBuilder.append("Auth Type = ").append((Object)this.getRequestorType()).append('\n');
            strBuilder.append("Result: ");
            if (passwordAuthentication == null) {
                strBuilder.append(passwordAuthentication);
            } else {
                strBuilder.append("[Username: ").append(passwordAuthentication.getUserName());
                strBuilder.append(", Password: *****]");
            }
            logger.debug(strBuilder.toString());
        }
        return passwordAuthentication;
    }

    private PasswordAuthentication getPasswordAuthenticationImpl() {
        if (this.isForSocksProxy()) {
            return ZapAuthenticator.getConnectionOptions().getSocksProxyPasswordAuth();
        }
        if (this.isForHttpProxy()) {
            return new PasswordAuthentication(ZapAuthenticator.getConnectionOptions().getProxyChainUserName(), ZapAuthenticator.getConnectionOptions().getProxyChainPassword().toCharArray());
        }
        return null;
    }

    private boolean isForSocksProxy() {
        if (!ZapAuthenticator.getConnectionOptions().isUseSocksProxy()) {
            return false;
        }
        SocksProxy socksProxy = ZapAuthenticator.getConnectionOptions().getSocksProxy();
        return socksProxy.getVersion() == SocksProxy.Version.SOCKS5 && this.getRequestorType() == Authenticator.RequestorType.SERVER && SocksProxy.Version.SOCKS5.name().equals(this.getRequestingProtocol()) && socksProxy.getPort() == this.getRequestingPort() && socksProxy.getHost().equals(this.getRequestingHost());
    }

    private boolean isForHttpProxy() {
        return this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingURL() != null && ZapAuthenticator.getConnectionOptions().isUseProxy(this.getRequestingURL().getHost()) && ZapAuthenticator.getConnectionOptions().getProxyChainPort() == this.getRequestingPort() && ZapAuthenticator.getConnectionOptions().getProxyChainName().equals(this.getRequestingHost());
    }

    private static ConnectionParam getConnectionOptions() {
        if (connectionOptions == null) {
            connectionOptions = Model.getSingleton().getOptionsParam().getConnectionParam();
        }
        return connectionOptions;
    }
}

