untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEi2cSsafYJIprGnHdCuICF00eCiIKy2QTSiXxApCaU/PproG8fDx9swNmcXN9+f44uFhkWjpT4ycofuoQwSLZA8=

OpenBSD 6.1 errata 007, May 10, 2017:

Heap-based buffer overflows in freetype can result in out-of-bounds writes.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 007_freetype.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then rebuild and install freetype:
    cd /usr/xenocara/lib/freetype
    make obj
    make build

Index: lib/freetype/src/psaux/psobjs.c
===================================================================
RCS file: /cvs/xenocara/lib/freetype/src/psaux/psobjs.c,v
retrieving revision 1.18
retrieving revision 1.18.2.1
diff -u -p -r1.18 -r1.18.2.1
--- lib/freetype/src/psaux/psobjs.c	13 Jan 2017 11:19:59 -0000	1.18
+++ lib/freetype/src/psaux/psobjs.c	10 May 2017 08:30:56 -0000	1.18.2.1
@@ -1718,6 +1718,14 @@
     first = outline->n_contours <= 1
             ? 0 : outline->contours[outline->n_contours - 2] + 1;
 
+    /* in malformed fonts it can happen that a contour was started */
+    /* but no points were added                                    */
+    if ( outline->n_contours && first == outline->n_points )
+    {
+      outline->n_contours--;
+      return;
+    }
+
     /* We must not include the last point in the path if it */
     /* is located on the first point.                       */
     if ( outline->n_points > 1 )
Index: lib/freetype/src/psaux/t1decode.c
===================================================================
RCS file: /cvs/xenocara/lib/freetype/src/psaux/t1decode.c,v
retrieving revision 1.18
retrieving revision 1.18.2.1
diff -u -p -r1.18 -r1.18.2.1
--- lib/freetype/src/psaux/t1decode.c	13 Jan 2017 11:20:00 -0000	1.18
+++ lib/freetype/src/psaux/t1decode.c	10 May 2017 08:30:56 -0000	1.18.2.1
@@ -780,10 +780,19 @@
             /* point without adding any point to the outline    */
             idx = decoder->num_flex_vectors++;
             if ( idx > 0 && idx < 7 )
+            {
+              /* in malformed fonts it is possible to have other */
+              /* opcodes in the middle of a flex (which don't    */
+              /* increase `num_flex_vectors'); we thus have to   */
+              /* check whether we can add a point                */
+              if ( FT_SET_ERROR( t1_builder_check_points( builder, 1 ) ) )
+                goto Syntax_Error;
+
               t1_builder_add_point( builder,
                                     x,
                                     y,
                                     (FT_Byte)( idx == 3 || idx == 6 ) );
+            }
           }
           break;
 
