untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46BwkC59+YzAvcf15dNZO40WF80Fx1xJiFgd0wC48lv+lJ07BPiaAam/EIvxEGa6UILDqwLX6QEA4rGfdxwci/A0=

OpenBSD 6.9 errata 027, January 24, 2022:

On PowerPC kernel memory is leaked to userland.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 027_ppctrap.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/powerpc/powerpc/trap.c
===================================================================
RCS file: /cvs/src/sys/arch/powerpc/powerpc/trap.c,v
diff -u -p -r1.119 trap.c
--- sys/arch/powerpc/powerpc/trap.c	11 Mar 2021 11:16:59 -0000	1.119
+++ sys/arch/powerpc/powerpc/trap.c	21 Jan 2022 14:23:05 -0000
@@ -154,7 +154,7 @@ void
 enable_vec(struct proc *p)
 {
 	struct pcb *pcb = &p->p_addr->u_pcb;
-	struct vreg *pcb_vr = pcb->pcb_vr;
+	struct vreg *pcb_vr;
 	struct cpu_info *ci = curcpu();
 	u_int32_t oldmsr, msr;
 
@@ -163,6 +163,7 @@ enable_vec(struct proc *p)
 	 */
 	if (pcb->pcb_vr == NULL)
 		pcb->pcb_vr = pool_get(&ppc_vecpl, PR_WAITOK | PR_ZERO);
+	pcb_vr = pcb->pcb_vr;
 
 	if (curcpu()->ci_vecproc != NULL || pcb->pcb_veccpu != NULL)
 		printf("attempting to restore vector in use vecproc %p"
@@ -431,10 +432,10 @@ trap(struct trapframe *frame)
 			/* nothing to do */
 			break;
 		default:
+			frame->fixreg[FIRSTARG + 1] = rval[1];
 		bad:
 			frame->fixreg[0] = error;
 			frame->fixreg[FIRSTARG] = error;
-			frame->fixreg[FIRSTARG + 1] = rval[1];
 			frame->cr |= 0x10000000;
 			break;
 		}
