/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.fips;

import java.lang.reflect.Method;
import java.security.Provider;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.jboss.logging.Logger;

public class KeycloakFipsSecurityProvider
extends Provider {
    protected static final Logger logger = Logger.getLogger(KeycloakFipsSecurityProvider.class);
    private final BouncyCastleFipsProvider bcFipsProvider;

    public KeycloakFipsSecurityProvider(BouncyCastleFipsProvider bcFipsProvider) {
        super("KC(" + bcFipsProvider.toString() + (CryptoServicesRegistrar.isInApprovedOnlyMode() ? " Approved Mode" : "") + ", FIPS-JVM: " + KeycloakFipsSecurityProvider.isSystemFipsEnabled() + ")", 1.0, "Keycloak pseudo provider");
        this.bcFipsProvider = bcFipsProvider;
    }

    @Override
    public final synchronized Provider.Service getService(String type, String algorithm) {
        if ("SHA1PRNG".equals(algorithm) && "SecureRandom".equals(type)) {
            logger.debug((Object)"Returning DEFAULT algorithm of BCFIPS provider instead of SHA1PRNG");
            return this.bcFipsProvider.getService("SecureRandom", "DEFAULT");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String isSystemFipsEnabled() {
        Method isSystemFipsEnabled = null;
        try {
            Class<?> securityConfigurator = KeycloakFipsSecurityProvider.class.getClassLoader().loadClass("java.security.SystemConfigurator");
            isSystemFipsEnabled = securityConfigurator.getDeclaredMethod("isSystemFipsEnabled", new Class[0]);
            isSystemFipsEnabled.setAccessible(true);
            boolean isEnabled = (Boolean)isSystemFipsEnabled.invoke(null, new Object[0]);
            String string = isEnabled ? "enabled" : "disabled";
            return string;
        }
        catch (Throwable ignore) {
            logger.debug((Object)"Could not detect if FIPS is enabled from the host", ignore);
            String string = "unknown";
            return string;
        }
        finally {
            if (isSystemFipsEnabled != null) {
                isSystemFipsEnabled.setAccessible(false);
            }
        }
    }
}

