/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.pfm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingUtility;
import org.pentaho.reporting.libraries.fonts.io.FileFontDataInputSource;
import org.pentaho.reporting.libraries.fonts.io.FontDataInputSource;
import org.pentaho.reporting.libraries.fonts.pfm.PfmExtension;
import org.pentaho.reporting.libraries.fonts.pfm.PfmFontHeader;

public class PfmFont {
    private String filename;
    private FontDataInputSource input;
    private transient byte[] readBuffer;
    private PfmFontHeader header;
    private PfmExtension extension;
    private String fontName;
    private String familyName;
    private boolean embeddable;

    public PfmFont(File font, boolean embeddable) throws IOException {
        this(new FileFontDataInputSource(font), embeddable);
    }

    public PfmFont(FontDataInputSource input, boolean embeddable) throws IOException {
        this.embeddable = embeddable;
        this.input = input;
        this.filename = input.getFileName();
        this.header = new PfmFontHeader(this.readFully(0L, 117));
        this.extension = new PfmExtension(this.readFully(117L, 30));
        int facePtr = this.header.getFacePtr();
        if (facePtr == 0) {
            throw new IOException("This font is not valid, it does not define a font-name");
        }
        byte[] familyNameRaw = this.readZString(facePtr);
        this.familyName = EncodingUtility.encode(familyNameRaw, this.header.getEncoding());
        int driverInfo = this.extension.getDriverInfo();
        if (driverInfo > 0) {
            byte[] fontName = this.readZString(driverInfo);
            this.fontName = EncodingUtility.encode(fontName, "ASCII");
        } else {
            this.fontName = this.familyName;
        }
    }

    public boolean isItextCompatible() {
        int driverInfo = this.extension.getDriverInfo();
        if (driverInfo < 75 || driverInfo > 512) {
            this.embeddable = false;
            return false;
        }
        return true;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public PfmFontHeader getHeader() {
        return this.header;
    }

    public String getFilename() {
        return this.filename;
    }

    public FontDataInputSource getInput() {
        return this.input;
    }

    public void dispose() {
        this.input.dispose();
    }

    protected byte[] readFully(long offset, int length) throws IOException {
        if (this.readBuffer == null) {
            this.readBuffer = new byte[Math.max(8192, length)];
        } else if (this.readBuffer.length < length) {
            this.readBuffer = new byte[length];
        }
        this.input.readFullyAt(offset, this.readBuffer, length);
        if (this.readBuffer.length - length > 0) {
            Arrays.fill(this.readBuffer, length, this.readBuffer.length, (byte)0);
        }
        return this.readBuffer;
    }

    protected byte[] readZString(long offset) throws IOException {
        int data;
        long position = offset;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((data = this.input.readAt(position)) > 0) {
            bout.write(data);
            ++position;
        }
        return bout.toByteArray();
    }

    public boolean isEmbeddable() {
        return this.embeddable;
    }
}

