/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrEventDataBaseHeader;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEventDataSessionStateChanged
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SESSION;
    public static final int STATE;
    public static final int TIME;

    public XrEventDataSessionStateChanged(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrEventDataSessionStateChanged.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEventDataSessionStateChanged.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEventDataSessionStateChanged.nnext(this.address());
    }

    @NativeType(value="XrSession")
    public long session() {
        return XrEventDataSessionStateChanged.nsession(this.address());
    }

    @NativeType(value="XrSessionState")
    public int state() {
        return XrEventDataSessionStateChanged.nstate(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrEventDataSessionStateChanged.ntime(this.address());
    }

    public XrEventDataSessionStateChanged type(@NativeType(value="XrStructureType") int value) {
        XrEventDataSessionStateChanged.ntype(this.address(), value);
        return this;
    }

    public XrEventDataSessionStateChanged type$Default() {
        return this.type(18);
    }

    public XrEventDataSessionStateChanged next(@NativeType(value="void const *") long value) {
        XrEventDataSessionStateChanged.nnext(this.address(), value);
        return this;
    }

    public XrEventDataSessionStateChanged session(XrSession value) {
        XrEventDataSessionStateChanged.nsession(this.address(), value);
        return this;
    }

    public XrEventDataSessionStateChanged state(@NativeType(value="XrSessionState") int value) {
        XrEventDataSessionStateChanged.nstate(this.address(), value);
        return this;
    }

    public XrEventDataSessionStateChanged time(@NativeType(value="XrTime") long value) {
        XrEventDataSessionStateChanged.ntime(this.address(), value);
        return this;
    }

    public XrEventDataSessionStateChanged set(int type, long next, XrSession session, int state, long time) {
        this.type(type);
        this.next(next);
        this.session(session);
        this.state(state);
        this.time(time);
        return this;
    }

    public XrEventDataSessionStateChanged set(XrEventDataSessionStateChanged src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrEventDataSessionStateChanged malloc() {
        return (XrEventDataSessionStateChanged)XrEventDataSessionStateChanged.wrap(XrEventDataSessionStateChanged.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrEventDataSessionStateChanged calloc() {
        return (XrEventDataSessionStateChanged)XrEventDataSessionStateChanged.wrap(XrEventDataSessionStateChanged.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrEventDataSessionStateChanged create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrEventDataSessionStateChanged)XrEventDataSessionStateChanged.wrap(XrEventDataSessionStateChanged.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrEventDataSessionStateChanged create(long address) {
        return (XrEventDataSessionStateChanged)XrEventDataSessionStateChanged.wrap(XrEventDataSessionStateChanged.class, (long)address);
    }

    @Nullable
    public static XrEventDataSessionStateChanged createSafe(long address) {
        return address == 0L ? null : (XrEventDataSessionStateChanged)XrEventDataSessionStateChanged.wrap(XrEventDataSessionStateChanged.class, (long)address);
    }

    public static XrEventDataSessionStateChanged create(XrEventDataBaseHeader value) {
        return (XrEventDataSessionStateChanged)XrEventDataSessionStateChanged.wrap(XrEventDataSessionStateChanged.class, (Struct)value);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrEventDataSessionStateChanged.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrEventDataSessionStateChanged.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrEventDataSessionStateChanged.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEventDataSessionStateChanged.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrEventDataSessionStateChanged.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrEventDataSessionStateChanged.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrEventDataSessionStateChanged.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static Buffer create(XrEventDataBaseHeader.Buffer value) {
        return (Buffer)XrEventDataSessionStateChanged.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static XrEventDataSessionStateChanged malloc(MemoryStack stack) {
        return (XrEventDataSessionStateChanged)XrEventDataSessionStateChanged.wrap(XrEventDataSessionStateChanged.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrEventDataSessionStateChanged calloc(MemoryStack stack) {
        return (XrEventDataSessionStateChanged)XrEventDataSessionStateChanged.wrap(XrEventDataSessionStateChanged.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrEventDataSessionStateChanged.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrEventDataSessionStateChanged.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nsession(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SESSION));
    }

    public static int nstate(long struct) {
        return UNSAFE.getInt(null, struct + (long)STATE);
    }

    public static long ntime(long struct) {
        return UNSAFE.getLong(null, struct + (long)TIME);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nsession(long struct, XrSession value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SESSION), (long)value.address());
    }

    public static void nstate(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STATE, value);
    }

    public static void ntime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)TIME, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SESSION)));
    }

    static {
        Struct.Layout layout = XrEventDataSessionStateChanged.__struct((Struct.Member[])new Struct.Member[]{XrEventDataSessionStateChanged.__member((int)4), XrEventDataSessionStateChanged.__member((int)POINTER_SIZE), XrEventDataSessionStateChanged.__member((int)POINTER_SIZE), XrEventDataSessionStateChanged.__member((int)4), XrEventDataSessionStateChanged.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SESSION = layout.offsetof(2);
        STATE = layout.offsetof(3);
        TIME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrEventDataSessionStateChanged, Buffer>
    implements NativeResource {
        private static final XrEventDataSessionStateChanged ELEMENT_FACTORY = XrEventDataSessionStateChanged.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrEventDataSessionStateChanged getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEventDataSessionStateChanged.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEventDataSessionStateChanged.nnext(this.address());
        }

        @NativeType(value="XrSession")
        public long session() {
            return XrEventDataSessionStateChanged.nsession(this.address());
        }

        @NativeType(value="XrSessionState")
        public int state() {
            return XrEventDataSessionStateChanged.nstate(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrEventDataSessionStateChanged.ntime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEventDataSessionStateChanged.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(18);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEventDataSessionStateChanged.nnext(this.address(), value);
            return this;
        }

        public Buffer session(XrSession value) {
            XrEventDataSessionStateChanged.nsession(this.address(), value);
            return this;
        }

        public Buffer state(@NativeType(value="XrSessionState") int value) {
            XrEventDataSessionStateChanged.nstate(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrEventDataSessionStateChanged.ntime(this.address(), value);
            return this;
        }
    }
}

