/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.karaf.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.addon.Addon;
import org.openhab.core.addon.AddonInfo;
import org.openhab.core.addon.AddonInfoRegistry;
import org.openhab.core.addon.AddonService;
import org.openhab.core.addon.AddonType;
import org.openhab.core.karaf.internal.FeatureInstaller;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.openhab.core.karafaddons")
@NonNullByDefault
public class KarafAddonService
implements AddonService {
    private static final String ADDONS_CONTENT_TYPE = "application/vnd.openhab.feature;type=karaf";
    private static final String ADDONS_AUTHOR = "openHAB";
    private static final String DOCUMENTATION_URL_PREFIX = "https://www.openhab.org/addons/";
    private static final Map<String, String> DOCUMENTATION_URL_FORMATS = Map.ofEntries(Map.entry(AddonType.AUTOMATION.getId(), "https://www.openhab.org/addons/automation/%s/"), Map.entry(AddonType.BINDING.getId(), "https://www.openhab.org/addons/bindings/%s/"), Map.entry(AddonType.MISC.getId(), "https://www.openhab.org/addons/integrations/%s/"), Map.entry(AddonType.PERSISTENCE.getId(), "https://www.openhab.org/addons/persistence/%s/"), Map.entry(AddonType.TRANSFORMATION.getId(), "https://www.openhab.org/addons/transformations/%s/"), Map.entry(AddonType.UI.getId(), "https://www.openhab.org/addons/ui/%s/"), Map.entry(AddonType.VOICE.getId(), "https://www.openhab.org/addons/voice/%s/"));
    private final Logger logger = LoggerFactory.getLogger(KarafAddonService.class);
    private final FeaturesService featuresService;
    private final FeatureInstaller featureInstaller;
    private final AddonInfoRegistry addonInfoRegistry;

    @Activate
    public KarafAddonService(@Reference FeatureInstaller featureInstaller, @Reference FeaturesService featuresService, @Reference AddonInfoRegistry addonInfoRegistry) {
        this.featureInstaller = featureInstaller;
        this.featuresService = featuresService;
        this.addonInfoRegistry = addonInfoRegistry;
    }

    public String getId() {
        return "karaf";
    }

    public String getName() {
        return "openHAB Distribution";
    }

    public void refreshSource() {
    }

    public List<Addon> getAddons(@Nullable Locale locale) {
        try {
            return Arrays.stream(this.featuresService.listFeatures()).filter(this::isAddon).map(f -> this.getAddon((Feature)f, locale)).sorted(Comparator.comparing(Addon::getLabel)).toList();
        }
        catch (Exception e) {
            this.logger.error("Exception while retrieving features: {}", (Object)e.getMessage());
            return List.of();
        }
    }

    private boolean isAddon(Feature feature) {
        return feature.getName().startsWith("openhab-") && FeatureInstaller.ADDON_TYPES.contains(this.getAddonType(feature.getName()));
    }

    public @Nullable Addon getAddon(String id, @Nullable Locale locale) {
        try {
            Feature feature = this.featuresService.getFeature("openhab-" + id);
            return this.getAddon(feature, locale);
        }
        catch (Exception e) {
            this.logger.error("Exception while querying feature '{}'", (Object)id);
            return null;
        }
    }

    private @Nullable String getDefaultDocumentationLink(String type, String name) {
        String format = DOCUMENTATION_URL_FORMATS.get(type);
        return format == null ? null : String.format(format, name);
    }

    private Addon getAddon(Feature feature, @Nullable Locale locale) {
        String name = this.getName(feature.getName());
        String type = this.getAddonType(feature.getName());
        String uid = type + "-" + name;
        boolean isInstalled = this.featuresService.isInstalled(feature);
        Addon.Builder addon = Addon.create((String)uid).withType(type).withId(name).withContentType(ADDONS_CONTENT_TYPE).withVersion(feature.getVersion()).withAuthor(ADDONS_AUTHOR, true).withInstalled(isInstalled);
        AddonInfo addonInfo = this.addonInfoRegistry.getAddonInfo(uid, locale);
        if (addonInfo != null) {
            addon = addonInfo.isMasterAddonInfo() ? addon.withLabel(addonInfo.getName()).withDescription(addonInfo.getDescription()) : addon.withLabel(feature.getDescription());
            addon = addon.withConnection(addonInfo.getConnection()).withCountries(addonInfo.getCountries()).withLink(this.getDefaultDocumentationLink(type, name)).withConfigDescriptionURI(addonInfo.getConfigDescriptionURI());
        } else {
            addon = addon.withLabel(feature.getDescription()).withLink(this.getDefaultDocumentationLink(type, name));
        }
        List<String> packages = feature.getBundles().stream().filter(bundle -> !bundle.isDependency()).map(bundle -> {
            String location = bundle.getLocation();
            location = location.substring(0, location.lastIndexOf("/"));
            location = location.substring(location.lastIndexOf("/") + 1);
            return location;
        }).toList();
        addon.withLoggerPackages(packages);
        return addon.build();
    }

    public List<AddonType> getTypes(@Nullable Locale locale) {
        return AddonType.DEFAULT_TYPES;
    }

    public void install(String id) {
        this.featureInstaller.addAddon(this.getAddonType(id), this.getName(id));
    }

    public void uninstall(String id) {
        this.featureInstaller.removeAddon(this.getAddonType(id), this.getName(id));
    }

    public @Nullable String getAddonId(URI addonURI) {
        return null;
    }

    private String getAddonType(String name) {
        String str = name.startsWith("openhab-") ? name.substring("openhab-".length()) : name;
        int index = str.indexOf("-");
        return index == -1 ? str : str.substring(0, index);
    }

    private String getName(String name) {
        String str = name.startsWith("openhab-") ? name.substring("openhab-".length()) : name;
        int index = str.indexOf("-");
        return index == -1 ? "" : str.substring(index + "-".length());
    }
}

