/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.jfree.chart.plot.PlotOrientation;

public class JRXmlWriter {
    private JRReport report = null;
    private String encoding = null;
    private StringBuffer sb = null;
    private Map fontsMap = new HashMap();
    private static final int colorMask = Integer.parseInt("00FFFFFF", 16);
    static /* synthetic */ Class class$org$jfree$data$time$Day;

    protected JRXmlWriter(JRReport report, String encoding) {
        this.report = report;
        this.encoding = encoding;
    }

    public static String writeReport(JRReport report, String encoding) {
        JRXmlWriter writer = new JRXmlWriter(report, encoding);
        return writer.writeReport();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeReport(JRReport report, String destFileName, String encoding) throws JRException {
        String xmlString = JRXmlWriter.writeReport(report, encoding);
        FileOutputStream fos = null;
        try {
            try {
                byte[] bytes = xmlString.getBytes(encoding);
                fos = new FileOutputStream(destFileName);
                fos.write(bytes, 0, bytes.length);
                fos.flush();
            }
            catch (IOException e) {
                throw new JRException("Error writing to file : " + destFileName, e);
            }
            Object var7_7 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        fos.close();
        return;
    }

    public static void writeReport(JRReport report, OutputStream outputStream, String encoding) throws JRException {
        String xmlString = JRXmlWriter.writeReport(report, encoding);
        try {
            byte[] bytes = xmlString.getBytes(encoding);
            outputStream.write(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            throw new JRException("Error writing to OutputStream : " + report.getName(), e);
        }
    }

    protected String writeReport() {
        JRGroup[] groups;
        JRVariable[] variables;
        JRField[] fields;
        JRParameter[] parameters;
        JRReportFont[] fonts;
        String[] imports;
        this.sb = new StringBuffer();
        this.sb.append("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>\n");
        this.sb.append("<!DOCTYPE jasperReport PUBLIC \"-//JasperReports//DTD Report Design//EN\" \"http://jasperreports.sourceforge.net/dtds/jasperreport.dtd\">\n");
        this.sb.append("\n");
        this.sb.append("<jasperReport name=\"");
        this.sb.append(this.report.getName());
        this.sb.append("\"");
        if (this.report.getLanguage() != "java") {
            this.sb.append(" language=\"");
            this.sb.append(this.report.getLanguage());
            this.sb.append("\"");
        }
        if (this.report.getColumnCount() != 1) {
            this.sb.append(" columnCount=\"");
            this.sb.append(this.report.getColumnCount());
            this.sb.append("\"");
        }
        if (this.report.getPrintOrder() != 1) {
            this.sb.append(" printOrder=\"");
            this.sb.append((String)JRXmlConstants.getPrintOrderMap().get(new Byte(this.report.getPrintOrder())));
            this.sb.append("\"");
        }
        this.sb.append(" pageWidth=\"");
        this.sb.append(this.report.getPageWidth());
        this.sb.append("\"");
        this.sb.append(" pageHeight=\"");
        this.sb.append(this.report.getPageHeight());
        this.sb.append("\"");
        if (this.report.getOrientation() != 1) {
            this.sb.append(" orientation=\"");
            this.sb.append((String)JRXmlConstants.getOrientationMap().get(new Byte(this.report.getOrientation())));
            this.sb.append("\"");
        }
        if (this.report.getWhenNoDataType() != 1) {
            this.sb.append(" whenNoDataType=\"");
            this.sb.append((String)JRXmlConstants.getWhenNoDataTypeMap().get(new Byte(this.report.getWhenNoDataType())));
            this.sb.append("\"");
        }
        this.sb.append(" columnWidth=\"");
        this.sb.append(this.report.getColumnWidth());
        this.sb.append("\"");
        if (this.report.getColumnSpacing() != 0) {
            this.sb.append(" columnSpacing=\"");
            this.sb.append(this.report.getColumnSpacing());
            this.sb.append("\"");
        }
        this.sb.append(" leftMargin=\"");
        this.sb.append(this.report.getLeftMargin());
        this.sb.append("\"");
        this.sb.append(" rightMargin=\"");
        this.sb.append(this.report.getRightMargin());
        this.sb.append("\"");
        this.sb.append(" topMargin=\"");
        this.sb.append(this.report.getTopMargin());
        this.sb.append("\"");
        this.sb.append(" bottomMargin=\"");
        this.sb.append(this.report.getBottomMargin());
        this.sb.append("\"");
        if (this.report.isTitleNewPage()) {
            this.sb.append(" isTitleNewPage=\"");
            this.sb.append(this.report.isTitleNewPage());
            this.sb.append("\"");
        }
        if (this.report.isSummaryNewPage()) {
            this.sb.append(" isSummaryNewPage=\"");
            this.sb.append(this.report.isSummaryNewPage());
            this.sb.append("\"");
        }
        if (this.report.isFloatColumnFooter()) {
            this.sb.append(" isFloatColumnFooter=\"");
            this.sb.append(this.report.isFloatColumnFooter());
            this.sb.append("\"");
        }
        if (this.report.getScriptletClass() != null) {
            this.sb.append(" scriptletClass=\"");
            this.sb.append(this.report.getScriptletClass());
            this.sb.append("\"");
        }
        if (this.report.getResourceBundle() != null) {
            this.sb.append(" resourceBundle=\"");
            this.sb.append(this.report.getResourceBundle());
            this.sb.append("\"");
        }
        if (this.report.getWhenResourceMissingType() != 1) {
            this.sb.append(" whenResourceMissingType=\"");
            this.sb.append((String)JRXmlConstants.getWhenResourceMissingTypeMap().get(new Byte(this.report.getWhenResourceMissingType())));
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        String[] propertyNames = this.report.getPropertyNames();
        if (propertyNames != null && propertyNames.length > 0) {
            for (int i = 0; i < propertyNames.length; ++i) {
                String value = this.report.getProperty(propertyNames[i]);
                if (value == null) continue;
                this.sb.append("\t<property name=\"");
                this.sb.append(propertyNames[i]);
                this.sb.append("\" value=\"");
                this.sb.append(JRStringUtil.xmlEncode(value));
                this.sb.append("\"/>\n");
            }
        }
        if ((imports = this.report.getImports()) != null && imports.length > 0) {
            for (int i = 0; i < imports.length; ++i) {
                String value = imports[i];
                if (value == null) continue;
                this.sb.append("\t<import value=\"");
                this.sb.append(JRStringUtil.xmlEncode(value));
                this.sb.append("\"/>\n");
            }
        }
        if ((fonts = this.report.getFonts()) != null && fonts.length > 0) {
            for (int i = 0; i < fonts.length; ++i) {
                this.fontsMap.put(fonts[i].getName(), fonts[i]);
                this.writeReportFont(fonts[i]);
            }
        }
        if ((parameters = this.report.getParameters()) != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isSystemDefined()) continue;
                this.writeParameter(parameters[i]);
            }
        }
        if (this.report.getQuery() != null) {
            this.writeQuery(this.report.getQuery());
        }
        if ((fields = this.report.getFields()) != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                this.writeField(fields[i]);
            }
        }
        if ((variables = this.report.getVariables()) != null && variables.length > 0) {
            for (int i = 0; i < variables.length; ++i) {
                if (variables[i].isSystemDefined()) continue;
                this.writeVariable(variables[i]);
            }
        }
        if ((groups = this.report.getGroups()) != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                this.writeGroup(groups[i]);
            }
        }
        if (this.report.getBackground() != null) {
            this.sb.append("\t<background>\n");
            this.writeBand(this.report.getBackground());
            this.sb.append("\t</background>\n");
        }
        if (this.report.getTitle() != null) {
            this.sb.append("\t<title>\n");
            this.writeBand(this.report.getTitle());
            this.sb.append("\t</title>\n");
        }
        if (this.report.getPageHeader() != null) {
            this.sb.append("\t<pageHeader>\n");
            this.writeBand(this.report.getPageHeader());
            this.sb.append("\t</pageHeader>\n");
        }
        if (this.report.getColumnHeader() != null) {
            this.sb.append("\t<columnHeader>\n");
            this.writeBand(this.report.getColumnHeader());
            this.sb.append("\t</columnHeader>\n");
        }
        if (this.report.getDetail() != null) {
            this.sb.append("\t<detail>\n");
            this.writeBand(this.report.getDetail());
            this.sb.append("\t</detail>\n");
        }
        if (this.report.getColumnFooter() != null) {
            this.sb.append("\t<columnFooter>\n");
            this.writeBand(this.report.getColumnFooter());
            this.sb.append("\t</columnFooter>\n");
        }
        if (this.report.getPageFooter() != null) {
            this.sb.append("\t<pageFooter>\n");
            this.writeBand(this.report.getPageFooter());
            this.sb.append("\t</pageFooter>\n");
        }
        if (this.report.getLastPageFooter() != null) {
            this.sb.append("\t<lastPageFooter>\n");
            this.writeBand(this.report.getLastPageFooter());
            this.sb.append("\t</lastPageFooter>\n");
        }
        if (this.report.getSummary() != null) {
            this.sb.append("\t<summary>\n");
            this.writeBand(this.report.getSummary());
            this.sb.append("\t</summary>\n");
        }
        this.sb.append("</jasperReport>\n");
        return this.sb.toString();
    }

    private void writeReportFont(JRReportFont font) {
        this.sb.append("\t<reportFont");
        this.sb.append(" name=\"");
        this.sb.append(font.getName());
        this.sb.append("\"");
        this.sb.append(" isDefault=\"");
        this.sb.append(font.isDefault());
        this.sb.append("\"");
        this.sb.append(" fontName=\"");
        this.sb.append(font.getFontName());
        this.sb.append("\"");
        this.sb.append(" size=\"");
        this.sb.append(font.getSize());
        this.sb.append("\"");
        this.sb.append(" isBold=\"");
        this.sb.append(font.isBold());
        this.sb.append("\"");
        this.sb.append(" isItalic=\"");
        this.sb.append(font.isItalic());
        this.sb.append("\"");
        this.sb.append(" isUnderline=\"");
        this.sb.append(font.isUnderline());
        this.sb.append("\"");
        this.sb.append(" isStrikeThrough=\"");
        this.sb.append(font.isStrikeThrough());
        this.sb.append("\"");
        this.sb.append(" pdfFontName=\"");
        this.sb.append(font.getPdfFontName());
        this.sb.append("\"");
        this.sb.append(" pdfEncoding=\"");
        this.sb.append(font.getPdfEncoding());
        this.sb.append("\"");
        this.sb.append(" isPdfEmbedded=\"");
        this.sb.append(font.isPdfEmbedded());
        this.sb.append("\"");
        this.sb.append("/>\n");
    }

    private void writeParameter(JRParameter parameter) {
        this.sb.append("\t<parameter");
        this.sb.append(" name=\"");
        this.sb.append(parameter.getName());
        this.sb.append("\"");
        this.sb.append(" class=\"");
        this.sb.append(parameter.getValueClassName());
        this.sb.append("\"");
        if (!parameter.isForPrompting()) {
            this.sb.append(" isForPrompting=\"");
            this.sb.append(parameter.isForPrompting());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        if (parameter.getDescription() != null) {
            this.sb.append("\t\t<parameterDescription><![CDATA[");
            this.sb.append(parameter.getDescription());
            this.sb.append("]]></parameterDescription>\n");
        }
        if (parameter.getDefaultValueExpression() != null) {
            this.sb.append("\t\t<defaultValueExpression><![CDATA[");
            this.sb.append(parameter.getDefaultValueExpression().getText());
            this.sb.append("]]></defaultValueExpression>\n");
        }
        this.sb.append("\t</parameter>\n");
    }

    private void writeQuery(JRQuery query) {
        this.sb.append("\t<queryString><![CDATA[");
        this.sb.append(query.getText());
        this.sb.append("]]></queryString>\n");
    }

    private void writeField(JRField field) {
        this.sb.append("\t<field");
        this.sb.append(" name=\"");
        this.sb.append(field.getName());
        this.sb.append("\"");
        this.sb.append(" class=\"");
        this.sb.append(field.getValueClassName());
        this.sb.append("\"");
        this.sb.append(">\n");
        if (field.getDescription() != null) {
            this.sb.append("\t\t<fieldDescription><![CDATA[");
            this.sb.append(field.getDescription());
            this.sb.append("]]></fieldDescription>\n");
        }
        this.sb.append("\t</field>\n");
    }

    private void writeVariable(JRVariable variable) {
        this.sb.append("\t<variable");
        this.sb.append(" name=\"");
        this.sb.append(variable.getName());
        this.sb.append("\"");
        this.sb.append(" class=\"");
        this.sb.append(variable.getValueClassName());
        this.sb.append("\"");
        if (variable.getResetType() != 1) {
            this.sb.append(" resetType=\"");
            this.sb.append((String)JRXmlConstants.getResetTypeMap().get(new Byte(variable.getResetType())));
            this.sb.append("\"");
        }
        if (variable.getResetGroup() != null) {
            this.sb.append(" resetGroup=\"");
            this.sb.append(variable.getResetGroup().getName());
            this.sb.append("\"");
        }
        if (variable.getIncrementType() != 5) {
            this.sb.append(" incrementType=\"");
            this.sb.append((String)JRXmlConstants.getResetTypeMap().get(new Byte(variable.getIncrementType())));
            this.sb.append("\"");
        }
        if (variable.getIncrementGroup() != null) {
            this.sb.append(" incrementGroup=\"");
            this.sb.append(variable.getIncrementGroup().getName());
            this.sb.append("\"");
        }
        if (variable.getCalculation() != 0) {
            this.sb.append(" calculation=\"");
            this.sb.append((String)JRXmlConstants.getCalculationMap().get(new Byte(variable.getCalculation())));
            this.sb.append("\"");
        }
        if (variable.getIncrementerFactoryClassName() != null) {
            this.sb.append(" incrementerFactoryClass=\"");
            this.sb.append(variable.getIncrementerFactoryClassName());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        if (variable.getExpression() != null) {
            this.sb.append("\t\t<variableExpression><![CDATA[");
            this.sb.append(variable.getExpression().getText());
            this.sb.append("]]></variableExpression>\n");
        }
        if (variable.getInitialValueExpression() != null) {
            this.sb.append("\t\t<initialValueExpression><![CDATA[");
            this.sb.append(variable.getInitialValueExpression().getText());
            this.sb.append("]]></initialValueExpression>\n");
        }
        this.sb.append("\t</variable>\n");
    }

    private void writeGroup(JRGroup group) {
        this.sb.append("\t<group");
        this.sb.append(" name=\"");
        this.sb.append(group.getName());
        this.sb.append("\"");
        if (group.isStartNewColumn()) {
            this.sb.append(" isStartNewColumn=\"");
            this.sb.append(group.isStartNewColumn());
            this.sb.append("\"");
        }
        if (group.isStartNewPage()) {
            this.sb.append(" isStartNewPage=\"");
            this.sb.append(group.isStartNewPage());
            this.sb.append("\"");
        }
        if (group.isResetPageNumber()) {
            this.sb.append(" isResetPageNumber=\"");
            this.sb.append(group.isResetPageNumber());
            this.sb.append("\"");
        }
        if (group.isReprintHeaderOnEachPage()) {
            this.sb.append(" isReprintHeaderOnEachPage=\"");
            this.sb.append(group.isReprintHeaderOnEachPage());
            this.sb.append("\"");
        }
        if (group.getMinHeightToStartNewPage() > 0) {
            this.sb.append(" minHeightToStartNewPage=\"");
            this.sb.append(group.getMinHeightToStartNewPage());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        if (group.getExpression() != null) {
            this.sb.append("\t\t<groupExpression><![CDATA[");
            this.sb.append(group.getExpression().getText());
            this.sb.append("]]></groupExpression>\n");
        }
        if (group.getGroupHeader() != null) {
            this.sb.append("\t\t<groupHeader>\n");
            this.writeBand(group.getGroupHeader());
            this.sb.append("\t\t</groupHeader>\n");
        }
        if (group.getGroupFooter() != null) {
            this.sb.append("\t\t<groupFooter>\n");
            this.writeBand(group.getGroupFooter());
            this.sb.append("\t\t</groupFooter>\n");
        }
        this.sb.append("\t</group>\n");
    }

    private void writeBand(JRBand band) {
        List children;
        this.sb.append("\t\t<band");
        if (band.getHeight() > 0) {
            this.sb.append(" height=\"");
            this.sb.append(band.getHeight());
            this.sb.append("\"");
        }
        if (!band.isSplitAllowed()) {
            this.sb.append(" isSplitAllowed=\"");
            this.sb.append(band.isSplitAllowed());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        if (band.getPrintWhenExpression() != null) {
            this.sb.append("\t\t\t<printWhenExpression><![CDATA[");
            this.sb.append(band.getPrintWhenExpression().getText());
            this.sb.append("]]></printWhenExpression>\n");
        }
        if ((children = band.getChildren()) != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                ((JRChild)children.get(i)).writeXml(this);
            }
        }
        this.sb.append("\t\t</band>\n");
    }

    public void writeElementGroup(JRElementGroup elementGroup) {
        this.sb.append("\t\t\t<elementGroup>\n");
        List children = elementGroup.getChildren();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                JRChild child = (JRChild)children.get(i);
                child.writeXml(this);
            }
        }
        this.sb.append("\t\t\t</elementGroup>\n");
    }

    public void writeLine(JRLine line) {
        this.sb.append("\t\t\t<line");
        if (line.getDirection() != 1) {
            this.sb.append(" direction=\"");
            this.sb.append((String)JRXmlConstants.getDirectionMap().get(new Byte(line.getDirection())));
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        this.writeReportElement(line);
        this.writeGraphicElement(line);
        this.sb.append("\t\t\t</line>\n");
    }

    private void writeReportElement(JRElement element) {
        this.sb.append("\t\t\t\t<reportElement");
        if (element.getKey() != null) {
            this.sb.append(" key=\"");
            this.sb.append(element.getKey());
            this.sb.append("\"");
        }
        if (element.getPositionType() != 2) {
            this.sb.append(" positionType=\"");
            this.sb.append((String)JRXmlConstants.getPositionTypeMap().get(new Byte(element.getPositionType())));
            this.sb.append("\"");
        }
        if (element.getStretchType() != 0) {
            this.sb.append(" stretchType=\"");
            this.sb.append((String)JRXmlConstants.getStretchTypeMap().get(new Byte(element.getStretchType())));
            this.sb.append("\"");
        }
        if (!element.isPrintRepeatedValues()) {
            this.sb.append(" isPrintRepeatedValues=\"");
            this.sb.append(element.isPrintRepeatedValues());
            this.sb.append("\"");
        }
        if (element instanceof JRLine && element.getMode() != 1 || element instanceof JRRectangle && element.getMode() != 1 || element instanceof JREllipse && element.getMode() != 1 || element instanceof JRImage && element.getMode() != 2 || element instanceof JRTextElement && element.getMode() != 2 || element instanceof JRSubreport && element.getMode() != 2) {
            this.sb.append(" mode=\"");
            this.sb.append((String)JRXmlConstants.getModeMap().get(new Byte(element.getMode())));
            this.sb.append("\"");
        }
        this.sb.append(" x=\"");
        this.sb.append(element.getX());
        this.sb.append("\"");
        this.sb.append(" y=\"");
        this.sb.append(element.getY());
        this.sb.append("\"");
        this.sb.append(" width=\"");
        this.sb.append(element.getWidth());
        this.sb.append("\"");
        this.sb.append(" height=\"");
        this.sb.append(element.getHeight());
        this.sb.append("\"");
        if (element.isRemoveLineWhenBlank()) {
            this.sb.append(" isRemoveLineWhenBlank=\"");
            this.sb.append(element.isRemoveLineWhenBlank());
            this.sb.append("\"");
        }
        if (element.isPrintInFirstWholeBand()) {
            this.sb.append(" isPrintInFirstWholeBand=\"");
            this.sb.append(element.isPrintInFirstWholeBand());
            this.sb.append("\"");
        }
        if (element.isPrintWhenDetailOverflows()) {
            this.sb.append(" isPrintWhenDetailOverflows=\"");
            this.sb.append(element.isPrintWhenDetailOverflows());
            this.sb.append("\"");
        }
        if (element.getPrintWhenGroupChanges() != null) {
            this.sb.append(" printWhenGroupChanges=\"");
            this.sb.append(element.getPrintWhenGroupChanges().getName());
            this.sb.append("\"");
        }
        if (element.getForecolor().getRGB() != Color.black.getRGB()) {
            this.sb.append(" forecolor=\"#");
            this.sb.append(Integer.toHexString(element.getForecolor().getRGB() & colorMask));
            this.sb.append("\"");
        }
        if (element.getBackcolor().getRGB() != Color.white.getRGB()) {
            this.sb.append(" backcolor=\"#");
            this.sb.append(Integer.toHexString(element.getBackcolor().getRGB() & colorMask));
            this.sb.append("\"");
        }
        if (element.getPrintWhenExpression() != null) {
            this.sb.append(">\n");
            this.sb.append("\t\t\t\t\t<printWhenExpression><![CDATA[");
            this.sb.append(element.getPrintWhenExpression().getText());
            this.sb.append("]]></printWhenExpression>\n");
            this.sb.append("\t\t\t\t</reportElement>\n");
        } else {
            this.sb.append("/>\n");
        }
    }

    private void writeGraphicElement(JRGraphicElement element) {
        this.sb.append("\t\t\t\t<graphicElement");
        if (element instanceof JRLine && element.getPen() != 1 || element instanceof JRRectangle && element.getPen() != 1 || element instanceof JREllipse && element.getPen() != 1 || element instanceof JRImage && element.getPen() != 0) {
            this.sb.append(" pen=\"");
            this.sb.append((String)JRXmlConstants.getPenMap().get(new Byte(element.getPen())));
            this.sb.append("\"");
        }
        if (element.getFill() != 1) {
            this.sb.append(" fill=\"");
            this.sb.append((String)JRXmlConstants.getFillMap().get(new Byte(element.getFill())));
            this.sb.append("\"");
        }
        this.sb.append("/>\n");
    }

    public void writeRectangle(JRRectangle rectangle) {
        this.sb.append("\t\t\t<rectangle");
        if (rectangle.getRadius() != 0) {
            this.sb.append(" radius=\"");
            this.sb.append(rectangle.getRadius());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        this.writeReportElement(rectangle);
        this.writeGraphicElement(rectangle);
        this.sb.append("\t\t\t</rectangle>\n");
    }

    public void writeEllipse(JREllipse ellipse) {
        this.sb.append("\t\t\t<ellipse>\n");
        this.writeReportElement(ellipse);
        this.writeGraphicElement(ellipse);
        this.sb.append("\t\t\t</ellipse>\n");
    }

    public void writeImage(JRImage image) {
        this.sb.append("\t\t\t<image");
        if (image.getScaleImage() != 3) {
            this.sb.append(" scaleImage=\"");
            this.sb.append((String)JRXmlConstants.getScaleImageMap().get(new Byte(image.getScaleImage())));
            this.sb.append("\"");
        }
        if (image.getHorizontalAlignment() != 1) {
            this.sb.append(" hAlign=\"");
            this.sb.append((String)JRXmlConstants.getHorizontalAlignMap().get(new Byte(image.getHorizontalAlignment())));
            this.sb.append("\"");
        }
        if (image.getVerticalAlignment() != 1) {
            this.sb.append(" vAlign=\"");
            this.sb.append((String)JRXmlConstants.getVerticalAlignMap().get(new Byte(image.getVerticalAlignment())));
            this.sb.append("\"");
        }
        if (image.isOwnUsingCache() != null) {
            this.sb.append(" isUsingCache=\"");
            this.sb.append(image.isOwnUsingCache());
            this.sb.append("\"");
        }
        if (image.isLazy()) {
            this.sb.append(" isLazy=\"");
            this.sb.append(image.isLazy());
            this.sb.append("\"");
        }
        if (image.getOnErrorType() != 1) {
            this.sb.append(" onErrorType=\"");
            this.sb.append((String)JRXmlConstants.getOnErrorTypeMap().get(new Byte(image.getOnErrorType())));
            this.sb.append("\"");
        }
        if (image.getEvaluationTime() != 1) {
            this.sb.append(" evaluationTime=\"");
            this.sb.append((String)JRXmlConstants.getEvaluationTimeMap().get(new Byte(image.getEvaluationTime())));
            this.sb.append("\"");
        }
        if (image.getEvaluationGroup() != null) {
            this.sb.append(" evaluationGroup=\"");
            this.sb.append(image.getEvaluationGroup().getName());
            this.sb.append("\"");
        }
        if (image.getHyperlinkType() != 1) {
            this.sb.append(" hyperlinkType=\"");
            this.sb.append((String)JRXmlConstants.getHyperlinkTypeMap().get(new Byte(image.getHyperlinkType())));
            this.sb.append("\"");
        }
        if (image.getHyperlinkTarget() != 1) {
            this.sb.append(" hyperlinkTarget=\"");
            this.sb.append((String)JRXmlConstants.getHyperlinkTargetMap().get(new Byte(image.getHyperlinkTarget())));
            this.sb.append("\"");
        }
        if (image.getBookmarkLevel() != 0) {
            this.sb.append(" bookmarkLevel=\"");
            this.sb.append(image.getBookmarkLevel());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        this.writeReportElement(image);
        this.writeBox(image.getBox());
        this.writeGraphicElement(image);
        if (image.getExpression() != null) {
            this.sb.append("\t\t\t\t<imageExpression");
            this.sb.append(" class=\"");
            this.sb.append(image.getExpression().getValueClassName());
            this.sb.append("\"");
            this.sb.append("><![CDATA[");
            this.sb.append(image.getExpression().getText());
            this.sb.append("]]></imageExpression>\n");
        }
        if (image.getAnchorNameExpression() != null) {
            this.sb.append("\t\t\t\t<anchorNameExpression><![CDATA[");
            this.sb.append(image.getAnchorNameExpression().getText());
            this.sb.append("]]></anchorNameExpression>\n");
        }
        if (image.getHyperlinkReferenceExpression() != null) {
            this.sb.append("\t\t\t\t<hyperlinkReferenceExpression><![CDATA[");
            this.sb.append(image.getHyperlinkReferenceExpression().getText());
            this.sb.append("]]></hyperlinkReferenceExpression>\n");
        }
        if (image.getHyperlinkAnchorExpression() != null) {
            this.sb.append("\t\t\t\t<hyperlinkAnchorExpression><![CDATA[");
            this.sb.append(image.getHyperlinkAnchorExpression().getText());
            this.sb.append("]]></hyperlinkAnchorExpression>\n");
        }
        if (image.getHyperlinkPageExpression() != null) {
            this.sb.append("\t\t\t\t<hyperlinkPageExpression><![CDATA[");
            this.sb.append(image.getHyperlinkPageExpression().getText());
            this.sb.append("]]></hyperlinkPageExpression>\n");
        }
        this.sb.append("\t\t\t</image>\n");
    }

    private void writeBox(JRBox box) {
        if (box != null) {
            StringBuffer tmpBuffer = new StringBuffer();
            if (box.getBorder() != 0) {
                tmpBuffer.append(" border=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getBorderColor() != null) {
                tmpBuffer.append(" borderColor=\"#");
                tmpBuffer.append(Integer.toHexString(box.getBorderColor().getRGB() & colorMask));
                tmpBuffer.append("\"");
            }
            if (box.getPadding() > 0) {
                tmpBuffer.append(" padding=\"");
                tmpBuffer.append(box.getPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnTopBorder() != null) {
                tmpBuffer.append(" topBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnTopBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnTopBorderColor() != null) {
                tmpBuffer.append(" topBorderColor=\"#");
                tmpBuffer.append(Integer.toHexString(box.getOwnTopBorderColor().getRGB() & colorMask));
                tmpBuffer.append("\"");
            }
            if (box.getOwnTopPadding() != null) {
                tmpBuffer.append(" topPadding=\"");
                tmpBuffer.append(box.getOwnTopPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnLeftBorder() != null) {
                tmpBuffer.append(" leftBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnLeftBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnLeftBorderColor() != null) {
                tmpBuffer.append(" leftBorderColor=\"#");
                tmpBuffer.append(Integer.toHexString(box.getOwnLeftBorderColor().getRGB() & colorMask));
                tmpBuffer.append("\"");
            }
            if (box.getOwnLeftPadding() != null) {
                tmpBuffer.append(" leftPadding=\"");
                tmpBuffer.append(box.getOwnLeftPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnBottomBorder() != null) {
                tmpBuffer.append(" bottomBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnBottomBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnBottomBorderColor() != null) {
                tmpBuffer.append(" bottomBorderColor=\"#");
                tmpBuffer.append(Integer.toHexString(box.getOwnBottomBorderColor().getRGB() & colorMask));
                tmpBuffer.append("\"");
            }
            if (box.getOwnBottomPadding() != null) {
                tmpBuffer.append(" bottomPadding=\"");
                tmpBuffer.append(box.getOwnBottomPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnRightBorder() != null) {
                tmpBuffer.append(" rightBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnRightBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnRightBorderColor() != null) {
                tmpBuffer.append(" rightBorderColor=\"#");
                tmpBuffer.append(Integer.toHexString(box.getOwnRightBorderColor().getRGB() & colorMask));
                tmpBuffer.append("\"");
            }
            if (box.getOwnRightPadding() != null) {
                tmpBuffer.append(" rightPadding=\"");
                tmpBuffer.append(box.getOwnRightPadding());
                tmpBuffer.append("\"");
            }
            if (tmpBuffer.length() > 0) {
                this.sb.append("\t\t\t\t<box");
                this.sb.append(tmpBuffer.toString());
                this.sb.append("/>\n");
            }
        }
    }

    public void writeStaticText(JRStaticText staticText) {
        this.sb.append("\t\t\t<staticText>\n");
        this.writeReportElement(staticText);
        this.writeBox(staticText.getBox());
        this.writeTextElement(staticText);
        if (staticText.getText() != null) {
            this.sb.append("\t\t\t\t<text><![CDATA[");
            this.sb.append(staticText.getText());
            this.sb.append("]]></text>\n");
        }
        this.sb.append("\t\t\t</staticText>\n");
    }

    private void writeTextElement(JRTextElement textElement) {
        String font;
        this.sb.append("\t\t\t\t<textElement");
        if (textElement.getHorizontalAlignment() != 1) {
            this.sb.append(" textAlignment=\"");
            this.sb.append((String)JRXmlConstants.getHorizontalAlignMap().get(new Byte(textElement.getHorizontalAlignment())));
            this.sb.append("\"");
        }
        if (textElement.getVerticalAlignment() != 1) {
            this.sb.append(" verticalAlignment=\"");
            this.sb.append((String)JRXmlConstants.getVerticalAlignMap().get(new Byte(textElement.getVerticalAlignment())));
            this.sb.append("\"");
        }
        if (textElement.getRotation() != 0) {
            this.sb.append(" rotation=\"");
            this.sb.append((String)JRXmlConstants.getRotationMap().get(new Byte(textElement.getRotation())));
            this.sb.append("\"");
        }
        if (textElement.getLineSpacing() != 0) {
            this.sb.append(" lineSpacing=\"");
            this.sb.append((String)JRXmlConstants.getLineSpacingMap().get(new Byte(textElement.getLineSpacing())));
            this.sb.append("\"");
        }
        if (textElement.isStyledText()) {
            this.sb.append(" isStyledText=\"");
            this.sb.append(textElement.isStyledText());
            this.sb.append("\"");
        }
        if ((font = this.writeFont(textElement.getFont())) != null) {
            this.sb.append(">\n");
            this.sb.append("\t\t\t\t\t" + font + "\n");
            this.sb.append("\t\t\t\t</textElement>\n");
        } else {
            this.sb.append("/>\n");
        }
    }

    private String writeFont(JRFont font) {
        String fontChunk = null;
        if (font != null) {
            StringBuffer tmpBuffer = new StringBuffer();
            if (font.getReportFont() != null) {
                JRFont baseFont = (JRFont)this.fontsMap.get(font.getReportFont().getName());
                if (baseFont != null) {
                    tmpBuffer.append(" reportFont=\"");
                    tmpBuffer.append(font.getReportFont().getName());
                    tmpBuffer.append("\"");
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + font.getReportFont().getName());
                }
            }
            if (font.getOwnFontName() != null) {
                tmpBuffer.append(" fontName=\"");
                tmpBuffer.append(font.getOwnFontName());
                tmpBuffer.append("\"");
            }
            if (font.getOwnSize() != null) {
                tmpBuffer.append(" size=\"");
                tmpBuffer.append(font.getOwnSize());
                tmpBuffer.append("\"");
            }
            if (font.isOwnBold() != null) {
                tmpBuffer.append(" isBold=\"");
                tmpBuffer.append(font.isOwnBold());
                tmpBuffer.append("\"");
            }
            if (font.isOwnItalic() != null) {
                tmpBuffer.append(" isItalic=\"");
                tmpBuffer.append(font.isOwnItalic());
                tmpBuffer.append("\"");
            }
            if (font.isOwnUnderline() != null) {
                tmpBuffer.append(" isUnderline=\"");
                tmpBuffer.append(font.isOwnUnderline());
                tmpBuffer.append("\"");
            }
            if (font.isOwnStrikeThrough() != null) {
                tmpBuffer.append(" isStrikeThrough=\"");
                tmpBuffer.append(font.isOwnStrikeThrough());
                tmpBuffer.append("\"");
            }
            if (font.getOwnPdfFontName() != null) {
                tmpBuffer.append(" pdfFontName=\"");
                tmpBuffer.append(font.getOwnPdfFontName());
                tmpBuffer.append("\"");
            }
            if (font.getOwnPdfEncoding() != null) {
                tmpBuffer.append(" pdfEncoding=\"");
                tmpBuffer.append(font.getOwnPdfEncoding());
                tmpBuffer.append("\"");
            }
            if (font.isOwnPdfEmbedded() != null) {
                tmpBuffer.append(" isPdfEmbedded=\"");
                tmpBuffer.append(font.isOwnPdfEmbedded());
                tmpBuffer.append("\"");
            }
            if (tmpBuffer.length() > 0) {
                fontChunk = "<font" + tmpBuffer.toString() + "/>";
            }
        }
        return fontChunk;
    }

    public void writeTextField(JRTextField textField) {
        this.sb.append("\t\t\t<textField");
        if (textField.isStretchWithOverflow()) {
            this.sb.append(" isStretchWithOverflow=\"");
            this.sb.append(textField.isStretchWithOverflow());
            this.sb.append("\"");
        }
        if (textField.getEvaluationTime() != 1) {
            this.sb.append(" evaluationTime=\"");
            this.sb.append((String)JRXmlConstants.getEvaluationTimeMap().get(new Byte(textField.getEvaluationTime())));
            this.sb.append("\"");
        }
        if (textField.getEvaluationGroup() != null) {
            this.sb.append(" evaluationGroup=\"");
            this.sb.append(textField.getEvaluationGroup().getName());
            this.sb.append("\"");
        }
        if (textField.getPattern() != null) {
            this.sb.append(" pattern=\"");
            this.sb.append(textField.getPattern());
            this.sb.append("\"");
        }
        if (textField.isBlankWhenNull()) {
            this.sb.append(" isBlankWhenNull=\"");
            this.sb.append(textField.isBlankWhenNull());
            this.sb.append("\"");
        }
        if (textField.getHyperlinkType() != 1) {
            this.sb.append(" hyperlinkType=\"");
            this.sb.append((String)JRXmlConstants.getHyperlinkTypeMap().get(new Byte(textField.getHyperlinkType())));
            this.sb.append("\"");
        }
        if (textField.getHyperlinkTarget() != 1) {
            this.sb.append(" hyperlinkTarget=\"");
            this.sb.append((String)JRXmlConstants.getHyperlinkTargetMap().get(new Byte(textField.getHyperlinkTarget())));
            this.sb.append("\"");
        }
        if (textField.getBookmarkLevel() != 0) {
            this.sb.append(" bookmarkLevel=\"");
            this.sb.append(textField.getBookmarkLevel());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        this.writeReportElement(textField);
        this.writeBox(textField.getBox());
        this.writeTextElement(textField);
        if (textField.getExpression() != null) {
            this.sb.append("\t\t\t\t<textFieldExpression");
            this.sb.append(" class=\"");
            this.sb.append(textField.getExpression().getValueClassName());
            this.sb.append("\"");
            this.sb.append("><![CDATA[");
            this.sb.append(textField.getExpression().getText());
            this.sb.append("]]></textFieldExpression>\n");
        }
        if (textField.getAnchorNameExpression() != null) {
            this.sb.append("\t\t\t\t<anchorNameExpression><![CDATA[");
            this.sb.append(textField.getAnchorNameExpression().getText());
            this.sb.append("]]></anchorNameExpression>\n");
        }
        if (textField.getHyperlinkReferenceExpression() != null) {
            this.sb.append("\t\t\t\t<hyperlinkReferenceExpression><![CDATA[");
            this.sb.append(textField.getHyperlinkReferenceExpression().getText());
            this.sb.append("]]></hyperlinkReferenceExpression>\n");
        }
        if (textField.getHyperlinkAnchorExpression() != null) {
            this.sb.append("\t\t\t\t<hyperlinkAnchorExpression><![CDATA[");
            this.sb.append(textField.getHyperlinkAnchorExpression().getText());
            this.sb.append("]]></hyperlinkAnchorExpression>\n");
        }
        if (textField.getHyperlinkPageExpression() != null) {
            this.sb.append("\t\t\t\t<hyperlinkPageExpression><![CDATA[");
            this.sb.append(textField.getHyperlinkPageExpression().getText());
            this.sb.append("]]></hyperlinkPageExpression>\n");
        }
        this.sb.append("\t\t\t</textField>\n");
    }

    public void writeSubreport(JRSubreport subreport) {
        JRSubreportReturnValue[] returnValues;
        JRSubreportParameter[] parameters;
        this.sb.append("\t\t\t<subreport");
        if (subreport.isOwnUsingCache() != null) {
            this.sb.append(" isUsingCache=\"");
            this.sb.append(subreport.isOwnUsingCache());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        this.writeReportElement(subreport);
        if (subreport.getParametersMapExpression() != null) {
            this.sb.append("\t\t\t\t<parametersMapExpression><![CDATA[");
            this.sb.append(subreport.getParametersMapExpression().getText());
            this.sb.append("]]></parametersMapExpression>\n");
        }
        if ((parameters = subreport.getParameters()) != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                this.writeSubreportParameter(parameters[i]);
            }
        }
        if (subreport.getConnectionExpression() != null) {
            this.sb.append("\t\t\t\t<connectionExpression><![CDATA[");
            this.sb.append(subreport.getConnectionExpression().getText());
            this.sb.append("]]></connectionExpression>\n");
        }
        if (subreport.getDataSourceExpression() != null) {
            this.sb.append("\t\t\t\t<dataSourceExpression><![CDATA[");
            this.sb.append(subreport.getDataSourceExpression().getText());
            this.sb.append("]]></dataSourceExpression>\n");
        }
        if ((returnValues = subreport.getReturnValues()) != null && returnValues.length > 0) {
            for (int i = 0; i < returnValues.length; ++i) {
                this.writeSubreportReturnValue(returnValues[i]);
            }
        }
        if (subreport.getExpression() != null) {
            this.sb.append("\t\t\t\t<subreportExpression");
            this.sb.append(" class=\"");
            this.sb.append(subreport.getExpression().getValueClassName());
            this.sb.append("\"");
            this.sb.append("><![CDATA[");
            this.sb.append(subreport.getExpression().getText());
            this.sb.append("]]></subreportExpression>\n");
        }
        this.sb.append("\t\t\t</subreport>\n");
    }

    private void writeSubreportParameter(JRSubreportParameter subreportParameter) {
        this.sb.append("\t\t\t\t<subreportParameter");
        this.sb.append(" name=\"");
        this.sb.append(subreportParameter.getName());
        this.sb.append("\"");
        this.sb.append(">\n");
        if (subreportParameter.getExpression() != null) {
            this.sb.append("\t\t\t\t\t<subreportParameterExpression><![CDATA[");
            this.sb.append(subreportParameter.getExpression().getText());
            this.sb.append("]]></subreportParameterExpression>\n");
        }
        this.sb.append("\t\t\t\t</subreportParameter>\n");
    }

    private void writeChart(JRChart chart) {
        this.sb.append("\t\t\t\t<chart");
        if (!chart.isShowLegend()) {
            this.sb.append(" isShowLegend=\"false\"");
        }
        if (chart.getEvaluationTime() != 1) {
            this.sb.append(" evaluationTime=\"" + JRXmlConstants.getEvaluationTimeMap().get(new Byte(chart.getEvaluationTime())) + "\"");
        }
        if (chart.getEvaluationTime() == 5) {
            this.sb.append(" evaluationGroup=\"" + chart.getEvaluationGroup().getName() + "\"");
        }
        if (chart.getHyperlinkType() != 1) {
            this.sb.append(" hyperlinkType=\"");
            this.sb.append((String)JRXmlConstants.getHyperlinkTypeMap().get(new Byte(chart.getHyperlinkType())));
            this.sb.append("\"");
        }
        if (chart.getHyperlinkTarget() != 1) {
            this.sb.append(" hyperlinkTarget=\"");
            this.sb.append((String)JRXmlConstants.getHyperlinkTargetMap().get(new Byte(chart.getHyperlinkTarget())));
            this.sb.append("\"");
        }
        if (chart.getBookmarkLevel() != 0) {
            this.sb.append(" bookmarkLevel=\"");
            this.sb.append(chart.getBookmarkLevel());
            this.sb.append("\"");
        }
        if (chart.getCustomizerClass() != null) {
            this.sb.append(" customizerClass=\"");
            this.sb.append(chart.getCustomizerClass());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        this.writeReportElement(chart);
        this.writeBox(chart.getBox());
        this.sb.append("\t\t\t\t\t<chartTitle");
        if (chart.getTitlePosition() != 1) {
            this.sb.append(" position=\"" + JRXmlConstants.getChartTitlePositionMap().get(new Byte(chart.getTitlePosition())) + "\"");
        }
        if (chart.getTitleColor().getRGB() != Color.black.getRGB()) {
            this.sb.append(" color=\"#");
            this.sb.append(Integer.toHexString(chart.getTitleColor().getRGB() & colorMask));
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        String titleFont = this.writeFont(chart.getTitleFont());
        if (titleFont != null) {
            this.sb.append("\t\t\t\t\t\t" + titleFont + "\n");
        }
        if (chart.getTitleExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<titleExpression><![CDATA[");
            this.sb.append(chart.getTitleExpression().getText());
            this.sb.append("]]></titleExpression>\n");
        }
        this.sb.append("\t\t\t\t\t</chartTitle>\n");
        this.sb.append("\t\t\t\t\t<chartSubtitle");
        if (chart.getSubtitleColor().getRGB() != Color.black.getRGB()) {
            this.sb.append(" color=\"#");
            this.sb.append(Integer.toHexString(chart.getSubtitleColor().getRGB() & colorMask));
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        String subtitleFont = this.writeFont(chart.getSubtitleFont());
        if (subtitleFont != null) {
            this.sb.append("\t\t\t\t\t\t" + subtitleFont + "\n");
        }
        if (chart.getSubtitleExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<subtitleExpression><![CDATA[");
            this.sb.append(chart.getSubtitleExpression().getText());
            this.sb.append("]]></subtitleExpression>\n");
        }
        this.sb.append("\t\t\t\t\t</chartSubtitle>\n");
        if (chart.getAnchorNameExpression() != null) {
            this.sb.append("\t\t\t\t\t<anchorNameExpression><![CDATA[");
            this.sb.append(chart.getAnchorNameExpression().getText());
            this.sb.append("]]></anchorNameExpression>\n");
        }
        if (chart.getHyperlinkReferenceExpression() != null) {
            this.sb.append("\t\t\t\t\t<hyperlinkReferenceExpression><![CDATA[");
            this.sb.append(chart.getHyperlinkReferenceExpression().getText());
            this.sb.append("]]></hyperlinkReferenceExpression>\n");
        }
        if (chart.getHyperlinkAnchorExpression() != null) {
            this.sb.append("\t\t\t\t\t<hyperlinkAnchorExpression><![CDATA[");
            this.sb.append(chart.getHyperlinkAnchorExpression().getText());
            this.sb.append("]]></hyperlinkAnchorExpression>\n");
        }
        if (chart.getHyperlinkPageExpression() != null) {
            this.sb.append("\t\t\t\t\t<hyperlinkPageExpression><![CDATA[");
            this.sb.append(chart.getHyperlinkPageExpression().getText());
            this.sb.append("]]></hyperlinkPageExpression>\n");
        }
        this.sb.append("\t\t\t\t</chart>\n");
    }

    private void writeDataset(JRChartDataset dataset) {
        this.sb.append("\t\t\t\t\t<dataset");
        if (dataset.getResetType() != 1) {
            this.sb.append(" resetType=\"" + JRXmlConstants.getResetTypeMap().get(new Byte(dataset.getResetType())) + "\"");
        }
        if (dataset.getResetType() == 4) {
            this.sb.append(" resetGroup=\"" + dataset.getResetGroup().getName() + "\"");
        }
        if (dataset.getIncrementType() != 5) {
            this.sb.append(" incrementType=\"" + JRXmlConstants.getResetTypeMap().get(new Byte(dataset.getIncrementType())) + "\"");
        }
        if (dataset.getIncrementType() == 4) {
            this.sb.append(" incrementGroup=\"" + dataset.getIncrementGroup().getName() + "\"");
        }
        this.sb.append("/>\n");
    }

    private void writeCategoryDataSet(JRCategoryDataset dataset) {
        this.sb.append("\t\t\t\t<categoryDataset>\n");
        this.writeDataset(dataset);
        JRCategorySeries[] categorySeries = dataset.getSeries();
        if (categorySeries != null && categorySeries.length > 0) {
            for (int i = 0; i < categorySeries.length; ++i) {
                this.writeCategorySeries(categorySeries[i]);
            }
        }
        this.sb.append("\t\t\t\t</categoryDataset>\n");
    }

    private void writeTimeSeriesDataset(JRTimeSeriesDataset dataset) {
        this.sb.append("\t\t\t\t<timeSeriesDataset");
        if (dataset.getTimePeriod() != null && !(class$org$jfree$data$time$Day == null ? (class$org$jfree$data$time$Day = JRXmlWriter.class$("org.jfree.data.time.Day")) : class$org$jfree$data$time$Day).getName().equals(dataset.getTimePeriod().getName())) {
            this.sb.append(" timePeriod=\"" + JRXmlConstants.getTimePeriodName(dataset.getTimePeriod()) + "\"");
        }
        this.sb.append(">\n");
        this.writeDataset(dataset);
        JRTimeSeries[] timeSeries = dataset.getSeries();
        if (timeSeries != null && timeSeries.length > 0) {
            for (int i = 0; i < timeSeries.length; ++i) {
                this.writeTimeSeries(timeSeries[i]);
            }
        }
        this.sb.append("\t\t\t\t</timeSeriesDataset>\n");
    }

    private void writeTimePeriodDataset(JRTimePeriodDataset dataset) {
        this.sb.append("\t\t\t\t<timePeriodDataset>\n");
        this.writeDataset(dataset);
        JRTimePeriodSeries[] timePeriodSeries = dataset.getSeries();
        if (timePeriodSeries != null && timePeriodSeries.length > 0) {
            for (int i = 0; i < timePeriodSeries.length; ++i) {
                this.writeTimePeriodSeries(timePeriodSeries[i]);
            }
        }
        this.sb.append("\t\t\t\t</timePeriodDataset>\n");
    }

    private void writeCategorySeries(JRCategorySeries categorySeries) {
        this.sb.append("\t\t\t\t\t<categorySeries>\n");
        if (categorySeries.getSeriesExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<seriesExpression><![CDATA[");
            this.sb.append(categorySeries.getSeriesExpression().getText());
            this.sb.append("]]></seriesExpression>\n");
        }
        if (categorySeries.getCategoryExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<categoryExpression><![CDATA[");
            this.sb.append(categorySeries.getCategoryExpression().getText());
            this.sb.append("]]></categoryExpression>\n");
        }
        if (categorySeries.getValueExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<valueExpression><![CDATA[");
            this.sb.append(categorySeries.getValueExpression().getText());
            this.sb.append("]]></valueExpression>\n");
        }
        if (categorySeries.getLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<labelExpression><![CDATA[");
            this.sb.append(categorySeries.getLabelExpression().getText());
            this.sb.append("]]></labelExpression>\n");
        }
        this.sb.append("\t\t\t\t\t</categorySeries>\n");
    }

    private void writeXyzDataset(JRXyzDataset dataset) {
        this.sb.append("\t\t\t\t<xyzDataset>\n");
        this.writeDataset(dataset);
        JRXyzSeries[] series = dataset.getSeries();
        if (series != null && series.length > 0) {
            for (int i = 0; i < series.length; ++i) {
                this.writeXyzSeries(series[i]);
            }
        }
        this.sb.append("\t\t\t\t</xyzDataset>\n");
    }

    private void writeXyzSeries(JRXyzSeries series) {
        this.sb.append("\t\t\t\t\t<xyzSeries>\n");
        if (series.getSeriesExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<seriesExpression><![CDATA[");
            this.sb.append(series.getSeriesExpression().getText());
            this.sb.append("]]></seriesExpression>\n");
        }
        if (series.getXValueExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<xValueExpression><![CDATA[");
            this.sb.append(series.getXValueExpression().getText());
            this.sb.append("]]></xValueExpression>\n");
        }
        if (series.getYValueExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<yValueExpression><![CDATA[");
            this.sb.append(series.getYValueExpression().getText());
            this.sb.append("]]></yValueExpression>\n");
        }
        if (series.getZValueExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<zValueExpression><![CDATA[");
            this.sb.append(series.getZValueExpression().getText());
            this.sb.append("]]></zValueExpression>\n");
        }
        this.sb.append("\t\t\t\t\t</xyzSeries>\n");
    }

    private void writeXySeries(JRXySeries xySeries) {
        this.sb.append("\t\t\t\t\t<xySeries>\n");
        if (xySeries.getSeriesExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<seriesExpression><![CDATA[");
            this.sb.append(xySeries.getSeriesExpression().getText());
            this.sb.append("]]></seriesExpression>\n");
        }
        if (xySeries.getXValueExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<xValueExpression><![CDATA[");
            this.sb.append(xySeries.getXValueExpression().getText());
            this.sb.append("]]></xValueExpression>\n");
        }
        if (xySeries.getYValueExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<yValueExpression><![CDATA[");
            this.sb.append(xySeries.getYValueExpression().getText());
            this.sb.append("]]></yValueExpression>\n");
        }
        if (xySeries.getLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<labelExpression><![CDATA[");
            this.sb.append(xySeries.getLabelExpression().getText());
            this.sb.append("]]></labelExpression>\n");
        }
        this.sb.append("\t\t\t\t\t</xySeries>\n");
    }

    private void writeXyDataset(JRXyDataset dataset) {
        this.sb.append("\t\t\t\t<xyDataset>\n");
        this.writeDataset(dataset);
        JRXySeries[] xySeries = dataset.getSeries();
        if (xySeries != null && xySeries.length > 0) {
            for (int i = 0; i < xySeries.length; ++i) {
                this.writeXySeries(xySeries[i]);
            }
        }
        this.sb.append("\t\t\t\t</xyDataset>\n");
    }

    private void writeTimeSeries(JRTimeSeries timeSeries) {
        this.sb.append("\t\t\t\t\t<timeSeries>\n");
        if (timeSeries.getSeriesExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<seriesExpression><![CDATA[");
            this.sb.append(timeSeries.getSeriesExpression().getText());
            this.sb.append("]]></seriesExpression>\n");
        }
        if (timeSeries.getTimePeriodExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<timePeriodExpression><![CDATA[");
            this.sb.append(timeSeries.getTimePeriodExpression().getText());
            this.sb.append("]]></timePeriodExpression>\n");
        }
        if (timeSeries.getValueExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<valueExpression><![CDATA[");
            this.sb.append(timeSeries.getValueExpression().getText());
            this.sb.append("]]></valueExpression>\n");
        }
        if (timeSeries.getLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<labelExpression><![CDATA[");
            this.sb.append(timeSeries.getLabelExpression().getText());
            this.sb.append("]]></labelExpression>\n");
        }
        this.sb.append("\t\t\t\t\t</timeSeries>\n");
    }

    private void writeTimePeriodSeries(JRTimePeriodSeries timePeriodSeries) {
        this.sb.append("\t\t\t\t\t<timePeriodSeries>\n");
        if (timePeriodSeries.getSeriesExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<seriesExpression><![CDATA[");
            this.sb.append(timePeriodSeries.getSeriesExpression().getText());
            this.sb.append("]]></seriesExpression>\n");
        }
        if (timePeriodSeries.getStartDateExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<startDateExpression><![CDATA[");
            this.sb.append(timePeriodSeries.getStartDateExpression().getText());
            this.sb.append("]]></startDateExpression>\n");
        }
        if (timePeriodSeries.getEndDateExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<endDateExpression><![CDATA[");
            this.sb.append(timePeriodSeries.getEndDateExpression().getText());
            this.sb.append("]]></endDateExpression>\n");
        }
        if (timePeriodSeries.getValueExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<valueExpression><![CDATA[");
            this.sb.append(timePeriodSeries.getValueExpression().getText());
            this.sb.append("]]></valueExpression>\n");
        }
        if (timePeriodSeries.getLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t\t<labelExpression><![CDATA[");
            this.sb.append(timePeriodSeries.getLabelExpression().getText());
            this.sb.append("]]></labelExpression>\n");
        }
        this.sb.append("\t\t\t\t\t</timePeriodSeries>\n");
    }

    public void writePieDataset(JRPieDataset dataset) {
        this.sb.append("\t\t\t\t<pieDataset>\n");
        this.writeDataset(dataset);
        if (dataset.getKeyExpression() != null) {
            this.sb.append("\t\t\t\t\t<keyExpression><![CDATA[");
            this.sb.append(dataset.getKeyExpression().getText());
            this.sb.append("]]></keyExpression>\n");
        }
        if (dataset.getValueExpression() != null) {
            this.sb.append("\t\t\t\t\t<valueExpression><![CDATA[");
            this.sb.append(dataset.getValueExpression().getText());
            this.sb.append("]]></valueExpression>\n");
        }
        if (dataset.getLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<labelExpression><![CDATA[");
            this.sb.append(dataset.getLabelExpression().getText());
            this.sb.append("]]></labelExpression>\n");
        }
        this.sb.append("\t\t\t\t</pieDataset>\n");
    }

    private void writePlot(JRChartPlot plot) {
        this.sb.append("\t\t\t\t\t<plot");
        if (plot.getBackcolor() != null) {
            this.sb.append(" backcolor=\"#");
            this.sb.append(Integer.toHexString(plot.getBackcolor().getRGB() & colorMask));
            this.sb.append("\"");
        }
        if (!plot.getOrientation().equals((Object)PlotOrientation.VERTICAL)) {
            this.sb.append(" orientation=\"" + JRXmlConstants.getPlotOrientationMap().get(PlotOrientation.HORIZONTAL) + "\"");
        }
        if (plot.getBackgroundAlpha() != 1.0f) {
            this.sb.append(" backgroundAlpha=\"" + plot.getBackgroundAlpha() + "\"");
        }
        if (plot.getForegroundAlpha() != 1.0f) {
            this.sb.append(" foregroundAlpha=\"" + plot.getForegroundAlpha() + "\"");
        }
        this.sb.append("/>\n");
    }

    public void writePieChart(JRChart chart) {
        this.sb.append("\t\t\t<pieChart>\n");
        this.writeChart(chart);
        this.writePieDataset((JRPieDataset)chart.getDataset());
        this.sb.append("\t\t\t\t<piePlot>\n");
        this.writePlot(chart.getPlot());
        this.sb.append("\t\t\t\t</piePlot>\n");
        this.sb.append("\t\t\t</pieChart>\n");
    }

    public void writePie3DChart(JRChart chart) {
        this.sb.append("\t\t\t<pie3DChart>\n");
        this.writeChart(chart);
        this.writePieDataset((JRPieDataset)chart.getDataset());
        JRPie3DPlot plot = (JRPie3DPlot)chart.getPlot();
        this.sb.append("\t\t\t\t<pie3DPlot");
        if (plot.getDepthFactor() != 0.2) {
            this.sb.append(" depthFactor=\"" + String.valueOf(plot.getDepthFactor()) + "\"");
        }
        this.sb.append(">\n");
        this.writePlot(chart.getPlot());
        this.sb.append("\t\t\t\t</pie3DPlot>\n");
        this.sb.append("\t\t\t</pie3DChart>\n");
    }

    private void writeBarPlot(JRBarPlot plot) {
        this.sb.append("\t\t\t\t<barPlot");
        if (plot.isShowLabels()) {
            this.sb.append(" isShowTickLabels=\"true\"");
        }
        if (!plot.isShowTickLabels()) {
            this.sb.append(" isShowTickLabels=\"false\"");
        }
        if (!plot.isShowTickMarks()) {
            this.sb.append(" isShowTickMarks=\"false\"");
        }
        this.sb.append(">\n");
        this.writePlot(plot);
        if (plot.getCategoryAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<categoryAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getCategoryAxisLabelExpression().getText());
            this.sb.append("]]></categoryAxisLabelExpression>\n");
        }
        if (plot.getValueAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<valueAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getValueAxisLabelExpression().getText());
            this.sb.append("]]></valueAxisLabelExpression>\n");
        }
        this.sb.append("\t\t\t\t</barPlot>\n");
    }

    private void writeBubblePlot(JRBubblePlot plot) {
        this.sb.append("\t\t\t\t<bubblePlot scaleType=\"");
        Map scaleTypeMap = JRXmlConstants.getScaleTypeMap();
        this.sb.append(scaleTypeMap.get(new Integer(plot.getScaleType())));
        this.sb.append("\">\n");
        this.writePlot(plot);
        if (plot.getXAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<xAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getXAxisLabelExpression().getText());
            this.sb.append("]]></xAxisLabelExpression>\n");
        }
        if (plot.getYAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<yAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getYAxisLabelExpression().getText());
            this.sb.append("]]></yAxisLabelExpression>\n");
        }
        this.sb.append("\t\t\t\t</bubblePlot>\n");
    }

    private void writeLinePlot(JRLinePlot plot) {
        this.sb.append("\t\t\t\t<linePlot");
        if (!plot.isShowLines()) {
            this.sb.append(" isShowLines=\"false\"");
        }
        if (!plot.isShowShapes()) {
            this.sb.append(" isShowShapes=\"false\"");
        }
        this.sb.append(">\n");
        this.writePlot(plot);
        if (plot.getCategoryAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<categoryAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getCategoryAxisLabelExpression().getText());
            this.sb.append("]]></categoryAxisLabelExpression>\n");
        }
        if (plot.getValueAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<valueAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getValueAxisLabelExpression().getText());
            this.sb.append("]]></valueAxisLabelExpression>\n");
        }
        this.sb.append("\t\t\t\t</linePlot>\n");
    }

    private void writeTimeSeriesPlot(JRTimeSeriesPlot plot) {
        this.sb.append("\t\t\t\t<timeSeriesPlot");
        if (!plot.isShowLines()) {
            this.sb.append(" isShowLines=\"false\" ");
        }
        if (!plot.isShowShapes()) {
            this.sb.append("isShowShapes=\"false\" ");
        }
        this.sb.append(">\n");
        this.writePlot(plot);
        if (plot.getTimeAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<timeAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getTimeAxisLabelExpression().getText());
            this.sb.append("]]></timeAxisLabelExpression>\n");
        }
        if (plot.getValueAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<valueAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getValueAxisLabelExpression().getText());
            this.sb.append("]]></valueAxisLabelExpression>\n");
        }
        this.sb.append("\t\t\t\t</timeSeriesPlot>\n");
    }

    public void writeBar3DPlot(JRBar3DPlot plot) {
        this.sb.append("\t\t\t\t<bar3DPlot");
        if (plot.isShowLabels()) {
            this.sb.append(" isShowLabels=\"true\"");
        }
        if (plot.getXOffset() != 12.0) {
            this.sb.append(" xOffset=\"" + plot.getXOffset() + "\"");
        }
        if (plot.getYOffset() != 8.0) {
            this.sb.append(" yOffset=\"" + plot.getYOffset() + "\"");
        }
        this.sb.append(">\n");
        this.writePlot(plot);
        if (plot.getCategoryAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<categoryAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getCategoryAxisLabelExpression().getText());
            this.sb.append("]]></categoryAxisLabelExpression>\n");
        }
        if (plot.getValueAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<valueAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getValueAxisLabelExpression().getText());
            this.sb.append("]]></valueAxisLabelExpression>\n");
        }
        this.sb.append("\t\t\t\t</bar3DPlot>\n");
    }

    public void writeBarChart(JRChart chart) {
        this.sb.append("\t\t\t<barChart>\n");
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBarPlot((JRBarPlot)chart.getPlot());
        this.sb.append("\t\t\t</barChart>\n");
    }

    public void writeBar3DChart(JRChart chart) {
        this.sb.append("\t\t\t<bar3DChart>\n");
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBar3DPlot((JRBar3DPlot)chart.getPlot());
        this.sb.append("\t\t\t</bar3DChart>\n");
    }

    public void writeBubbleChart(JRChart chart) {
        this.sb.append("\t\t\t<bubbleChart>\n");
        this.writeChart(chart);
        this.writeXyzDataset((JRXyzDataset)chart.getDataset());
        this.writeBubblePlot((JRBubblePlot)chart.getPlot());
        this.sb.append("\t\t\t</bubbleChart>\n");
    }

    public void writeStackedBarChart(JRChart chart) {
        this.sb.append("\t\t\t<stackedBarChart>\n");
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBarPlot((JRBarPlot)chart.getPlot());
        this.sb.append("\t\t\t</stackedBarChart>\n");
    }

    public void writeStackedBar3DChart(JRChart chart) {
        this.sb.append("\t\t\t<stackedBar3DChart>\n");
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeBar3DPlot((JRBar3DPlot)chart.getPlot());
        this.sb.append("\t\t\t</stackedBar3DChart>\n");
    }

    public void writeLineChart(JRChart chart) {
        this.sb.append("\t\t\t<lineChart>\n");
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeLinePlot((JRLinePlot)chart.getPlot());
        this.sb.append("\t\t\t</lineChart>\n");
    }

    public void writeTimeSeriesChart(JRChart chart) {
        this.sb.append("\t\t\t<timeSeriesChart>\n");
        this.writeChart(chart);
        this.writeTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset());
        this.writeTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot());
        this.sb.append("\t\t\t</timeSeriesChart>\n");
    }

    public void writeHighLowDataset(JRHighLowDataset dataset) {
        this.sb.append("\t\t\t\t<highLowDataset>\n");
        this.writeDataset(dataset);
        if (dataset.getSeriesExpression() != null) {
            this.sb.append("\t\t\t\t\t<seriesExpression><![CDATA[");
            this.sb.append(dataset.getSeriesExpression().getText());
            this.sb.append("]]></seriesExpression>\n");
        }
        if (dataset.getDateExpression() != null) {
            this.sb.append("\t\t\t\t\t<dateExpression><![CDATA[");
            this.sb.append(dataset.getDateExpression().getText());
            this.sb.append("]]></dateExpression>\n");
        }
        if (dataset.getHighExpression() != null) {
            this.sb.append("\t\t\t\t\t<highExpression><![CDATA[");
            this.sb.append(dataset.getHighExpression().getText());
            this.sb.append("]]></highExpression>\n");
        }
        if (dataset.getLowExpression() != null) {
            this.sb.append("\t\t\t\t\t<lowExpression><![CDATA[");
            this.sb.append(dataset.getLowExpression().getText());
            this.sb.append("]]></lowExpression>\n");
        }
        if (dataset.getOpenExpression() != null) {
            this.sb.append("\t\t\t\t\t<openExpression><![CDATA[");
            this.sb.append(dataset.getOpenExpression().getText());
            this.sb.append("]]></openExpression>\n");
        }
        if (dataset.getCloseExpression() != null) {
            this.sb.append("\t\t\t\t\t<closeExpression><![CDATA[");
            this.sb.append(dataset.getCloseExpression().getText());
            this.sb.append("]]></closeExpression>\n");
        }
        if (dataset.getVolumeExpression() != null) {
            this.sb.append("\t\t\t\t\t<volumeExpression><![CDATA[");
            this.sb.append(dataset.getVolumeExpression().getText());
            this.sb.append("]]></volumeExpression>\n");
        }
        this.sb.append("\t\t\t\t</highLowDataset>\n");
    }

    public void writeHighLowChart(JRChart chart) {
        this.sb.append("\t\t\t<highLowChart>\n");
        this.writeChart(chart);
        this.writeHighLowDataset((JRHighLowDataset)chart.getDataset());
        JRHighLowPlot plot = (JRHighLowPlot)chart.getPlot();
        this.sb.append("\t\t\t\t<highLowPlot");
        if (!plot.isShowOpenTicks()) {
            this.sb.append(" isShowOpenTicks=\"false\"");
        }
        if (!plot.isShowCloseTicks()) {
            this.sb.append(" isShowCloseTicks=\"false\"");
        }
        this.sb.append(">\n");
        this.writePlot(plot);
        if (plot.getTimeAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<timeAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getTimeAxisLabelExpression().getText());
            this.sb.append("]]></timeAxisLabelExpression>\n");
        }
        if (plot.getValueAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<valueAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getValueAxisLabelExpression().getText());
            this.sb.append("]]></valueAxisLabelExpression>\n");
        }
        this.sb.append("\t\t\t\t</highLowPlot>\n");
        this.sb.append("\t\t\t</highLowChart>\n");
    }

    public void writeCandlestickChart(JRChart chart) {
        this.sb.append("\t\t\t<candlestickChart>\n");
        this.writeChart(chart);
        this.writeHighLowDataset((JRHighLowDataset)chart.getDataset());
        JRCandlestickPlot plot = (JRCandlestickPlot)chart.getPlot();
        this.sb.append("\t\t\t\t<candlestickPlot");
        if (!plot.isShowVolume()) {
            this.sb.append(" isShowVolume=\"false\"");
        }
        this.sb.append(">\n");
        this.writePlot(plot);
        if (plot.getTimeAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<timeAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getTimeAxisLabelExpression().getText());
            this.sb.append("]]></timeAxisLabelExpression>\n");
        }
        if (plot.getValueAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<valueAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getValueAxisLabelExpression().getText());
            this.sb.append("]]></valueAxisLabelExpression>\n");
        }
        this.sb.append("\t\t\t\t</candlestickPlot>\n");
        this.sb.append("\t\t\t</candlestickChart>\n");
    }

    private void writeAreaPlot(JRAreaPlot plot) {
        this.sb.append("\t\t\t\t<areaPlot>\n");
        this.writePlot(plot);
        if (plot.getCategoryAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<categoryAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getCategoryAxisLabelExpression().getText());
            this.sb.append("]]></categoryAxisLabelExpression>\n");
        }
        if (plot.getValueAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<valueAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getValueAxisLabelExpression().getText());
            this.sb.append("]]></valueAxisLabelExpression>\n");
        }
        this.sb.append("\t\t\t\t</areaPlot>\n");
    }

    public void writeAreaChart(JRChart chart) {
        this.sb.append("\t\t\t<areaChart>\n");
        this.writeChart(chart);
        this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset());
        this.writeAreaPlot((JRAreaPlot)chart.getPlot());
        this.sb.append("\t\t\t</areaChart>\n");
    }

    private void writeScatterPlot(JRScatterPlot plot) {
        this.sb.append("\t\t\t\t<scatterPlot");
        if (!plot.isShowLines()) {
            this.sb.append(" isShowLines=\"false\"");
        }
        if (!plot.isShowShapes()) {
            this.sb.append(" isShowShapes=\"false\"");
        }
        this.sb.append(">\n");
        this.writePlot(plot);
        if (plot.getXAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<xAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getXAxisLabelExpression().getText());
            this.sb.append("]]></xAxisLabelExpression>\n");
        }
        if (plot.getYAxisLabelExpression() != null) {
            this.sb.append("\t\t\t\t\t<yAxisLabelExpression><![CDATA[");
            this.sb.append(plot.getYAxisLabelExpression().getText());
            this.sb.append("]]></yAxisLabelExpression>\n");
        }
        this.sb.append("\t\t\t\t</scatterPlot>\n");
    }

    public void writeScatterChart(JRChart chart) {
        this.sb.append("\t\t\t<scatterChart>\n");
        this.writeChart(chart);
        this.writeXyDataset((JRXyDataset)chart.getDataset());
        this.writeScatterPlot((JRScatterPlot)chart.getPlot());
        this.sb.append("\t\t\t</scatterChart>\n");
    }

    public void writeXyAreaChart(JRChart chart) {
        this.sb.append("\t\t\t<xyAreaChart>\n");
        this.writeChart(chart);
        this.writeXyDataset((JRXyDataset)chart.getDataset());
        this.writeAreaPlot((JRAreaPlot)chart.getPlot());
        this.sb.append("\t\t\t</xyAreaChart>\n");
    }

    public void writeXyBarChart(JRChart chart) {
        this.sb.append("\t\t\t<xyBarChart>\n");
        this.writeChart(chart);
        JRChartDataset dataset = chart.getDataset();
        if (dataset.getDatasetType() == 6) {
            this.writeTimeSeriesDataset((JRTimeSeriesDataset)dataset);
        } else if (dataset.getDatasetType() == 5) {
            this.writeTimePeriodDataset((JRTimePeriodDataset)dataset);
        } else if (dataset.getDatasetType() == 3) {
            this.writeXyDataset((JRXyDataset)dataset);
        }
        this.writeBarPlot((JRBarPlot)chart.getPlot());
        this.sb.append("\t\t\t</xyBarChart>\n");
    }

    public void writeXyLineChart(JRChart chart) {
        this.sb.append("\t\t\t<xyLineChart>\n");
        this.writeChart(chart);
        this.writeXyDataset((JRXyDataset)chart.getDataset());
        this.writeLinePlot((JRLinePlot)chart.getPlot());
        this.sb.append("\t\t\t</xyLineChart>\n");
    }

    public void writeChartTag(JRChart chart) {
        switch (chart.getChartType()) {
            case 1: {
                this.writeAreaChart(chart);
                break;
            }
            case 3: {
                this.writeBarChart(chart);
                break;
            }
            case 2: {
                this.writeBar3DChart(chart);
                break;
            }
            case 4: {
                this.writeBubbleChart(chart);
                break;
            }
            case 5: {
                this.writeCandlestickChart(chart);
                break;
            }
            case 6: {
                this.writeHighLowChart(chart);
                break;
            }
            case 7: {
                this.writeLineChart(chart);
                break;
            }
            case 9: {
                this.writePieChart(chart);
                break;
            }
            case 8: {
                this.writePie3DChart(chart);
                break;
            }
            case 10: {
                this.writeScatterChart(chart);
                break;
            }
            case 12: {
                this.writeStackedBarChart(chart);
                break;
            }
            case 11: {
                this.writeStackedBar3DChart(chart);
                break;
            }
            case 16: {
                this.writeTimeSeriesChart(chart);
                break;
            }
            case 13: {
                this.writeXyAreaChart(chart);
                break;
            }
            case 14: {
                this.writeXyBarChart(chart);
                break;
            }
            case 15: {
                this.writeXyLineChart(chart);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    private void writeSubreportReturnValue(JRSubreportReturnValue returnValue) {
        this.sb.append("\t\t\t\t<returnValue");
        if (returnValue.getSubreportVariable() != null) {
            this.sb.append(" subreportVariable=\"");
            this.sb.append(returnValue.getSubreportVariable());
            this.sb.append("\"");
        }
        if (returnValue.getToVariable() != null) {
            this.sb.append(" toVariable=\"");
            this.sb.append(returnValue.getToVariable());
            this.sb.append("\"");
        }
        if (returnValue.getCalculation() != 0) {
            this.sb.append(" calculation=\"");
            this.sb.append((String)JRXmlConstants.getCalculationMap().get(new Byte(returnValue.getCalculation())));
            this.sb.append("\"");
        }
        if (returnValue.getIncrementerFactoryClassName() != null) {
            this.sb.append(" incrementerFactoryClass=\"");
            this.sb.append(returnValue.getIncrementerFactoryClassName());
            this.sb.append("\"");
        }
        this.sb.append("/>\n");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

