/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.keys;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomPrivateKey;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAParameterSpec;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class CustomDSAPrivateKey
extends CustomPrivateKey
implements DSAPrivateKey {
    private static final Logger LOGGER = LogManager.getLogger();
    private final BigInteger privateKey;
    private final BigInteger primeP;
    private final BigInteger primeQ;
    private final BigInteger generator;

    public CustomDSAPrivateKey(BigInteger privateKey, BigInteger primeP, BigInteger primeQ, BigInteger generator) {
        this.privateKey = privateKey;
        this.primeP = primeP;
        this.primeQ = primeQ;
        this.generator = generator;
    }

    private CustomDSAPrivateKey() {
        this.primeP = null;
        this.primeQ = null;
        this.generator = null;
        this.privateKey = null;
    }

    @Override
    public BigInteger getX() {
        return this.privateKey;
    }

    @Override
    public DSAParams getParams() {
        return new DSAParameterSpec(this.primeP, this.primeQ, this.generator);
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public String getFormat() {
        return "DSA";
    }

    @Override
    public byte[] getEncoded() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void adjustInContext(TlsContext context, ConnectionEndType ownerOfKey) {
        LOGGER.debug("Adjusting DSA private key in context");
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                context.setClientDsaPrivateKey(this.privateKey);
                context.setClientDsaGenerator(this.generator);
                context.setClientDsaPrimeP(this.primeP);
                context.setClientDsaPrimeQ(this.primeQ);
                break;
            }
            case SERVER: {
                context.setServerDsaPrivateKey(this.privateKey);
                context.setServerDsaGenerator(this.generator);
                context.setServerDsaPrimeP(this.primeP);
                context.setServerDsaPrimeQ(this.primeQ);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    @Override
    public void adjustInConfig(Config config, ConnectionEndType ownerOfKey) {
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                config.setDefaultClientDsaPrivateKey(this.privateKey);
                config.setDefaultClientDsaPrimeP(this.primeP);
                config.setDefaultClientDsaPrimeQ(this.primeQ);
                config.setDefaultClientDsaGenerator(this.generator);
                break;
            }
            case SERVER: {
                config.setDefaultServerDsaPrivateKey(this.privateKey);
                config.setDefaultServerDsaPrimeP(this.primeP);
                config.setDefaultServerDsaPrimeQ(this.primeQ);
                config.setDefaultServerDsaGenerator(this.generator);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode(this.privateKey);
        hash = 53 * hash + Objects.hashCode(this.primeP);
        hash = 53 * hash + Objects.hashCode(this.primeQ);
        hash = 53 * hash + Objects.hashCode(this.generator);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomDSAPrivateKey other = (CustomDSAPrivateKey)obj;
        if (!Objects.equals(this.privateKey, other.privateKey)) {
            return false;
        }
        if (!Objects.equals(this.primeP, other.primeP)) {
            return false;
        }
        if (!Objects.equals(this.primeQ, other.primeQ)) {
            return false;
        }
        return Objects.equals(this.generator, other.generator);
    }
}

