/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.converters.uni;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class UniToMultiPublisher<T>
implements Flow.Publisher<T> {
    private final Uni<T> uni;

    public UniToMultiPublisher(Uni<T> uni) {
        this.uni = uni;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> downstream) {
        downstream.onSubscribe(new UniToMultiSubscription<T>(this.uni, downstream));
    }

    private static class UniToMultiSubscription<T>
    implements UniSubscription,
    Flow.Subscription,
    UniSubscriber<T>,
    ContextSupport {
        private final Uni<T> uni;
        private final Flow.Subscriber<? super T> downstream;
        private volatile UniSubscription upstream;
        private volatile State state = State.INIT;
        private static final AtomicReferenceFieldUpdater<UniToMultiSubscription, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(UniToMultiSubscription.class, State.class, "state");

        private UniToMultiSubscription(Uni<T> uni, Flow.Subscriber<? super T> downstream) {
            this.uni = uni;
            this.downstream = downstream;
        }

        @Override
        public Context context() {
            if (this.downstream instanceof ContextSupport) {
                return ((ContextSupport)((Object)this.downstream)).context();
            }
            return Context.empty();
        }

        @Override
        public void cancel() {
            if (STATE_UPDATER.getAndSet(this, State.DONE) != State.DONE && this.upstream != null) {
                this.upstream.cancel();
            }
        }

        @Override
        public void request(long n) {
            if (STATE_UPDATER.compareAndSet(this, State.INIT, State.UNI_REQUESTED)) {
                if (n <= 0L) {
                    this.onFailure(new IllegalArgumentException("Invalid request"));
                } else {
                    AbstractUni.subscribe(this.uni, this);
                }
            }
        }

        @Override
        public void onSubscribe(UniSubscription subscription) {
            if (this.upstream == null) {
                this.upstream = subscription;
            } else {
                subscription.cancel();
                this.downstream.onError(new IllegalStateException("Invalid subscription state - already have a subscription for upstream"));
            }
        }

        @Override
        public void onItem(T item) {
            if (STATE_UPDATER.compareAndSet(this, State.UNI_REQUESTED, State.DONE)) {
                if (item != null) {
                    this.downstream.onNext(item);
                }
                this.downstream.onComplete();
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (STATE_UPDATER.compareAndSet(this, State.UNI_REQUESTED, State.DONE)) {
                this.downstream.onError(failure);
            }
        }

        static enum State {
            INIT,
            UNI_REQUESTED,
            DONE;

        }
    }
}

