/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filters.geoip;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;

enum Field {
    AUTONOMOUS_SYSTEM_NUMBER("as.number", "asn"),
    AUTONOMOUS_SYSTEM_ORGANIZATION("as.organization.name", "as_org"),
    CITY_NAME("geo.city_name", "city_name"),
    COUNTRY_NAME("geo.country_name", "country_name"),
    CONTINENT_CODE("geo.continent_code", "continent_code"),
    CONTINENT_NAME("geo.continent_name", "continent_name"),
    COUNTRY_CODE2("geo.country_iso_code", "country_code2"),
    COUNTRY_CODE3("", "country_code3"),
    DOMAIN("domain"),
    IP("ip"),
    ISP("mmdb.isp", "isp"),
    POSTAL_CODE("geo.postal_code", "postal_code"),
    DMA_CODE("mmdb.dma_code", "dma_code"),
    REGION_NAME("geo.region_name", "region_name"),
    REGION_CODE("geo.region_code", "region_code"),
    REGION_ISO_CODE("geo.region_iso_code", "region_iso_code"),
    TIMEZONE("geo.timezone", "timezone"),
    LOCATION("geo.location", "location"),
    LATITUDE("geo.location.lat", "latitude"),
    LONGITUDE("geo.location.lon", "longitude"),
    ORGANIZATION("mmdb.organization", "organization"),
    NETWORK("ip_traits.network", "network"),
    HOSTING_PROVIDER("ip_traits.hosting_provider", "hosting_provider"),
    TOR_EXIT_NODE("ip_traits.tor_exit_node", "tor_exit_node"),
    ANONYMOUS_VPN("ip_traits.anonymous_vpn", "anonymous_vpn"),
    ANONYMOUS("ip_traits.anonymous", "anonymous"),
    PUBLIC_PROXY("ip_traits.public_proxy", "public_proxy"),
    RESIDENTIAL_PROXY("ip_traits.residential_proxy", "residential_proxy");

    private final String fieldName;
    private final String ecsFieldName;
    private final String fieldReferenceLegacy;
    private final String fieldReferenceECSv1;

    @Deprecated
    private Field(String fieldName) {
        this(fieldName, fieldName);
    }

    private Field(String ecsFieldName, String legacyFieldName) {
        this.ecsFieldName = ecsFieldName;
        this.fieldName = legacyFieldName;
        this.fieldReferenceLegacy = Field.normalizeFieldReferenceFragment(this.fieldName);
        this.fieldReferenceECSv1 = Field.normalizeFieldReferenceFragment(ecsFieldName);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String getEcsFieldName() {
        return this.ecsFieldName;
    }

    public String getFieldReferenceLegacy() {
        return this.fieldReferenceLegacy;
    }

    public String getFieldReferenceECSv1() {
        return this.fieldReferenceECSv1;
    }

    public static Field parseField(String value) {
        String candidate = value.toUpperCase(Locale.ROOT);
        try {
            return Field.valueOf(candidate);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("illegal field value " + value + ". valid values are " + Arrays.toString((Object[])Field.values()));
        }
    }

    static String normalizeFieldReferenceFragment(String fieldName) {
        return Stream.of(fieldName.split("\\.")).map(f -> "[" + f + "]").collect(Collectors.joining());
    }
}

