/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;

public class Name {
    final X500Name name;
    private transient long hash = 0L;

    public Name(X500Principal principal) {
        this.name = X500Name.getInstance((Object)principal.getEncoded());
    }

    public Name(X500Name name2) {
        this.name = name2;
    }

    public static long hashOld(X500Name name2) throws IOException {
        try {
            byte[] bytes = name2.getEncoded();
            MessageDigest md5 = SecurityHelper.getMessageDigest("MD5");
            byte[] digest2 = md5.digest(bytes);
            long result = 0L;
            result |= (long)(digest2[3] & 0xFF);
            result <<= 8;
            result |= (long)(digest2[2] & 0xFF);
            result <<= 8;
            result |= (long)(digest2[1] & 0xFF);
            result <<= 8;
            return (result |= (long)(digest2[0] & 0xFF)) & 0xFFFFFFFFFFFFFFFFL;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static long hash(X500Name canonicalName) throws IOException {
        try {
            byte[] bytes = canonicalName.getEncoded();
            MessageDigest sha = SecurityHelper.getMessageDigest("SHA1");
            int n = Name.getLeadingTLLength(bytes);
            sha.update(bytes, n, bytes.length - n);
            byte[] digest2 = sha.digest();
            long result = 0L;
            result |= (long)(digest2[3] & 0xFF);
            result <<= 8;
            result |= (long)(digest2[2] & 0xFF);
            result <<= 8;
            result |= (long)(digest2[1] & 0xFF);
            result <<= 8;
            return (result |= (long)(digest2[0] & 0xFF)) & 0xFFFFFFFFFFFFFFFFL;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getLeadingTLLength(byte[] bytes) throws IOException {
        if (bytes.length <= 1) {
            return bytes.length;
        }
        byte length = bytes[1];
        if ((length & 0x80) == 128) {
            int size2 = length & 0x7F;
            return 2 + size2;
        }
        return 2;
    }

    public final long hash() {
        try {
            return this.hash == 0L ? (this.hash = Name.hash(this.name)) : this.hash;
        }
        catch (IOException e) {
            return 0L;
        }
        catch (RuntimeException e) {
            return 0L;
        }
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean equals(Object that) {
        if (that instanceof Name) {
            return this.name.equals((Object)((Name)that).name);
        }
        return false;
    }

    public boolean equalTo(X500Name name2) {
        return this.name.equals((Object)name2);
    }

    final boolean equalTo(Principal principal) {
        return new X509Principal(this.name).equals((Object)principal);
    }

    public boolean equalTo(X500Principal principal) {
        try {
            return new X500Principal(this.name.getEncoded("DER")).equals(principal);
        }
        catch (IOException e) {
            return false;
        }
    }

    public final boolean equalToCertificateSubject(X509AuxCertificate wrapper) {
        X509Certificate cert2 = wrapper.cert;
        if (cert2 == null) {
            return this.equalTo(wrapper.getSubjectX500Principal());
        }
        if (cert2 instanceof X509CertificateObject) {
            return this.equalTo(cert2.getSubjectDN());
        }
        return this.equalTo(cert2.getSubjectX500Principal());
    }
}

