/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.factory;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.PluginConfigSpec;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.JavaInternalBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.Event;
import org.logstash.RubyUtil;
import org.logstash.ext.JrubyEventExtLibrary;

public class RubyCodecDelegator
implements Codec {
    private static final Logger LOGGER = LogManager.getLogger(RubyCodecDelegator.class);
    private final ThreadContext currentContext;
    private final IRubyObject pluginInstance;
    private final String wrappingId;

    public RubyCodecDelegator(ThreadContext currentContext, IRubyObject pluginInstance) {
        this.currentContext = currentContext;
        this.pluginInstance = pluginInstance;
        RubyCodecDelegator.verifyCodecAncestry(pluginInstance);
        this.invokeRubyRegister(currentContext, pluginInstance);
        this.wrappingId = "jw-" + this.wrappedPluginId();
    }

    private String wrappedPluginId() {
        RubyString id = (RubyString)this.pluginInstance.callMethod(this.currentContext, "id");
        return id.toString();
    }

    private static void verifyCodecAncestry(IRubyObject pluginInstance) {
        if (!RubyCodecDelegator.isRubyCodecSubclass(pluginInstance)) {
            throw new IllegalStateException("Ruby wrapped codec is expected to subclass LogStash::Codecs::Base");
        }
    }

    public static boolean isRubyCodecSubclass(IRubyObject pluginInstance) {
        RubyClass codecBaseClass = RubyUtil.RUBY.getModule("LogStash").getModule("Codecs").getClass("Base");
        return pluginInstance.getType().hasModuleInHierarchy((RubyModule)codecBaseClass);
    }

    private void invokeRubyRegister(ThreadContext currentContext, IRubyObject pluginInstance) {
        pluginInstance.callMethod(currentContext, "register");
    }

    @Override
    public void decode(ByteBuffer buffer, final Consumer<Map<String, Object>> eventConsumer) {
        if (buffer.remaining() == 0) {
            return;
        }
        Block consumerWrapper = new Block((BlockBody)new JavaInternalBlockBody(this.currentContext.runtime, Signature.ONE_ARGUMENT){

            public IRubyObject yield(ThreadContext context, IRubyObject[] args) {
                IRubyObject event = args[0];
                eventConsumer.accept(((JrubyEventExtLibrary.RubyEvent)event).getEvent().getData());
                return event;
            }
        });
        byte[] byteInput = new byte[buffer.remaining()];
        buffer.get(byteInput);
        RubyString data = RubyUtil.RUBY.newString(new String(byteInput));
        IRubyObject[] methodParams = new IRubyObject[]{data};
        this.pluginInstance.callMethod(this.currentContext, "decode", methodParams, consumerWrapper);
    }

    @Override
    public void flush(ByteBuffer buffer, Consumer<Map<String, Object>> eventConsumer) {
        this.decode(buffer, eventConsumer);
    }

    @Override
    public void encode(co.elastic.logstash.api.Event event, OutputStream output) throws IOException {
        if (!(event instanceof Event)) {
            throw new IllegalStateException("The object to encode must be of type org.logstash.Event");
        }
        JrubyEventExtLibrary.RubyEvent rubyEvent = JrubyEventExtLibrary.RubyEvent.newRubyEvent(this.currentContext.runtime, (Event)event);
        RubyArray param = RubyArray.newArray((Ruby)this.currentContext.runtime, (IRubyObject)rubyEvent);
        RubyArray encoded = (RubyArray)this.pluginInstance.callMethod(this.currentContext, "multi_encode", (IRubyObject)param);
        RubyString result = ((RubyArray)encoded.eltInternal(0)).eltInternal(1).convertToString();
        output.write(result.getByteList().getUnsafeBytes(), result.getByteList().getBegin(), result.getByteList().getRealSize());
    }

    @Override
    public Codec cloneCodec() {
        return new RubyCodecDelegator(this.currentContext, this.pluginInstance);
    }

    @Override
    public Collection<PluginConfigSpec<?>> configSchema() {
        return null;
    }

    @Override
    public String getId() {
        return this.wrappingId;
    }
}

