/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.input;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Vector2f;

public class KeyboardTest {
    private Vector2f position = new Vector2f(320.0f, 240.0f);
    private DisplayMode displayMode;

    private void initialize() {
        this.setupDisplay(false);
        try {
            Keyboard.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    protected boolean setDisplayMode() {
        try {
            DisplayMode[] dm = org.lwjgl.util.Display.getAvailableDisplayModes((int)640, (int)480, (int)-1, (int)-1, (int)-1, (int)-1, (int)60, (int)60);
            org.lwjgl.util.Display.setDisplayMode((DisplayMode[])dm, (String[])new String[]{"width=640", "height=480", "freq=60", "bpp=" + Display.getDisplayMode().getBitsPerPixel()});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void setupDisplay(boolean fullscreen) {
        try {
            this.setDisplayMode();
            Display.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.initializeOpenGL();
    }

    private void initializeOpenGL() {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D((float)0.0f, (float)Display.getDisplayMode().getWidth(), (float)0.0f, (float)Display.getDisplayMode().getHeight());
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glViewport((int)0, (int)0, (int)Display.getDisplayMode().getWidth(), (int)Display.getDisplayMode().getHeight());
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    public void executeTest() {
        this.initialize();
        this.createKeyboard();
        this.wiggleKeyboard();
        Keyboard.destroy();
        Display.destroy();
    }

    private void createKeyboard() {
        try {
            Keyboard.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void wiggleKeyboard() {
        while (!Display.isCloseRequested()) {
            Display.update();
            if (!Display.isVisible()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException inte) {
                    inte.printStackTrace();
                }
                continue;
            }
            Keyboard.poll();
            int count = Keyboard.getNumKeyboardEvents();
            while (Keyboard.next()) {
                int character_code = Keyboard.getEventCharacter() & 0xFFFF;
                System.out.println("Checking key:" + Keyboard.getKeyName((int)Keyboard.getEventKey()));
                System.out.println("Pressed:" + Keyboard.getEventKeyState());
                System.out.println("Key character code: 0x" + Integer.toHexString(character_code));
                System.out.println("Key character: " + Keyboard.getEventCharacter());
                System.out.println("Repeat event: " + Keyboard.isRepeatEvent());
                if (Keyboard.getEventKey() == 19 && Keyboard.getEventKeyState()) {
                    Keyboard.enableRepeatEvents((!Keyboard.areRepeatEventsEnabled() ? 1 : 0) != 0);
                }
                if (Keyboard.getEventKey() != 1) continue;
                return;
            }
            if (Keyboard.isKeyDown((int)205)) {
                this.position.x += 1.0f;
            }
            if (Keyboard.isKeyDown((int)203)) {
                this.position.x -= 1.0f;
            }
            if (Keyboard.isKeyDown((int)200)) {
                this.position.y += 1.0f;
            }
            if (Keyboard.isKeyDown((int)208)) {
                this.position.y -= 1.0f;
            }
            if (count > 0) {
                System.out.println();
            }
            if (this.position.x < 0.0f) {
                this.position.x = 0.0f;
            } else if (this.position.x > 580.0f) {
                this.position.x = 580.0f;
            }
            if (this.position.y < 0.0f) {
                this.position.y = 0.0f;
            } else if (this.position.y > 450.0f) {
                this.position.y = 450.0f;
            }
            this.render();
            Display.sync((int)60);
        }
    }

    private void render() {
        GL11.glClear((int)16384);
        GL11.glBegin((int)9);
        float color = 1.0f;
        GL11.glColor3f((float)color, (float)color, (float)color);
        GL11.glVertex2f((float)(this.position.x + 0.0f), (float)(this.position.y + 0.0f));
        GL11.glVertex2f((float)(this.position.x + 0.0f), (float)(this.position.y + 30.0f));
        GL11.glVertex2f((float)(this.position.x + 40.0f), (float)(this.position.y + 30.0f));
        GL11.glVertex2f((float)(this.position.x + 60.0f), (float)(this.position.y + 15.0f));
        GL11.glVertex2f((float)(this.position.x + 40.0f), (float)(this.position.y + 0.0f));
        GL11.glEnd();
    }

    public static void main(String[] args) {
        KeyboardTest kt = new KeyboardTest();
        kt.executeTest();
        System.exit(0);
    }
}

