/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrKeyboardSpaceCreateInfoFB;
import org.lwjgl.openxr.XrKeyboardTrackingDescriptionFB;
import org.lwjgl.openxr.XrKeyboardTrackingQueryFB;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class FBKeyboardTracking {
    public static final int XR_FB_keyboard_tracking_SPEC_VERSION = 1;
    public static final String XR_FB_KEYBOARD_TRACKING_EXTENSION_NAME = "XR_FB_keyboard_tracking";
    public static final int XR_MAX_KEYBOARD_TRACKING_NAME_SIZE_FB = 128;
    public static final int XR_TYPE_KEYBOARD_SPACE_CREATE_INFO_FB = 1000116009;
    public static final int XR_TYPE_KEYBOARD_TRACKING_QUERY_FB = 1000116004;
    public static final int XR_TYPE_SYSTEM_KEYBOARD_TRACKING_PROPERTIES_FB = 1000116002;
    public static final int XR_KEYBOARD_TRACKING_EXISTS_BIT_FB = 1;
    public static final int XR_KEYBOARD_TRACKING_LOCAL_BIT_FB = 2;
    public static final int XR_KEYBOARD_TRACKING_REMOTE_BIT_FB = 4;
    public static final int XR_KEYBOARD_TRACKING_CONNECTED_BIT_FB = 8;
    public static final int XR_KEYBOARD_TRACKING_QUERY_LOCAL_BIT_FB = 2;
    public static final int XR_KEYBOARD_TRACKING_QUERY_REMOTE_BIT_FB = 4;

    protected FBKeyboardTracking() {
        throw new UnsupportedOperationException();
    }

    public static int nxrQuerySystemTrackedKeyboardFB(XrSession session, long queryInfo, long keyboard) {
        long __functionAddress = session.getCapabilities().xrQuerySystemTrackedKeyboardFB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)session.address(), (long)queryInfo, (long)keyboard, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrQuerySystemTrackedKeyboardFB(XrSession session, @NativeType(value="XrKeyboardTrackingQueryFB const *") XrKeyboardTrackingQueryFB queryInfo, @NativeType(value="XrKeyboardTrackingDescriptionFB *") XrKeyboardTrackingDescriptionFB keyboard) {
        return FBKeyboardTracking.nxrQuerySystemTrackedKeyboardFB(session, queryInfo.address(), keyboard.address());
    }

    public static int nxrCreateKeyboardSpaceFB(XrSession session, long createInfo, long keyboardSpace) {
        long __functionAddress = session.getCapabilities().xrCreateKeyboardSpaceFB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)session.address(), (long)createInfo, (long)keyboardSpace, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateKeyboardSpaceFB(XrSession session, @NativeType(value="XrKeyboardSpaceCreateInfoFB const *") XrKeyboardSpaceCreateInfoFB createInfo, @NativeType(value="XrSpace *") PointerBuffer keyboardSpace) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)keyboardSpace, (int)1);
        }
        return FBKeyboardTracking.nxrCreateKeyboardSpaceFB(session, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)keyboardSpace));
    }
}

