/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.common;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public abstract class AbstractUID {
    private static final Pattern SEGMENT_PATTERN = Pattern.compile("[\\w-]*");
    public static final String SEPARATOR = ":";
    private final List<String> segments;
    private String uid = "";

    protected AbstractUID() {
        this.segments = List.of();
    }

    protected AbstractUID(String uid) {
        this(AbstractUID.splitToSegments(uid));
        this.uid = uid;
    }

    protected AbstractUID(String ... segments) {
        this(Arrays.asList(segments));
    }

    protected AbstractUID(List<String> segments) {
        int minNumberOfSegments = this.getMinimalNumberOfSegments();
        int numberOfSegments = segments.size();
        if (numberOfSegments < minNumberOfSegments) {
            throw new IllegalArgumentException(String.format("UID must have at least %d segments: %s", minNumberOfSegments, segments));
        }
        int i = 0;
        while (i < numberOfSegments) {
            String segment = segments.get(i);
            this.validateSegment(segment, i, numberOfSegments);
            ++i;
        }
        if (segments.get(numberOfSegments - 1).isBlank()) {
            throw new IllegalArgumentException("Last segment must not be blank: " + String.valueOf(segments));
        }
        this.segments = List.copyOf(segments);
    }

    protected abstract int getMinimalNumberOfSegments();

    protected List<String> getAllSegments() {
        return this.segments;
    }

    protected String getSegment(int segment) {
        return this.segments.get(segment);
    }

    public static boolean isValid(@Nullable String segment) {
        return segment != null && SEGMENT_PATTERN.matcher(segment).matches();
    }

    protected void validateSegment(String segment, int index, int length) {
        if (!AbstractUID.isValid(segment)) {
            throw new IllegalArgumentException(String.format("ID segment '%s' contains invalid characters. Each segment of the ID must match the pattern %s.", segment, SEGMENT_PATTERN));
        }
    }

    public String toString() {
        return this.getAsString();
    }

    public String getAsString() {
        if (this.uid.isEmpty()) {
            this.uid = String.join((CharSequence)SEPARATOR, this.segments);
        }
        return this.uid;
    }

    private static List<String> splitToSegments(String id) {
        return Arrays.asList(id.split(SEPARATOR));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.segments.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractUID other = (AbstractUID)obj;
        return this.segments.equals(other.segments);
    }
}

