"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryInsightsDashboardsPlugin = void 0;
var _queryInsightsPlugin = require("./clusters/queryInsightsPlugin");
var _routes = require("./routes");
var _wlmRoutes = require("./routes/wlmRoutes");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class QueryInsightsDashboardsPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, {
    dataSource
  }) {
    const dataSourceEnabled = !!dataSource;
    const router = core.http.createRouter();
    const queryInsightsClient = core.opensearch.legacy.createClient('opensearch_queryInsights', {
      plugins: [_queryInsightsPlugin.QueryInsightsPlugin]
    });
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_queryInsightsPlugin.QueryInsightsPlugin);
    }

    // @ts-ignore
    core.http.registerRouteHandlerContext('queryInsights_plugin', (_context, _request) => {
      return {
        logger: this.logger,
        queryInsightsClient
      };
    });

    // Register server side APIs
    (0, _routes.defineRoutes)(router, dataSourceEnabled);
    (0, _wlmRoutes.defineWlmRoutes)(router);
    return {};
  }
  start(_core) {
    this.logger.debug('query-insights-dashboards: Started');
    return {};
  }
  stop() {}
}
exports.QueryInsightsDashboardsPlugin = QueryInsightsDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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