# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("secur32.dll")
prototypes = \
    {
        #
        'LsaRegisterLogonProcess': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LogonProcessName", "LsaHandle", "SecurityMode"]),
        #
        'LsaLogonUser': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="STRING", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SECURITY_LOGON_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"GroupCount": SimTypeInt(signed=False, label="UInt32"), "Groups": SimTypePointer(SimStruct({"Sid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Attributes": SimTypeInt(signed=False, label="UInt32")}, name="SID_AND_ATTRIBUTES", pack=False, align=None), offset=0)}, name="TOKEN_GROUPS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"SourceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 8), "SourceIdentifier": SimTypeBottom(label="LUID")}, name="TOKEN_SOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"PagedPoolLimit": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "NonPagedPoolLimit": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "MinimumWorkingSetSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "MaximumWorkingSetSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "PagefileLimit": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "TimeLimit": SimTypeBottom(label="LARGE_INTEGER")}, name="QUOTA_LIMITS", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LsaHandle", "OriginName", "LogonType", "AuthenticationPackage", "AuthenticationInformation", "AuthenticationInformationLength", "LocalGroups", "SourceContext", "ProfileBuffer", "ProfileBufferLength", "LogonId", "Token", "Quotas", "SubStatus"]),
        #
        'LsaLookupAuthenticationPackage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LsaHandle", "PackageName", "AuthenticationPackage"]),
        #
        'LsaFreeReturnBuffer': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Buffer"]),
        #
        'LsaCallAuthenticationPackage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LsaHandle", "AuthenticationPackage", "ProtocolSubmitBuffer", "SubmitBufferLength", "ProtocolReturnBuffer", "ReturnBufferLength", "ProtocolStatus"]),
        #
        'LsaDeregisterLogonProcess': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LsaHandle"]),
        #
        'LsaConnectUntrusted': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LsaHandle"]),
        #
        'LsaEnumerateLogonSessions': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LogonSessionCount", "LogonSessionList"]),
        #
        'LsaGetLogonSessionData': SimTypeFunction([SimTypePointer(SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "LogonId": SimTypeBottom(label="LUID"), "UserName": SimTypeBottom(label="UNICODE_STRING"), "LogonDomain": SimTypeBottom(label="UNICODE_STRING"), "AuthenticationPackage": SimTypeBottom(label="UNICODE_STRING"), "LogonType": SimTypeInt(signed=False, label="UInt32"), "Session": SimTypeInt(signed=False, label="UInt32"), "Sid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "LogonTime": SimTypeBottom(label="LARGE_INTEGER"), "LogonServer": SimTypeBottom(label="UNICODE_STRING"), "DnsDomainName": SimTypeBottom(label="UNICODE_STRING"), "Upn": SimTypeBottom(label="UNICODE_STRING"), "UserFlags": SimTypeInt(signed=False, label="UInt32"), "LastLogonInfo": SimStruct({"LastSuccessfulLogon": SimTypeBottom(label="LARGE_INTEGER"), "LastFailedLogon": SimTypeBottom(label="LARGE_INTEGER"), "FailedAttemptCountSinceLastSuccessfulLogon": SimTypeInt(signed=False, label="UInt32")}, name="LSA_LAST_INTER_LOGON_INFO", pack=False, align=None), "LogonScript": SimTypeBottom(label="UNICODE_STRING"), "ProfilePath": SimTypeBottom(label="UNICODE_STRING"), "HomeDirectory": SimTypeBottom(label="UNICODE_STRING"), "HomeDirectoryDrive": SimTypeBottom(label="UNICODE_STRING"), "LogoffTime": SimTypeBottom(label="LARGE_INTEGER"), "KickOffTime": SimTypeBottom(label="LARGE_INTEGER"), "PasswordLastSet": SimTypeBottom(label="LARGE_INTEGER"), "PasswordCanChange": SimTypeBottom(label="LARGE_INTEGER"), "PasswordMustChange": SimTypeBottom(label="LARGE_INTEGER")}, name="SECURITY_LOGON_SESSION_DATA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LogonId", "ppLogonSessionData"]),
        #
        'LsaRegisterPolicyChangeNotification': SimTypeFunction([SimTypeInt(signed=False, label="POLICY_NOTIFICATION_INFORMATION_CLASS"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InformationClass", "NotificationEventHandle"]),
        #
        'LsaUnregisterPolicyChangeNotification': SimTypeFunction([SimTypeInt(signed=False, label="POLICY_NOTIFICATION_INFORMATION_CLASS"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InformationClass", "NotificationEventHandle"]),
        #
        'AcquireCredentialsHandleW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="SECPKG_CRED"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Arg", "Principal", "KeyVer", "Key", "Status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPrincipal", "pszPackage", "fCredentialUse", "pvLogonId", "pAuthData", "pGetKeyFn", "pvGetKeyArgument", "phCredential", "ptsExpiry"]),
        #
        'AcquireCredentialsHandleA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="SECPKG_CRED"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Arg", "Principal", "KeyVer", "Key", "Status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPrincipal", "pszPackage", "fCredentialUse", "pvLogonId", "pAuthData", "pGetKeyFn", "pvGetKeyArgument", "phCredential", "ptsExpiry"]),
        #
        'FreeCredentialsHandle': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phCredential"]),
        #
        'AddCredentialsW': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Arg", "Principal", "KeyVer", "Key", "Status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCredentials", "pszPrincipal", "pszPackage", "fCredentialUse", "pAuthData", "pGetKeyFn", "pvGetKeyArgument", "ptsExpiry"]),
        #
        'AddCredentialsA': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Arg", "Principal", "KeyVer", "Key", "Status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hCredentials", "pszPrincipal", "pszPackage", "fCredentialUse", "pAuthData", "pGetKeyFn", "pvGetKeyArgument", "ptsExpiry"]),
        #
        'ChangeAccountPasswordW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPackageName", "pszDomainName", "pszAccountName", "pszOldPassword", "pszNewPassword", "bImpersonating", "dwReserved", "pOutput"]),
        #
        'ChangeAccountPasswordA': SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPackageName", "pszDomainName", "pszAccountName", "pszOldPassword", "pszNewPassword", "bImpersonating", "dwReserved", "pOutput"]),
        #
        'InitializeSecurityContextW': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phCredential", "phContext", "pszTargetName", "fContextReq", "Reserved1", "TargetDataRep", "pInput", "Reserved2", "phNewContext", "pOutput", "pfContextAttr", "ptsExpiry"]),
        #
        'InitializeSecurityContextA': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phCredential", "phContext", "pszTargetName", "fContextReq", "Reserved1", "TargetDataRep", "pInput", "Reserved2", "phNewContext", "pOutput", "pfContextAttr", "ptsExpiry"]),
        #
        'AcceptSecurityContext': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="ACCEPT_SECURITY_CONTEXT_CONTEXT_REQ"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phCredential", "phContext", "pInput", "fContextReq", "TargetDataRep", "phNewContext", "pOutput", "pfContextAttr", "ptsExpiry"]),
        #
        'CompleteAuthToken': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext", "pToken"]),
        #
        'ImpersonateSecurityContext': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext"]),
        #
        'RevertSecurityContext': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext"]),
        #
        'QuerySecurityContextToken': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext", "Token"]),
        #
        'DeleteSecurityContext': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext"]),
        #
        'ApplyControlToken': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext", "pInput"]),
        #
        'QueryContextAttributesW': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SECPKG_ATTR"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext", "ulAttribute", "pBuffer"]),
        #
        'QueryContextAttributesA': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SECPKG_ATTR"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext", "ulAttribute", "pBuffer"]),
        #
        'SetContextAttributesW': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SECPKG_ATTR"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext", "ulAttribute", "pBuffer", "cbBuffer"]),
        #
        'SetContextAttributesA': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SECPKG_ATTR"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext", "ulAttribute", "pBuffer", "cbBuffer"]),
        #
        'QueryCredentialsAttributesW': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phCredential", "ulAttribute", "pBuffer"]),
        #
        'QueryCredentialsAttributesA': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phCredential", "ulAttribute", "pBuffer"]),
        #
        'SetCredentialsAttributesW': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["phCredential", "ulAttribute", "pBuffer", "cbBuffer"]),
        #
        'SetCredentialsAttributesA': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["phCredential", "ulAttribute", "pBuffer", "cbBuffer"]),
        #
        'FreeContextBuffer': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvContextBuffer"]),
        #
        'MakeSignature': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext", "fQOP", "pMessage", "MessageSeqNo"]),
        #
        'VerifySignature': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext", "pMessage", "MessageSeqNo", "pfQOP"]),
        #
        'EncryptMessage': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext", "fQOP", "pMessage", "MessageSeqNo"]),
        #
        'DecryptMessage': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext", "pMessage", "MessageSeqNo", "pfQOP"]),
        #
        'EnumerateSecurityPackagesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"fCapabilities": SimTypeInt(signed=False, label="UInt32"), "wVersion": SimTypeShort(signed=False, label="UInt16"), "wRPCID": SimTypeShort(signed=False, label="UInt16"), "cbMaxToken": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "Comment": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="SecPkgInfoW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcPackages", "ppPackageInfo"]),
        #
        'EnumerateSecurityPackagesA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"fCapabilities": SimTypeInt(signed=False, label="UInt32"), "wVersion": SimTypeShort(signed=False, label="UInt16"), "wRPCID": SimTypeShort(signed=False, label="UInt16"), "cbMaxToken": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="SecPkgInfoA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcPackages", "ppPackageInfo"]),
        #
        'QuerySecurityPackageInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"fCapabilities": SimTypeInt(signed=False, label="UInt32"), "wVersion": SimTypeShort(signed=False, label="UInt16"), "wRPCID": SimTypeShort(signed=False, label="UInt16"), "cbMaxToken": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "Comment": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="SecPkgInfoW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPackageName", "ppPackageInfo"]),
        #
        'QuerySecurityPackageInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"fCapabilities": SimTypeInt(signed=False, label="UInt32"), "wVersion": SimTypeShort(signed=False, label="UInt16"), "wRPCID": SimTypeShort(signed=False, label="UInt16"), "cbMaxToken": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="SecPkgInfoA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPackageName", "ppPackageInfo"]),
        #
        'ExportSecurityContext': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="EXPORT_SECURITY_CONTEXT_FLAGS"), SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phContext", "fFlags", "pPackedContext", "pToken"]),
        #
        'ImportSecurityContextW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPackage", "pPackedContext", "Token", "phContext"]),
        #
        'ImportSecurityContextA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPackage", "pPackedContext", "Token", "phContext"]),
        #
        'InitSecurityInterfaceA': SimTypeFunction([], SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "EnumerateSecurityPackagesA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"fCapabilities": SimTypeInt(signed=False, label="UInt32"), "wVersion": SimTypeShort(signed=False, label="UInt16"), "wRPCID": SimTypeShort(signed=False, label="UInt16"), "cbMaxToken": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="SecPkgInfoA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), "QueryCredentialsAttributesA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2"]), offset=0), "AcquireCredentialsHandleA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Arg", "Principal", "KeyVer", "Key", "Status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7", "param8"]), offset=0), "FreeCredentialsHandle": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0), "Reserved2": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "InitializeSecurityContextA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7", "param8", "param9", "param10", "param11"]), offset=0), "AcceptSecurityContext": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7", "param8"]), offset=0), "CompleteAuthToken": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), "DeleteSecurityContext": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0), "ApplyControlToken": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), "QueryContextAttributesA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2"]), offset=0), "ImpersonateSecurityContext": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0), "RevertSecurityContext": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0), "MakeSignature": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "VerifySignature": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "FreeContextBuffer": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0), "QuerySecurityPackageInfoA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"fCapabilities": SimTypeInt(signed=False, label="UInt32"), "wVersion": SimTypeShort(signed=False, label="UInt16"), "wRPCID": SimTypeShort(signed=False, label="UInt16"), "cbMaxToken": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="SecPkgInfoA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), "Reserved3": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved4": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ExportSecurityContext": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "ImportSecurityContextA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "AddCredentialsA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Arg", "Principal", "KeyVer", "Key", "Status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7"]), offset=0), "Reserved8": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "QuerySecurityContextToken": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), "EncryptMessage": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "DecryptMessage": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "SetContextAttributesA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "SetCredentialsAttributesA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "ChangeAccountPasswordA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7"]), offset=0), "QueryContextAttributesExA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "QueryCredentialsAttributesExA": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0)}, name="SecurityFunctionTableA", pack=False, align=None), offset=0)),
        #
        'InitSecurityInterfaceW': SimTypeFunction([], SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "EnumerateSecurityPackagesW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"fCapabilities": SimTypeInt(signed=False, label="UInt32"), "wVersion": SimTypeShort(signed=False, label="UInt16"), "wRPCID": SimTypeShort(signed=False, label="UInt16"), "cbMaxToken": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "Comment": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="SecPkgInfoW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), "QueryCredentialsAttributesW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2"]), offset=0), "AcquireCredentialsHandleW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Arg", "Principal", "KeyVer", "Key", "Status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7", "param8"]), offset=0), "FreeCredentialsHandle": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0), "Reserved2": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "InitializeSecurityContextW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7", "param8", "param9", "param10", "param11"]), offset=0), "AcceptSecurityContext": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7", "param8"]), offset=0), "CompleteAuthToken": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), "DeleteSecurityContext": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0), "ApplyControlToken": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), "QueryContextAttributesW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2"]), offset=0), "ImpersonateSecurityContext": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0), "RevertSecurityContext": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0), "MakeSignature": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "VerifySignature": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "FreeContextBuffer": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]), offset=0), "QuerySecurityPackageInfoW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"fCapabilities": SimTypeInt(signed=False, label="UInt32"), "wVersion": SimTypeShort(signed=False, label="UInt16"), "wRPCID": SimTypeShort(signed=False, label="UInt16"), "cbMaxToken": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "Comment": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="SecPkgInfoW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), "Reserved3": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved4": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ExportSecurityContext": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "ImportSecurityContextW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "AddCredentialsW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Arg", "Principal", "KeyVer", "Key", "Status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7"]), offset=0), "Reserved8": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "QuerySecurityContextToken": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), "EncryptMessage": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "DecryptMessage": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "SetContextAttributesW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "SetCredentialsAttributesW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "ChangeAccountPasswordW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6", "param7"]), offset=0), "QueryContextAttributesExW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "QueryCredentialsAttributesExW": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="SecHandle"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0)}, name="SecurityFunctionTableW", pack=False, align=None), offset=0)),
        #
        'SaslEnumerateProfilesA': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ProfileList", "ProfileCount"]),
        #
        'SaslEnumerateProfilesW': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ProfileList", "ProfileCount"]),
        #
        'SaslGetProfilePackageA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"fCapabilities": SimTypeInt(signed=False, label="UInt32"), "wVersion": SimTypeShort(signed=False, label="UInt16"), "wRPCID": SimTypeShort(signed=False, label="UInt16"), "cbMaxToken": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="SecPkgInfoA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ProfileName", "PackageInfo"]),
        #
        'SaslGetProfilePackageW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"fCapabilities": SimTypeInt(signed=False, label="UInt32"), "wVersion": SimTypeShort(signed=False, label="UInt16"), "wRPCID": SimTypeShort(signed=False, label="UInt16"), "cbMaxToken": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "Comment": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="SecPkgInfoW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ProfileName", "PackageInfo"]),
        #
        'SaslIdentifyPackageA': SimTypeFunction([SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"fCapabilities": SimTypeInt(signed=False, label="UInt32"), "wVersion": SimTypeShort(signed=False, label="UInt16"), "wRPCID": SimTypeShort(signed=False, label="UInt16"), "cbMaxToken": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Comment": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="SecPkgInfoA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pInput", "PackageInfo"]),
        #
        'SaslIdentifyPackageW': SimTypeFunction([SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"fCapabilities": SimTypeInt(signed=False, label="UInt32"), "wVersion": SimTypeShort(signed=False, label="UInt16"), "wRPCID": SimTypeShort(signed=False, label="UInt16"), "cbMaxToken": SimTypeInt(signed=False, label="UInt32"), "Name": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "Comment": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="SecPkgInfoW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pInput", "PackageInfo"]),
        #
        'SaslInitializeSecurityContextW': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phCredential", "phContext", "pszTargetName", "fContextReq", "Reserved1", "TargetDataRep", "pInput", "Reserved2", "phNewContext", "pOutput", "pfContextAttr", "ptsExpiry"]),
        #
        'SaslInitializeSecurityContextA': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phCredential", "phContext", "pszTargetName", "fContextReq", "Reserved1", "TargetDataRep", "pInput", "Reserved2", "phNewContext", "pOutput", "pfContextAttr", "ptsExpiry"]),
        #
        'SaslAcceptSecurityContext': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SecBuffer", pack=False, align=None), offset=0)}, name="SecBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phCredential", "phContext", "pInput", "fContextReq", "TargetDataRep", "phNewContext", "pOutput", "pfContextAttr", "ptsExpiry"]),
        #
        'SaslSetContextOption': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ContextHandle", "Option", "Value", "Size"]),
        #
        'SaslGetContextOption': SimTypeFunction([SimTypePointer(SimStruct({"dwLower": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwUpper": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="SecHandle", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ContextHandle", "Option", "Value", "Size", "Needed"]),
        #
        'SspiPrepareForCredRead': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AuthIdentity", "pszTargetName", "pCredmanCredentialType", "ppszCredmanTargetName"]),
        #
        'SspiPrepareForCredWrite': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AuthIdentity", "pszTargetName", "pCredmanCredentialType", "ppszCredmanTargetName", "ppszCredmanUserName", "ppCredentialBlob", "pCredentialBlobSize"]),
        #
        'SspiEncryptAuthIdentity': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AuthData"]),
        #
        'SspiDecryptAuthIdentity': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["EncryptedAuthData"]),
        #
        'SspiIsAuthIdentityEncrypted': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeChar(label="Byte"), arg_names=["EncryptedAuthData"]),
        #
        'SspiEncodeAuthIdentityAsStrings': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAuthIdentity", "ppszUserName", "ppszDomainName", "ppszPackedCredentialsString"]),
        #
        'SspiValidateAuthIdentity': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AuthData"]),
        #
        'SspiCopyAuthIdentity': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AuthData", "AuthDataCopy"]),
        #
        'SspiFreeAuthIdentity': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["AuthData"]),
        #
        'SspiZeroAuthIdentity': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["AuthData"]),
        #
        'SspiLocalFree': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["DataBuffer"]),
        #
        'SspiEncodeStringsAsAuthIdentity': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszUserName", "pszDomainName", "pszPackedCredentialsString", "ppAuthIdentity"]),
        #
        'SspiCompareAuthIdentities': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AuthIdentity1", "AuthIdentity2", "SameSuppliedUser", "SameSuppliedIdentity"]),
        #
        'SspiMarshalAuthIdentity': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AuthIdentity", "AuthIdentityLength", "AuthIdentityByteArray"]),
        #
        'SspiUnmarshalAuthIdentity': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AuthIdentityLength", "AuthIdentityByteArray", "ppAuthIdentity"]),
        #
        'SspiGetTargetHostName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszTargetName", "pszHostName"]),
        #
        'SspiExcludePackage': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AuthIdentity", "pszPackageName", "ppNewAuthIdentity"]),
        #
        'AddSecurityPackageA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="SECURITY_PACKAGE_OPTIONS_TYPE"), "Flags": SimTypeInt(signed=False, label="UInt32"), "SignatureSize": SimTypeInt(signed=False, label="UInt32"), "Signature": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SECURITY_PACKAGE_OPTIONS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPackageName", "pOptions"]),
        #
        'AddSecurityPackageW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="SECURITY_PACKAGE_OPTIONS_TYPE"), "Flags": SimTypeInt(signed=False, label="UInt32"), "SignatureSize": SimTypeInt(signed=False, label="UInt32"), "Signature": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="SECURITY_PACKAGE_OPTIONS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPackageName", "pOptions"]),
        #
        'DeleteSecurityPackageA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPackageName"]),
        #
        'DeleteSecurityPackageW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPackageName"]),
        #
        'CredMarshalTargetInfo': SimTypeFunction([SimTypePointer(SimStruct({"TargetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NetbiosServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NetbiosDomainName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsDomainName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsTreeName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PackageName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "CredTypeCount": SimTypeInt(signed=False, label="UInt32"), "CredTypes": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CREDENTIAL_TARGET_INFORMATIONW", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["InTargetInfo", "Buffer", "BufferSize"]),
        #
        'CredUnmarshalTargetInfo': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"TargetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NetbiosServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NetbiosDomainName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsDomainName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "DnsTreeName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "PackageName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "CredTypeCount": SimTypeInt(signed=False, label="UInt32"), "CredTypes": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CREDENTIAL_TARGET_INFORMATIONW", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Buffer", "BufferSize", "RetTargetInfo", "RetActualSize"]),
        #
        'GetUserNameExA': SimTypeFunction([SimTypeInt(signed=False, label="EXTENDED_NAME_FORMAT"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["NameFormat", "lpNameBuffer", "nSize"]),
        #
        'GetUserNameExW': SimTypeFunction([SimTypeInt(signed=False, label="EXTENDED_NAME_FORMAT"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["NameFormat", "lpNameBuffer", "nSize"]),
        #
        'GetComputerObjectNameA': SimTypeFunction([SimTypeInt(signed=False, label="EXTENDED_NAME_FORMAT"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["NameFormat", "lpNameBuffer", "nSize"]),
        #
        'GetComputerObjectNameW': SimTypeFunction([SimTypeInt(signed=False, label="EXTENDED_NAME_FORMAT"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["NameFormat", "lpNameBuffer", "nSize"]),
        #
        'TranslateNameA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="EXTENDED_NAME_FORMAT"), SimTypeInt(signed=False, label="EXTENDED_NAME_FORMAT"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["lpAccountName", "AccountNameFormat", "DesiredNameFormat", "lpTranslatedName", "nSize"]),
        #
        'TranslateNameW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="EXTENDED_NAME_FORMAT"), SimTypeInt(signed=False, label="EXTENDED_NAME_FORMAT"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["lpAccountName", "AccountNameFormat", "DesiredNameFormat", "lpTranslatedName", "nSize"]),
    }

lib.set_prototypes(prototypes)
