/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import org.traccar.NetworkMessage;

public class NetworkMessageHandler
extends ChannelDuplexHandler {
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (ctx.channel() instanceof DatagramChannel) {
            DatagramPacket packet = (DatagramPacket)msg;
            ctx.fireChannelRead((Object)new NetworkMessage(packet.content(), packet.sender()));
        } else if (msg instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)msg;
            ctx.fireChannelRead((Object)new NetworkMessage(buffer, ctx.channel().remoteAddress()));
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof NetworkMessage) {
            NetworkMessage message = (NetworkMessage)msg;
            if (ctx.channel() instanceof DatagramChannel) {
                InetSocketAddress recipient = (InetSocketAddress)message.getRemoteAddress();
                InetSocketAddress sender = (InetSocketAddress)ctx.channel().localAddress();
                ctx.write((Object)new DatagramPacket((ByteBuf)message.getMessage(), recipient, sender), promise);
            } else {
                ctx.write(message.getMessage(), promise);
            }
        } else {
            ctx.write(msg, promise);
        }
    }
}

