/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.pswing;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolox.pswing.PSwingMouseMotionEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class PSwingMouseEvent
extends MouseEvent
implements Serializable {
    private int id;
    private PInputEvent event;

    protected PSwingMouseEvent(int n, MouseEvent mouseEvent, PInputEvent pInputEvent) {
        super((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        this.id = n;
        this.event = pInputEvent;
    }

    public static PSwingMouseEvent createMouseEvent(int n, MouseEvent mouseEvent, PInputEvent pInputEvent) {
        if (n == 503 || n == 506) {
            return new PSwingMouseMotionEvent(n, mouseEvent, pInputEvent);
        }
        return new PSwingMouseEvent(n, mouseEvent, pInputEvent);
    }

    public Point2D getLocalPoint() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public double getLocalX() {
        return this.getLocalPoint().getX();
    }

    public double getLocalY() {
        return this.getLocalPoint().getY();
    }

    public int getID() {
        return this.id;
    }

    public PNode getNode() {
        return this.event.getPickedNode();
    }

    public PPickPath getPath() {
        return this.event.getPath();
    }

    public PNode getGrabNode() {
        return this.event.getPickedNode();
    }

    public PPickPath getGrabPath() {
        return this.getPath();
    }

    public PNode getCurrentNode() {
        return this.event.getPickedNode();
    }

    public PPickPath getCurrentPath() {
        return this.getPath();
    }

    public void dispatchTo(Object object) {
        if (object instanceof MouseListener) {
            MouseListener mouseListener = (MouseListener)object;
            switch (this.getID()) {
                case 500: {
                    mouseListener.mouseClicked(this);
                    break;
                }
                case 504: {
                    mouseListener.mouseEntered(this);
                    break;
                }
                case 505: {
                    mouseListener.mouseExited(this);
                    break;
                }
                case 501: {
                    mouseListener.mousePressed(this);
                    break;
                }
                case 502: {
                    mouseListener.mouseReleased(this);
                    break;
                }
                default: {
                    throw new RuntimeException("PMouseEvent with bad ID");
                }
            }
        } else {
            MouseMotionListener mouseMotionListener = (MouseMotionListener)object;
            switch (this.getID()) {
                case 506: {
                    mouseMotionListener.mouseDragged(this);
                    break;
                }
                case 503: {
                    mouseMotionListener.mouseMoved(this);
                    break;
                }
                default: {
                    throw new RuntimeException("PMouseMotionEvent with bad ID");
                }
            }
        }
    }

    public void setSource(Object object) {
        this.source = object;
    }
}

