/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;

public class ErrorMessage
extends ObjectMessage {
    public static final String TAG = "error";
    private static final String MESSAGE_TAG = "message";

    public ErrorMessage(StringTemplate template, String message) {
        super(TAG, MESSAGE_TAG, message);
        this.appendChild(template);
    }

    public ErrorMessage(StringTemplate template) {
        super(TAG);
        this.appendChild(template);
    }

    public ErrorMessage(String message) {
        this(StringTemplate.template("server.reject"), message);
    }

    public ErrorMessage(Exception ex) {
        this(FreeCol.errorFromException(ex, "server.reject"));
    }

    public ErrorMessage(String key, Exception ex) {
        this((StringTemplate)StringTemplate.template(key).addName("%message%", ex.getMessage()), null);
    }

    public ErrorMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, MESSAGE_TAG);
        StringTemplate template = null;
        while (xr.moreTags()) {
            String tag = xr.getLocalName();
            if ("stringTemplate".equals(tag)) {
                if (template == null) {
                    template = xr.readFreeColObject(game, StringTemplate.class);
                    continue;
                }
                this.expected(TAG, tag);
                continue;
            }
            this.expected("stringTemplate", tag);
        }
        xr.expectTag(TAG);
        this.appendChild(template);
    }

    private StringTemplate getTemplate() {
        return this.getChild(0, StringTemplate.class);
    }

    private String getMessage() {
        return this.getStringAttribute(MESSAGE_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        StringTemplate template = this.getTemplate();
        String message = this.getMessage();
        if (freeColClient.isInGame()) {
            this.igc(freeColClient).errorHandler(template, message);
            this.clientGeneric(freeColClient);
        } else {
            this.pgc(freeColClient).errorHandler(template, message);
        }
    }
}

