/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * require_extensions: GL_AMD_shader_trinary_minmax
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mid3(ivec2(-5, -5), ivec2(-5, -5), ivec2(-5, -2)) => ivec2(-5, -5)
 * mid3(ivec2(-5, -5), ivec2(-5, -5), ivec2(-1, 0)) => ivec2(-5, -5)
 * mid3(ivec2(-5, -5), ivec2(-5, -5), ivec2(1, 2)) => ivec2(-5, -5)
 * mid3(ivec2(-5, -5), ivec2(-5, -2), ivec2(5, -5)) => ivec2(-5, -5)
 * mid3(ivec2(-5, -5), ivec2(-2, -2), ivec2(-2, -1)) => ivec2(-2, -2)
 * mid3(ivec2(-5, -5), ivec2(-2, -2), ivec2(0, 1)) => ivec2(-2, -2)
 * mid3(ivec2(-5, -5), ivec2(-2, -2), ivec2(2, 5)) => ivec2(-2, -2)
 * mid3(ivec2(-5, -5), ivec2(-1, -1), ivec2(-5, -2)) => ivec2(-5, -2)
 * mid3(ivec2(-5, -5), ivec2(-1, -1), ivec2(-1, 0)) => ivec2(-1, -1)
 * mid3(ivec2(-5, -5), ivec2(-1, -1), ivec2(1, 2)) => ivec2(-1, -1)
 * mid3(ivec2(-5, -5), ivec2(-1, 0), ivec2(5, -5)) => ivec2(-1, -5)
 * mid3(ivec2(-5, -5), ivec2(0, 0), ivec2(-2, -1)) => ivec2(-2, -1)
 * mid3(ivec2(-5, -5), ivec2(0, 0), ivec2(0, 1)) => ivec2(0, 0)
 * mid3(ivec2(-5, -5), ivec2(0, 0), ivec2(2, 5)) => ivec2(0, 0)
 * mid3(ivec2(-5, -5), ivec2(1, 1), ivec2(-5, -2)) => ivec2(-5, -2)
 * mid3(ivec2(-5, -5), ivec2(1, 1), ivec2(-1, 0)) => ivec2(-1, 0)
 * mid3(ivec2(-5, -5), ivec2(1, 1), ivec2(1, 2)) => ivec2(1, 1)
 * mid3(ivec2(-5, -5), ivec2(1, 2), ivec2(5, -5)) => ivec2(1, -5)
 * mid3(ivec2(-5, -5), ivec2(2, 2), ivec2(-2, -1)) => ivec2(-2, -1)
 * mid3(ivec2(-5, -5), ivec2(2, 2), ivec2(0, 1)) => ivec2(0, 1)
 * mid3(ivec2(-5, -5), ivec2(2, 2), ivec2(2, 5)) => ivec2(2, 2)
 * mid3(ivec2(-5, -5), ivec2(5, 5), ivec2(-5, -2)) => ivec2(-5, -2)
 * mid3(ivec2(-5, -5), ivec2(5, 5), ivec2(-1, 0)) => ivec2(-1, 0)
 * mid3(ivec2(-5, -5), ivec2(5, 5), ivec2(1, 2)) => ivec2(1, 2)
 * mid3(ivec2(-5, -2), ivec2(5, -5), ivec2(5, -5)) => ivec2(5, -5)
 * mid3(ivec2(-2, -2), ivec2(-5, -5), ivec2(-2, -1)) => ivec2(-2, -2)
 * mid3(ivec2(-2, -2), ivec2(-5, -5), ivec2(0, 1)) => ivec2(-2, -2)
 * mid3(ivec2(-2, -2), ivec2(-5, -5), ivec2(2, 5)) => ivec2(-2, -2)
 * mid3(ivec2(-2, -2), ivec2(-2, -2), ivec2(-5, -2)) => ivec2(-2, -2)
 * mid3(ivec2(-2, -2), ivec2(-2, -2), ivec2(-1, 0)) => ivec2(-2, -2)
 * mid3(ivec2(-2, -2), ivec2(-2, -2), ivec2(1, 2)) => ivec2(-2, -2)
 * mid3(ivec2(-2, -2), ivec2(-2, -1), ivec2(5, -5)) => ivec2(-2, -2)
 * mid3(ivec2(-2, -2), ivec2(-1, -1), ivec2(-2, -1)) => ivec2(-2, -1)
 * mid3(ivec2(-2, -2), ivec2(-1, -1), ivec2(0, 1)) => ivec2(-1, -1)
 * mid3(ivec2(-2, -2), ivec2(-1, -1), ivec2(2, 5)) => ivec2(-1, -1)
 * mid3(ivec2(-2, -2), ivec2(0, 0), ivec2(-5, -2)) => ivec2(-2, -2)
 * mid3(ivec2(-2, -2), ivec2(0, 0), ivec2(-1, 0)) => ivec2(-1, 0)
 * mid3(ivec2(-2, -2), ivec2(0, 0), ivec2(1, 2)) => ivec2(0, 0)
 * mid3(ivec2(-2, -2), ivec2(0, 1), ivec2(5, -5)) => ivec2(0, -2)
 * mid3(ivec2(-2, -2), ivec2(1, 1), ivec2(-2, -1)) => ivec2(-2, -1)
 * mid3(ivec2(-2, -2), ivec2(1, 1), ivec2(0, 1)) => ivec2(0, 1)
 * mid3(ivec2(-2, -2), ivec2(1, 1), ivec2(2, 5)) => ivec2(1, 1)
 * mid3(ivec2(-2, -2), ivec2(2, 2), ivec2(-5, -2)) => ivec2(-2, -2)
 * mid3(ivec2(-2, -2), ivec2(2, 2), ivec2(-1, 0)) => ivec2(-1, 0)
 * mid3(ivec2(-2, -2), ivec2(2, 2), ivec2(1, 2)) => ivec2(1, 2)
 * mid3(ivec2(-2, -2), ivec2(2, 5), ivec2(5, -5)) => ivec2(2, -2)
 * mid3(ivec2(-2, -2), ivec2(5, 5), ivec2(-2, -1)) => ivec2(-2, -1)
 * mid3(ivec2(-2, -2), ivec2(5, 5), ivec2(0, 1)) => ivec2(0, 1)
 * mid3(ivec2(-2, -2), ivec2(5, 5), ivec2(2, 5)) => ivec2(2, 5)
 * mid3(ivec2(-1, -1), ivec2(-5, -5), ivec2(-5, -2)) => ivec2(-5, -2)
 * mid3(ivec2(-1, -1), ivec2(-5, -5), ivec2(-1, 0)) => ivec2(-1, -1)
 * mid3(ivec2(-1, -1), ivec2(-5, -5), ivec2(1, 2)) => ivec2(-1, -1)
 * mid3(ivec2(-1, -1), ivec2(-5, -2), ivec2(5, -5)) => ivec2(-1, -2)
 * mid3(ivec2(-1, -1), ivec2(-2, -2), ivec2(-2, -1)) => ivec2(-2, -1)
 * mid3(ivec2(-1, -1), ivec2(-2, -2), ivec2(0, 1)) => ivec2(-1, -1)
 * mid3(ivec2(-1, -1), ivec2(-2, -2), ivec2(2, 5)) => ivec2(-1, -1)
 * mid3(ivec2(-1, -1), ivec2(-1, -1), ivec2(-5, -2)) => ivec2(-1, -1)
 * mid3(ivec2(-1, -1), ivec2(-1, -1), ivec2(-1, 0)) => ivec2(-1, -1)
 * mid3(ivec2(-1, -1), ivec2(-1, -1), ivec2(1, 2)) => ivec2(-1, -1)
 * mid3(ivec2(-1, -1), ivec2(-1, 0), ivec2(5, -5)) => ivec2(-1, -1)
 * mid3(ivec2(-1, -1), ivec2(0, 0), ivec2(-2, -1)) => ivec2(-1, -1)
 * mid3(ivec2(-1, -1), ivec2(0, 0), ivec2(0, 1)) => ivec2(0, 0)
 * mid3(ivec2(-1, -1), ivec2(0, 0), ivec2(2, 5)) => ivec2(0, 0)
 * mid3(ivec2(-1, -1), ivec2(1, 1), ivec2(-5, -2)) => ivec2(-1, -1)
 * mid3(ivec2(-1, -1), ivec2(1, 1), ivec2(-1, 0)) => ivec2(-1, 0)
 * mid3(ivec2(-1, -1), ivec2(1, 1), ivec2(1, 2)) => ivec2(1, 1)
 * mid3(ivec2(-1, -1), ivec2(1, 2), ivec2(5, -5)) => ivec2(1, -1)
 * mid3(ivec2(-1, -1), ivec2(2, 2), ivec2(-2, -1)) => ivec2(-1, -1)
 * mid3(ivec2(-1, -1), ivec2(2, 2), ivec2(0, 1)) => ivec2(0, 1)
 * mid3(ivec2(-1, -1), ivec2(2, 2), ivec2(2, 5)) => ivec2(2, 2)
 * mid3(ivec2(-1, -1), ivec2(5, 5), ivec2(-5, -2)) => ivec2(-1, -1)
 * mid3(ivec2(-1, -1), ivec2(5, 5), ivec2(-1, 0)) => ivec2(-1, 0)
 * mid3(ivec2(-1, -1), ivec2(5, 5), ivec2(1, 2)) => ivec2(1, 2)
 * mid3(ivec2(-1, 0), ivec2(5, -5), ivec2(5, -5)) => ivec2(5, -5)
 * mid3(ivec2(0, 0), ivec2(-5, -5), ivec2(-2, -1)) => ivec2(-2, -1)
 * mid3(ivec2(0, 0), ivec2(-5, -5), ivec2(0, 1)) => ivec2(0, 0)
 * mid3(ivec2(0, 0), ivec2(-5, -5), ivec2(2, 5)) => ivec2(0, 0)
 * mid3(ivec2(0, 0), ivec2(-2, -2), ivec2(-5, -2)) => ivec2(-2, -2)
 * mid3(ivec2(0, 0), ivec2(-2, -2), ivec2(-1, 0)) => ivec2(-1, 0)
 * mid3(ivec2(0, 0), ivec2(-2, -2), ivec2(1, 2)) => ivec2(0, 0)
 * mid3(ivec2(0, 0), ivec2(-2, -1), ivec2(5, -5)) => ivec2(0, -1)
 * mid3(ivec2(0, 0), ivec2(-1, -1), ivec2(-2, -1)) => ivec2(-1, -1)
 * mid3(ivec2(0, 0), ivec2(-1, -1), ivec2(0, 1)) => ivec2(0, 0)
 * mid3(ivec2(0, 0), ivec2(-1, -1), ivec2(2, 5)) => ivec2(0, 0)
 * mid3(ivec2(0, 0), ivec2(0, 0), ivec2(-5, -2)) => ivec2(0, 0)
 * mid3(ivec2(0, 0), ivec2(0, 0), ivec2(-1, 0)) => ivec2(0, 0)
 * mid3(ivec2(0, 0), ivec2(0, 0), ivec2(1, 2)) => ivec2(0, 0)
 * mid3(ivec2(0, 0), ivec2(0, 1), ivec2(5, -5)) => ivec2(0, 0)
 * mid3(ivec2(0, 0), ivec2(1, 1), ivec2(-2, -1)) => ivec2(0, 0)
 * mid3(ivec2(0, 0), ivec2(1, 1), ivec2(0, 1)) => ivec2(0, 1)
 * mid3(ivec2(0, 0), ivec2(1, 1), ivec2(2, 5)) => ivec2(1, 1)
 * mid3(ivec2(0, 0), ivec2(2, 2), ivec2(-5, -2)) => ivec2(0, 0)
 * mid3(ivec2(0, 0), ivec2(2, 2), ivec2(-1, 0)) => ivec2(0, 0)
 * mid3(ivec2(0, 0), ivec2(2, 2), ivec2(1, 2)) => ivec2(1, 2)
 * mid3(ivec2(0, 0), ivec2(2, 5), ivec2(5, -5)) => ivec2(2, 0)
 * mid3(ivec2(0, 0), ivec2(5, 5), ivec2(-2, -1)) => ivec2(0, 0)
 * mid3(ivec2(0, 0), ivec2(5, 5), ivec2(0, 1)) => ivec2(0, 1)
 * mid3(ivec2(0, 0), ivec2(5, 5), ivec2(2, 5)) => ivec2(2, 5)
 * mid3(ivec2(1, 1), ivec2(-5, -5), ivec2(-5, -2)) => ivec2(-5, -2)
 * mid3(ivec2(1, 1), ivec2(-5, -5), ivec2(-1, 0)) => ivec2(-1, 0)
 * mid3(ivec2(1, 1), ivec2(-5, -5), ivec2(1, 2)) => ivec2(1, 1)
 * mid3(ivec2(1, 1), ivec2(-5, -2), ivec2(5, -5)) => ivec2(1, -2)
 * mid3(ivec2(1, 1), ivec2(-2, -2), ivec2(-2, -1)) => ivec2(-2, -1)
 * mid3(ivec2(1, 1), ivec2(-2, -2), ivec2(0, 1)) => ivec2(0, 1)
 * mid3(ivec2(1, 1), ivec2(-2, -2), ivec2(2, 5)) => ivec2(1, 1)
 * mid3(ivec2(1, 1), ivec2(-1, -1), ivec2(-5, -2)) => ivec2(-1, -1)
 * mid3(ivec2(1, 1), ivec2(-1, -1), ivec2(-1, 0)) => ivec2(-1, 0)
 * mid3(ivec2(1, 1), ivec2(-1, -1), ivec2(1, 2)) => ivec2(1, 1)
 * mid3(ivec2(1, 1), ivec2(-1, 0), ivec2(5, -5)) => ivec2(1, 0)
 * mid3(ivec2(1, 1), ivec2(0, 0), ivec2(-2, -1)) => ivec2(0, 0)
 * mid3(ivec2(1, 1), ivec2(0, 0), ivec2(0, 1)) => ivec2(0, 1)
 * mid3(ivec2(1, 1), ivec2(0, 0), ivec2(2, 5)) => ivec2(1, 1)
 * mid3(ivec2(1, 1), ivec2(1, 1), ivec2(-5, -2)) => ivec2(1, 1)
 * mid3(ivec2(1, 1), ivec2(1, 1), ivec2(-1, 0)) => ivec2(1, 1)
 * mid3(ivec2(1, 1), ivec2(1, 1), ivec2(1, 2)) => ivec2(1, 1)
 * mid3(ivec2(1, 1), ivec2(1, 2), ivec2(5, -5)) => ivec2(1, 1)
 * mid3(ivec2(1, 1), ivec2(2, 2), ivec2(-2, -1)) => ivec2(1, 1)
 * mid3(ivec2(1, 1), ivec2(2, 2), ivec2(0, 1)) => ivec2(1, 1)
 * mid3(ivec2(1, 1), ivec2(2, 2), ivec2(2, 5)) => ivec2(2, 2)
 * mid3(ivec2(1, 1), ivec2(5, 5), ivec2(-5, -2)) => ivec2(1, 1)
 * mid3(ivec2(1, 1), ivec2(5, 5), ivec2(-1, 0)) => ivec2(1, 1)
 * mid3(ivec2(1, 1), ivec2(5, 5), ivec2(1, 2)) => ivec2(1, 2)
 * mid3(ivec2(1, 2), ivec2(5, -5), ivec2(5, -5)) => ivec2(5, -5)
 * mid3(ivec2(2, 2), ivec2(-5, -5), ivec2(-2, -1)) => ivec2(-2, -1)
 * mid3(ivec2(2, 2), ivec2(-5, -5), ivec2(0, 1)) => ivec2(0, 1)
 * mid3(ivec2(2, 2), ivec2(-5, -5), ivec2(2, 5)) => ivec2(2, 2)
 * mid3(ivec2(2, 2), ivec2(-2, -2), ivec2(-5, -2)) => ivec2(-2, -2)
 * mid3(ivec2(2, 2), ivec2(-2, -2), ivec2(-1, 0)) => ivec2(-1, 0)
 * mid3(ivec2(2, 2), ivec2(-2, -2), ivec2(1, 2)) => ivec2(1, 2)
 * mid3(ivec2(2, 2), ivec2(-2, -1), ivec2(5, -5)) => ivec2(2, -1)
 * mid3(ivec2(2, 2), ivec2(-1, -1), ivec2(-2, -1)) => ivec2(-1, -1)
 * mid3(ivec2(2, 2), ivec2(-1, -1), ivec2(0, 1)) => ivec2(0, 1)
 * mid3(ivec2(2, 2), ivec2(-1, -1), ivec2(2, 5)) => ivec2(2, 2)
 * mid3(ivec2(2, 2), ivec2(0, 0), ivec2(-5, -2)) => ivec2(0, 0)
 * mid3(ivec2(2, 2), ivec2(0, 0), ivec2(-1, 0)) => ivec2(0, 0)
 * mid3(ivec2(2, 2), ivec2(0, 0), ivec2(1, 2)) => ivec2(1, 2)
 * mid3(ivec2(2, 2), ivec2(0, 1), ivec2(5, -5)) => ivec2(2, 1)
 * mid3(ivec2(2, 2), ivec2(1, 1), ivec2(-2, -1)) => ivec2(1, 1)
 * mid3(ivec2(2, 2), ivec2(1, 1), ivec2(0, 1)) => ivec2(1, 1)
 * mid3(ivec2(2, 2), ivec2(1, 1), ivec2(2, 5)) => ivec2(2, 2)
 * mid3(ivec2(2, 2), ivec2(2, 2), ivec2(-5, -2)) => ivec2(2, 2)
 * mid3(ivec2(2, 2), ivec2(2, 2), ivec2(-1, 0)) => ivec2(2, 2)
 * mid3(ivec2(2, 2), ivec2(2, 2), ivec2(1, 2)) => ivec2(2, 2)
 * mid3(ivec2(2, 2), ivec2(2, 5), ivec2(5, -5)) => ivec2(2, 2)
 * mid3(ivec2(2, 2), ivec2(5, 5), ivec2(-2, -1)) => ivec2(2, 2)
 * mid3(ivec2(2, 2), ivec2(5, 5), ivec2(0, 1)) => ivec2(2, 2)
 * mid3(ivec2(2, 2), ivec2(5, 5), ivec2(2, 5)) => ivec2(2, 5)
 * mid3(ivec2(5, 5), ivec2(-5, -5), ivec2(-5, -2)) => ivec2(-5, -2)
 * mid3(ivec2(5, 5), ivec2(-5, -5), ivec2(-1, 0)) => ivec2(-1, 0)
 * mid3(ivec2(5, 5), ivec2(-5, -5), ivec2(1, 2)) => ivec2(1, 2)
 * mid3(ivec2(5, 5), ivec2(-5, -2), ivec2(5, -5)) => ivec2(5, -2)
 * mid3(ivec2(5, 5), ivec2(-2, -2), ivec2(-2, -1)) => ivec2(-2, -1)
 * mid3(ivec2(5, 5), ivec2(-2, -2), ivec2(0, 1)) => ivec2(0, 1)
 * mid3(ivec2(5, 5), ivec2(-2, -2), ivec2(2, 5)) => ivec2(2, 5)
 * mid3(ivec2(5, 5), ivec2(-1, -1), ivec2(-5, -2)) => ivec2(-1, -1)
 * mid3(ivec2(5, 5), ivec2(-1, -1), ivec2(-1, 0)) => ivec2(-1, 0)
 * mid3(ivec2(5, 5), ivec2(-1, -1), ivec2(1, 2)) => ivec2(1, 2)
 * mid3(ivec2(5, 5), ivec2(-1, 0), ivec2(5, -5)) => ivec2(5, 0)
 * mid3(ivec2(5, 5), ivec2(0, 0), ivec2(-2, -1)) => ivec2(0, 0)
 * mid3(ivec2(5, 5), ivec2(0, 0), ivec2(0, 1)) => ivec2(0, 1)
 * mid3(ivec2(5, 5), ivec2(0, 0), ivec2(2, 5)) => ivec2(2, 5)
 * mid3(ivec2(5, 5), ivec2(1, 1), ivec2(-5, -2)) => ivec2(1, 1)
 * mid3(ivec2(5, 5), ivec2(1, 1), ivec2(-1, 0)) => ivec2(1, 1)
 * mid3(ivec2(5, 5), ivec2(1, 1), ivec2(1, 2)) => ivec2(1, 2)
 * mid3(ivec2(5, 5), ivec2(1, 2), ivec2(5, -5)) => ivec2(5, 2)
 * mid3(ivec2(5, 5), ivec2(2, 2), ivec2(-2, -1)) => ivec2(2, 2)
 * mid3(ivec2(5, 5), ivec2(2, 2), ivec2(0, 1)) => ivec2(2, 2)
 * mid3(ivec2(5, 5), ivec2(2, 2), ivec2(2, 5)) => ivec2(2, 5)
 * mid3(ivec2(5, 5), ivec2(5, 5), ivec2(-5, -2)) => ivec2(5, 5)
 * mid3(ivec2(5, 5), ivec2(5, 5), ivec2(-1, 0)) => ivec2(5, 5)
 * mid3(ivec2(5, 5), ivec2(5, 5), ivec2(1, 2)) => ivec2(5, 5)
 * mid3(ivec2(5, -5), ivec2(5, -5), ivec2(5, -5)) => ivec2(5, -5)
 */
#version 130
#extension GL_AMD_shader_trinary_minmax : require

void main()
{
  float[all(equal(mid3(ivec2(-5, -5), ivec2(-5, -5), ivec2(-5, -2)), ivec2(-5, -5))) ? 1 : -1] array0;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(-5, -5), ivec2(-1, 0)), ivec2(-5, -5))) ? 1 : -1] array1;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(-5, -5), ivec2(1, 2)), ivec2(-5, -5))) ? 1 : -1] array2;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(-5, -2), ivec2(5, -5)), ivec2(-5, -5))) ? 1 : -1] array3;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(-2, -2), ivec2(-2, -1)), ivec2(-2, -2))) ? 1 : -1] array4;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(-2, -2), ivec2(0, 1)), ivec2(-2, -2))) ? 1 : -1] array5;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(-2, -2), ivec2(2, 5)), ivec2(-2, -2))) ? 1 : -1] array6;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(-1, -1), ivec2(-5, -2)), ivec2(-5, -2))) ? 1 : -1] array7;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(-1, -1), ivec2(-1, 0)), ivec2(-1, -1))) ? 1 : -1] array8;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(-1, -1), ivec2(1, 2)), ivec2(-1, -1))) ? 1 : -1] array9;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(-1, 0), ivec2(5, -5)), ivec2(-1, -5))) ? 1 : -1] array10;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(0, 0), ivec2(-2, -1)), ivec2(-2, -1))) ? 1 : -1] array11;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(0, 0), ivec2(0, 1)), ivec2(0, 0))) ? 1 : -1] array12;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(0, 0), ivec2(2, 5)), ivec2(0, 0))) ? 1 : -1] array13;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(1, 1), ivec2(-5, -2)), ivec2(-5, -2))) ? 1 : -1] array14;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(1, 1), ivec2(-1, 0)), ivec2(-1, 0))) ? 1 : -1] array15;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(1, 1), ivec2(1, 2)), ivec2(1, 1))) ? 1 : -1] array16;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(1, 2), ivec2(5, -5)), ivec2(1, -5))) ? 1 : -1] array17;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(2, 2), ivec2(-2, -1)), ivec2(-2, -1))) ? 1 : -1] array18;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(2, 2), ivec2(0, 1)), ivec2(0, 1))) ? 1 : -1] array19;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(2, 2), ivec2(2, 5)), ivec2(2, 2))) ? 1 : -1] array20;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(5, 5), ivec2(-5, -2)), ivec2(-5, -2))) ? 1 : -1] array21;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(5, 5), ivec2(-1, 0)), ivec2(-1, 0))) ? 1 : -1] array22;
  float[all(equal(mid3(ivec2(-5, -5), ivec2(5, 5), ivec2(1, 2)), ivec2(1, 2))) ? 1 : -1] array23;
  float[all(equal(mid3(ivec2(-5, -2), ivec2(5, -5), ivec2(5, -5)), ivec2(5, -5))) ? 1 : -1] array24;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(-5, -5), ivec2(-2, -1)), ivec2(-2, -2))) ? 1 : -1] array25;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(-5, -5), ivec2(0, 1)), ivec2(-2, -2))) ? 1 : -1] array26;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(-5, -5), ivec2(2, 5)), ivec2(-2, -2))) ? 1 : -1] array27;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(-2, -2), ivec2(-5, -2)), ivec2(-2, -2))) ? 1 : -1] array28;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(-2, -2), ivec2(-1, 0)), ivec2(-2, -2))) ? 1 : -1] array29;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(-2, -2), ivec2(1, 2)), ivec2(-2, -2))) ? 1 : -1] array30;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(-2, -1), ivec2(5, -5)), ivec2(-2, -2))) ? 1 : -1] array31;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(-1, -1), ivec2(-2, -1)), ivec2(-2, -1))) ? 1 : -1] array32;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(-1, -1), ivec2(0, 1)), ivec2(-1, -1))) ? 1 : -1] array33;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(-1, -1), ivec2(2, 5)), ivec2(-1, -1))) ? 1 : -1] array34;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(0, 0), ivec2(-5, -2)), ivec2(-2, -2))) ? 1 : -1] array35;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(0, 0), ivec2(-1, 0)), ivec2(-1, 0))) ? 1 : -1] array36;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(0, 0), ivec2(1, 2)), ivec2(0, 0))) ? 1 : -1] array37;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(0, 1), ivec2(5, -5)), ivec2(0, -2))) ? 1 : -1] array38;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(1, 1), ivec2(-2, -1)), ivec2(-2, -1))) ? 1 : -1] array39;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(1, 1), ivec2(0, 1)), ivec2(0, 1))) ? 1 : -1] array40;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(1, 1), ivec2(2, 5)), ivec2(1, 1))) ? 1 : -1] array41;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(2, 2), ivec2(-5, -2)), ivec2(-2, -2))) ? 1 : -1] array42;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(2, 2), ivec2(-1, 0)), ivec2(-1, 0))) ? 1 : -1] array43;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(2, 2), ivec2(1, 2)), ivec2(1, 2))) ? 1 : -1] array44;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(2, 5), ivec2(5, -5)), ivec2(2, -2))) ? 1 : -1] array45;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(5, 5), ivec2(-2, -1)), ivec2(-2, -1))) ? 1 : -1] array46;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(5, 5), ivec2(0, 1)), ivec2(0, 1))) ? 1 : -1] array47;
  float[all(equal(mid3(ivec2(-2, -2), ivec2(5, 5), ivec2(2, 5)), ivec2(2, 5))) ? 1 : -1] array48;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(-5, -5), ivec2(-5, -2)), ivec2(-5, -2))) ? 1 : -1] array49;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(-5, -5), ivec2(-1, 0)), ivec2(-1, -1))) ? 1 : -1] array50;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(-5, -5), ivec2(1, 2)), ivec2(-1, -1))) ? 1 : -1] array51;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(-5, -2), ivec2(5, -5)), ivec2(-1, -2))) ? 1 : -1] array52;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(-2, -2), ivec2(-2, -1)), ivec2(-2, -1))) ? 1 : -1] array53;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(-2, -2), ivec2(0, 1)), ivec2(-1, -1))) ? 1 : -1] array54;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(-2, -2), ivec2(2, 5)), ivec2(-1, -1))) ? 1 : -1] array55;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(-1, -1), ivec2(-5, -2)), ivec2(-1, -1))) ? 1 : -1] array56;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(-1, -1), ivec2(-1, 0)), ivec2(-1, -1))) ? 1 : -1] array57;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(-1, -1), ivec2(1, 2)), ivec2(-1, -1))) ? 1 : -1] array58;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(-1, 0), ivec2(5, -5)), ivec2(-1, -1))) ? 1 : -1] array59;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(0, 0), ivec2(-2, -1)), ivec2(-1, -1))) ? 1 : -1] array60;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(0, 0), ivec2(0, 1)), ivec2(0, 0))) ? 1 : -1] array61;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(0, 0), ivec2(2, 5)), ivec2(0, 0))) ? 1 : -1] array62;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(1, 1), ivec2(-5, -2)), ivec2(-1, -1))) ? 1 : -1] array63;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(1, 1), ivec2(-1, 0)), ivec2(-1, 0))) ? 1 : -1] array64;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(1, 1), ivec2(1, 2)), ivec2(1, 1))) ? 1 : -1] array65;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(1, 2), ivec2(5, -5)), ivec2(1, -1))) ? 1 : -1] array66;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(2, 2), ivec2(-2, -1)), ivec2(-1, -1))) ? 1 : -1] array67;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(2, 2), ivec2(0, 1)), ivec2(0, 1))) ? 1 : -1] array68;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(2, 2), ivec2(2, 5)), ivec2(2, 2))) ? 1 : -1] array69;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(5, 5), ivec2(-5, -2)), ivec2(-1, -1))) ? 1 : -1] array70;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(5, 5), ivec2(-1, 0)), ivec2(-1, 0))) ? 1 : -1] array71;
  float[all(equal(mid3(ivec2(-1, -1), ivec2(5, 5), ivec2(1, 2)), ivec2(1, 2))) ? 1 : -1] array72;
  float[all(equal(mid3(ivec2(-1, 0), ivec2(5, -5), ivec2(5, -5)), ivec2(5, -5))) ? 1 : -1] array73;
  float[all(equal(mid3(ivec2(0, 0), ivec2(-5, -5), ivec2(-2, -1)), ivec2(-2, -1))) ? 1 : -1] array74;
  float[all(equal(mid3(ivec2(0, 0), ivec2(-5, -5), ivec2(0, 1)), ivec2(0, 0))) ? 1 : -1] array75;
  float[all(equal(mid3(ivec2(0, 0), ivec2(-5, -5), ivec2(2, 5)), ivec2(0, 0))) ? 1 : -1] array76;
  float[all(equal(mid3(ivec2(0, 0), ivec2(-2, -2), ivec2(-5, -2)), ivec2(-2, -2))) ? 1 : -1] array77;
  float[all(equal(mid3(ivec2(0, 0), ivec2(-2, -2), ivec2(-1, 0)), ivec2(-1, 0))) ? 1 : -1] array78;
  float[all(equal(mid3(ivec2(0, 0), ivec2(-2, -2), ivec2(1, 2)), ivec2(0, 0))) ? 1 : -1] array79;
  float[all(equal(mid3(ivec2(0, 0), ivec2(-2, -1), ivec2(5, -5)), ivec2(0, -1))) ? 1 : -1] array80;
  float[all(equal(mid3(ivec2(0, 0), ivec2(-1, -1), ivec2(-2, -1)), ivec2(-1, -1))) ? 1 : -1] array81;
  float[all(equal(mid3(ivec2(0, 0), ivec2(-1, -1), ivec2(0, 1)), ivec2(0, 0))) ? 1 : -1] array82;
  float[all(equal(mid3(ivec2(0, 0), ivec2(-1, -1), ivec2(2, 5)), ivec2(0, 0))) ? 1 : -1] array83;
  float[all(equal(mid3(ivec2(0, 0), ivec2(0, 0), ivec2(-5, -2)), ivec2(0, 0))) ? 1 : -1] array84;
  float[all(equal(mid3(ivec2(0, 0), ivec2(0, 0), ivec2(-1, 0)), ivec2(0, 0))) ? 1 : -1] array85;
  float[all(equal(mid3(ivec2(0, 0), ivec2(0, 0), ivec2(1, 2)), ivec2(0, 0))) ? 1 : -1] array86;
  float[all(equal(mid3(ivec2(0, 0), ivec2(0, 1), ivec2(5, -5)), ivec2(0, 0))) ? 1 : -1] array87;
  float[all(equal(mid3(ivec2(0, 0), ivec2(1, 1), ivec2(-2, -1)), ivec2(0, 0))) ? 1 : -1] array88;
  float[all(equal(mid3(ivec2(0, 0), ivec2(1, 1), ivec2(0, 1)), ivec2(0, 1))) ? 1 : -1] array89;
  float[all(equal(mid3(ivec2(0, 0), ivec2(1, 1), ivec2(2, 5)), ivec2(1, 1))) ? 1 : -1] array90;
  float[all(equal(mid3(ivec2(0, 0), ivec2(2, 2), ivec2(-5, -2)), ivec2(0, 0))) ? 1 : -1] array91;
  float[all(equal(mid3(ivec2(0, 0), ivec2(2, 2), ivec2(-1, 0)), ivec2(0, 0))) ? 1 : -1] array92;
  float[all(equal(mid3(ivec2(0, 0), ivec2(2, 2), ivec2(1, 2)), ivec2(1, 2))) ? 1 : -1] array93;
  float[all(equal(mid3(ivec2(0, 0), ivec2(2, 5), ivec2(5, -5)), ivec2(2, 0))) ? 1 : -1] array94;
  float[all(equal(mid3(ivec2(0, 0), ivec2(5, 5), ivec2(-2, -1)), ivec2(0, 0))) ? 1 : -1] array95;
  float[all(equal(mid3(ivec2(0, 0), ivec2(5, 5), ivec2(0, 1)), ivec2(0, 1))) ? 1 : -1] array96;
  float[all(equal(mid3(ivec2(0, 0), ivec2(5, 5), ivec2(2, 5)), ivec2(2, 5))) ? 1 : -1] array97;
  float[all(equal(mid3(ivec2(1, 1), ivec2(-5, -5), ivec2(-5, -2)), ivec2(-5, -2))) ? 1 : -1] array98;
  float[all(equal(mid3(ivec2(1, 1), ivec2(-5, -5), ivec2(-1, 0)), ivec2(-1, 0))) ? 1 : -1] array99;
  float[all(equal(mid3(ivec2(1, 1), ivec2(-5, -5), ivec2(1, 2)), ivec2(1, 1))) ? 1 : -1] array100;
  float[all(equal(mid3(ivec2(1, 1), ivec2(-5, -2), ivec2(5, -5)), ivec2(1, -2))) ? 1 : -1] array101;
  float[all(equal(mid3(ivec2(1, 1), ivec2(-2, -2), ivec2(-2, -1)), ivec2(-2, -1))) ? 1 : -1] array102;
  float[all(equal(mid3(ivec2(1, 1), ivec2(-2, -2), ivec2(0, 1)), ivec2(0, 1))) ? 1 : -1] array103;
  float[all(equal(mid3(ivec2(1, 1), ivec2(-2, -2), ivec2(2, 5)), ivec2(1, 1))) ? 1 : -1] array104;
  float[all(equal(mid3(ivec2(1, 1), ivec2(-1, -1), ivec2(-5, -2)), ivec2(-1, -1))) ? 1 : -1] array105;
  float[all(equal(mid3(ivec2(1, 1), ivec2(-1, -1), ivec2(-1, 0)), ivec2(-1, 0))) ? 1 : -1] array106;
  float[all(equal(mid3(ivec2(1, 1), ivec2(-1, -1), ivec2(1, 2)), ivec2(1, 1))) ? 1 : -1] array107;
  float[all(equal(mid3(ivec2(1, 1), ivec2(-1, 0), ivec2(5, -5)), ivec2(1, 0))) ? 1 : -1] array108;
  float[all(equal(mid3(ivec2(1, 1), ivec2(0, 0), ivec2(-2, -1)), ivec2(0, 0))) ? 1 : -1] array109;
  float[all(equal(mid3(ivec2(1, 1), ivec2(0, 0), ivec2(0, 1)), ivec2(0, 1))) ? 1 : -1] array110;
  float[all(equal(mid3(ivec2(1, 1), ivec2(0, 0), ivec2(2, 5)), ivec2(1, 1))) ? 1 : -1] array111;
  float[all(equal(mid3(ivec2(1, 1), ivec2(1, 1), ivec2(-5, -2)), ivec2(1, 1))) ? 1 : -1] array112;
  float[all(equal(mid3(ivec2(1, 1), ivec2(1, 1), ivec2(-1, 0)), ivec2(1, 1))) ? 1 : -1] array113;
  float[all(equal(mid3(ivec2(1, 1), ivec2(1, 1), ivec2(1, 2)), ivec2(1, 1))) ? 1 : -1] array114;
  float[all(equal(mid3(ivec2(1, 1), ivec2(1, 2), ivec2(5, -5)), ivec2(1, 1))) ? 1 : -1] array115;
  float[all(equal(mid3(ivec2(1, 1), ivec2(2, 2), ivec2(-2, -1)), ivec2(1, 1))) ? 1 : -1] array116;
  float[all(equal(mid3(ivec2(1, 1), ivec2(2, 2), ivec2(0, 1)), ivec2(1, 1))) ? 1 : -1] array117;
  float[all(equal(mid3(ivec2(1, 1), ivec2(2, 2), ivec2(2, 5)), ivec2(2, 2))) ? 1 : -1] array118;
  float[all(equal(mid3(ivec2(1, 1), ivec2(5, 5), ivec2(-5, -2)), ivec2(1, 1))) ? 1 : -1] array119;
  float[all(equal(mid3(ivec2(1, 1), ivec2(5, 5), ivec2(-1, 0)), ivec2(1, 1))) ? 1 : -1] array120;
  float[all(equal(mid3(ivec2(1, 1), ivec2(5, 5), ivec2(1, 2)), ivec2(1, 2))) ? 1 : -1] array121;
  float[all(equal(mid3(ivec2(1, 2), ivec2(5, -5), ivec2(5, -5)), ivec2(5, -5))) ? 1 : -1] array122;
  float[all(equal(mid3(ivec2(2, 2), ivec2(-5, -5), ivec2(-2, -1)), ivec2(-2, -1))) ? 1 : -1] array123;
  float[all(equal(mid3(ivec2(2, 2), ivec2(-5, -5), ivec2(0, 1)), ivec2(0, 1))) ? 1 : -1] array124;
  float[all(equal(mid3(ivec2(2, 2), ivec2(-5, -5), ivec2(2, 5)), ivec2(2, 2))) ? 1 : -1] array125;
  float[all(equal(mid3(ivec2(2, 2), ivec2(-2, -2), ivec2(-5, -2)), ivec2(-2, -2))) ? 1 : -1] array126;
  float[all(equal(mid3(ivec2(2, 2), ivec2(-2, -2), ivec2(-1, 0)), ivec2(-1, 0))) ? 1 : -1] array127;
  float[all(equal(mid3(ivec2(2, 2), ivec2(-2, -2), ivec2(1, 2)), ivec2(1, 2))) ? 1 : -1] array128;
  float[all(equal(mid3(ivec2(2, 2), ivec2(-2, -1), ivec2(5, -5)), ivec2(2, -1))) ? 1 : -1] array129;
  float[all(equal(mid3(ivec2(2, 2), ivec2(-1, -1), ivec2(-2, -1)), ivec2(-1, -1))) ? 1 : -1] array130;
  float[all(equal(mid3(ivec2(2, 2), ivec2(-1, -1), ivec2(0, 1)), ivec2(0, 1))) ? 1 : -1] array131;
  float[all(equal(mid3(ivec2(2, 2), ivec2(-1, -1), ivec2(2, 5)), ivec2(2, 2))) ? 1 : -1] array132;
  float[all(equal(mid3(ivec2(2, 2), ivec2(0, 0), ivec2(-5, -2)), ivec2(0, 0))) ? 1 : -1] array133;
  float[all(equal(mid3(ivec2(2, 2), ivec2(0, 0), ivec2(-1, 0)), ivec2(0, 0))) ? 1 : -1] array134;
  float[all(equal(mid3(ivec2(2, 2), ivec2(0, 0), ivec2(1, 2)), ivec2(1, 2))) ? 1 : -1] array135;
  float[all(equal(mid3(ivec2(2, 2), ivec2(0, 1), ivec2(5, -5)), ivec2(2, 1))) ? 1 : -1] array136;
  float[all(equal(mid3(ivec2(2, 2), ivec2(1, 1), ivec2(-2, -1)), ivec2(1, 1))) ? 1 : -1] array137;
  float[all(equal(mid3(ivec2(2, 2), ivec2(1, 1), ivec2(0, 1)), ivec2(1, 1))) ? 1 : -1] array138;
  float[all(equal(mid3(ivec2(2, 2), ivec2(1, 1), ivec2(2, 5)), ivec2(2, 2))) ? 1 : -1] array139;
  float[all(equal(mid3(ivec2(2, 2), ivec2(2, 2), ivec2(-5, -2)), ivec2(2, 2))) ? 1 : -1] array140;
  float[all(equal(mid3(ivec2(2, 2), ivec2(2, 2), ivec2(-1, 0)), ivec2(2, 2))) ? 1 : -1] array141;
  float[all(equal(mid3(ivec2(2, 2), ivec2(2, 2), ivec2(1, 2)), ivec2(2, 2))) ? 1 : -1] array142;
  float[all(equal(mid3(ivec2(2, 2), ivec2(2, 5), ivec2(5, -5)), ivec2(2, 2))) ? 1 : -1] array143;
  float[all(equal(mid3(ivec2(2, 2), ivec2(5, 5), ivec2(-2, -1)), ivec2(2, 2))) ? 1 : -1] array144;
  float[all(equal(mid3(ivec2(2, 2), ivec2(5, 5), ivec2(0, 1)), ivec2(2, 2))) ? 1 : -1] array145;
  float[all(equal(mid3(ivec2(2, 2), ivec2(5, 5), ivec2(2, 5)), ivec2(2, 5))) ? 1 : -1] array146;
  float[all(equal(mid3(ivec2(5, 5), ivec2(-5, -5), ivec2(-5, -2)), ivec2(-5, -2))) ? 1 : -1] array147;
  float[all(equal(mid3(ivec2(5, 5), ivec2(-5, -5), ivec2(-1, 0)), ivec2(-1, 0))) ? 1 : -1] array148;
  float[all(equal(mid3(ivec2(5, 5), ivec2(-5, -5), ivec2(1, 2)), ivec2(1, 2))) ? 1 : -1] array149;
  float[all(equal(mid3(ivec2(5, 5), ivec2(-5, -2), ivec2(5, -5)), ivec2(5, -2))) ? 1 : -1] array150;
  float[all(equal(mid3(ivec2(5, 5), ivec2(-2, -2), ivec2(-2, -1)), ivec2(-2, -1))) ? 1 : -1] array151;
  float[all(equal(mid3(ivec2(5, 5), ivec2(-2, -2), ivec2(0, 1)), ivec2(0, 1))) ? 1 : -1] array152;
  float[all(equal(mid3(ivec2(5, 5), ivec2(-2, -2), ivec2(2, 5)), ivec2(2, 5))) ? 1 : -1] array153;
  float[all(equal(mid3(ivec2(5, 5), ivec2(-1, -1), ivec2(-5, -2)), ivec2(-1, -1))) ? 1 : -1] array154;
  float[all(equal(mid3(ivec2(5, 5), ivec2(-1, -1), ivec2(-1, 0)), ivec2(-1, 0))) ? 1 : -1] array155;
  float[all(equal(mid3(ivec2(5, 5), ivec2(-1, -1), ivec2(1, 2)), ivec2(1, 2))) ? 1 : -1] array156;
  float[all(equal(mid3(ivec2(5, 5), ivec2(-1, 0), ivec2(5, -5)), ivec2(5, 0))) ? 1 : -1] array157;
  float[all(equal(mid3(ivec2(5, 5), ivec2(0, 0), ivec2(-2, -1)), ivec2(0, 0))) ? 1 : -1] array158;
  float[all(equal(mid3(ivec2(5, 5), ivec2(0, 0), ivec2(0, 1)), ivec2(0, 1))) ? 1 : -1] array159;
  float[all(equal(mid3(ivec2(5, 5), ivec2(0, 0), ivec2(2, 5)), ivec2(2, 5))) ? 1 : -1] array160;
  float[all(equal(mid3(ivec2(5, 5), ivec2(1, 1), ivec2(-5, -2)), ivec2(1, 1))) ? 1 : -1] array161;
  float[all(equal(mid3(ivec2(5, 5), ivec2(1, 1), ivec2(-1, 0)), ivec2(1, 1))) ? 1 : -1] array162;
  float[all(equal(mid3(ivec2(5, 5), ivec2(1, 1), ivec2(1, 2)), ivec2(1, 2))) ? 1 : -1] array163;
  float[all(equal(mid3(ivec2(5, 5), ivec2(1, 2), ivec2(5, -5)), ivec2(5, 2))) ? 1 : -1] array164;
  float[all(equal(mid3(ivec2(5, 5), ivec2(2, 2), ivec2(-2, -1)), ivec2(2, 2))) ? 1 : -1] array165;
  float[all(equal(mid3(ivec2(5, 5), ivec2(2, 2), ivec2(0, 1)), ivec2(2, 2))) ? 1 : -1] array166;
  float[all(equal(mid3(ivec2(5, 5), ivec2(2, 2), ivec2(2, 5)), ivec2(2, 5))) ? 1 : -1] array167;
  float[all(equal(mid3(ivec2(5, 5), ivec2(5, 5), ivec2(-5, -2)), ivec2(5, 5))) ? 1 : -1] array168;
  float[all(equal(mid3(ivec2(5, 5), ivec2(5, 5), ivec2(-1, 0)), ivec2(5, 5))) ? 1 : -1] array169;
  float[all(equal(mid3(ivec2(5, 5), ivec2(5, 5), ivec2(1, 2)), ivec2(5, 5))) ? 1 : -1] array170;
  float[all(equal(mid3(ivec2(5, -5), ivec2(5, -5), ivec2(5, -5)), ivec2(5, -5))) ? 1 : -1] array171;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length() + array27.length() + array28.length() + array29.length() + array30.length() + array31.length() + array32.length() + array33.length() + array34.length() + array35.length() + array36.length() + array37.length() + array38.length() + array39.length() + array40.length() + array41.length() + array42.length() + array43.length() + array44.length() + array45.length() + array46.length() + array47.length() + array48.length() + array49.length() + array50.length() + array51.length() + array52.length() + array53.length() + array54.length() + array55.length() + array56.length() + array57.length() + array58.length() + array59.length() + array60.length() + array61.length() + array62.length() + array63.length() + array64.length() + array65.length() + array66.length() + array67.length() + array68.length() + array69.length() + array70.length() + array71.length() + array72.length() + array73.length() + array74.length() + array75.length() + array76.length() + array77.length() + array78.length() + array79.length() + array80.length() + array81.length() + array82.length() + array83.length() + array84.length() + array85.length() + array86.length() + array87.length() + array88.length() + array89.length() + array90.length() + array91.length() + array92.length() + array93.length() + array94.length() + array95.length() + array96.length() + array97.length() + array98.length() + array99.length() + array100.length() + array101.length() + array102.length() + array103.length() + array104.length() + array105.length() + array106.length() + array107.length() + array108.length() + array109.length() + array110.length() + array111.length() + array112.length() + array113.length() + array114.length() + array115.length() + array116.length() + array117.length() + array118.length() + array119.length() + array120.length() + array121.length() + array122.length() + array123.length() + array124.length() + array125.length() + array126.length() + array127.length() + array128.length() + array129.length() + array130.length() + array131.length() + array132.length() + array133.length() + array134.length() + array135.length() + array136.length() + array137.length() + array138.length() + array139.length() + array140.length() + array141.length() + array142.length() + array143.length() + array144.length() + array145.length() + array146.length() + array147.length() + array148.length() + array149.length() + array150.length() + array151.length() + array152.length() + array153.length() + array154.length() + array155.length() + array156.length() + array157.length() + array158.length() + array159.length() + array160.length() + array161.length() + array162.length() + array163.length() + array164.length() + array165.length() + array166.length() + array167.length() + array168.length() + array169.length() + array170.length() + array171.length());
}
