/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.openssl;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import org.apache.tomcat.util.openssl.openssl_h;

public class openssl_h_Compatibility {
    public static final boolean OPENSSL;
    public static final boolean OPENSSL3;
    public static final boolean BORINGSSL;
    public static final boolean LIBRESSL;
    public static final int MAJOR;
    public static final int MINOR;
    public static final int SSL_CTRL_OPTIONS = 32;
    public static final int SSL_CTRL_CLEAR_OPTIONS = 77;
    private static final int ENGINE_METHOD_ALL = 65535;

    public static boolean isLibreSSLPre35() {
        return LIBRESSL && (MAJOR == 3 && MINOR < 5 || MAJOR < 3);
    }

    public static int FIPS_mode() {
        if (openssl_h_Compatibility.isLibreSSLPre35()) {
            return 0;
        }
        class Holder {
            static final String NAME = "FIPS_mode";
            static final FunctionDescriptor DESC = FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("FIPS_mode"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            if (openssl_h.TRACE_DOWNCALLS) {
                openssl_h.traceDowncall("FIPS_mode", new Object[0]);
            }
            return mh$.invokeExact();
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int FIPS_mode_set(int r) {
        if (openssl_h_Compatibility.isLibreSSLPre35()) {
            return 0;
        }
        class Holder {
            static final String NAME = "FIPS_mode_set";
            static final FunctionDescriptor DESC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("FIPS_mode_set"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            if (openssl_h.TRACE_DOWNCALLS) {
                openssl_h.traceDowncall("FIPS_mode_set", r);
            }
            return mh$.invokeExact(r);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int EVP_PKEY_base_id(MemorySegment pkey) {
        class Holder {
            static final String NAME = "EVP_PKEY_base_id";
            static final FunctionDescriptor DESC = FunctionDescriptor.of(ValueLayout.JAVA_INT, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("EVP_PKEY_base_id"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            if (openssl_h.TRACE_DOWNCALLS) {
                openssl_h.traceDowncall("EVP_PKEY_base_id", pkey);
            }
            return mh$.invokeExact(pkey);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int EVP_PKEY_bits(MemorySegment pkey) {
        class Holder {
            static final String NAME = "EVP_PKEY_bits";
            static final FunctionDescriptor DESC = FunctionDescriptor.of(ValueLayout.JAVA_INT, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("EVP_PKEY_bits"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            if (openssl_h.TRACE_DOWNCALLS) {
                openssl_h.traceDowncall("EVP_PKEY_bits", pkey);
            }
            return mh$.invokeExact(pkey);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MemorySegment SSL_get_peer_certificate(MemorySegment s) {
        if (OPENSSL3) {
            return openssl_h.SSL_get1_peer_certificate(s);
        }
        class Holder {
            static final String NAME = "SSL_get_peer_certificate";
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_POINTER, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("SSL_get_peer_certificate"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            if (openssl_h.TRACE_DOWNCALLS) {
                openssl_h.traceDowncall("SSL_get_peer_certificate", s);
            }
            return mh$.invokeExact(s);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor X509_STORE_CTX_get0_current_issuer$descriptor() {
        return X509_STORE_CTX_get0_current_issuer.DESC;
    }

    public static MethodHandle X509_STORE_CTX_get0_current_issuer$handle() {
        return X509_STORE_CTX_get0_current_issuer.HANDLE;
    }

    public static MemorySegment X509_STORE_CTX_get0_current_issuer$address() {
        return X509_STORE_CTX_get0_current_issuer.ADDR;
    }

    public static MemorySegment X509_STORE_CTX_get0_current_issuer(MemorySegment ctx) {
        MethodHandle mh$ = X509_STORE_CTX_get0_current_issuer.HANDLE;
        try {
            if (openssl_h.TRACE_DOWNCALLS) {
                openssl_h.traceDowncall("X509_STORE_CTX_get0_current_issuer", ctx);
            }
            return mh$.invokeExact(ctx);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static long SSL_CTX_get_options(MemorySegment ctx) {
        if (LIBRESSL) {
            return openssl_h.SSL_CTX_ctrl(ctx, 32, 0L, MemorySegment.NULL);
        }
        return openssl_h.SSL_CTX_get_options(ctx);
    }

    public static long SSL_CTX_set_options(MemorySegment ctx, long op) {
        if (LIBRESSL) {
            return openssl_h.SSL_CTX_ctrl(ctx, 32, op, MemorySegment.NULL);
        }
        return openssl_h.SSL_CTX_set_options(ctx, op);
    }

    public static long SSL_get_options(MemorySegment s) {
        if (LIBRESSL) {
            return openssl_h_Compatibility.SSL_ctrl(s, 32, 0L, MemorySegment.NULL);
        }
        return openssl_h.SSL_get_options(s);
    }

    public static long SSL_set_options(MemorySegment s, long op) {
        if (LIBRESSL) {
            return openssl_h_Compatibility.SSL_ctrl(s, 32, op, MemorySegment.NULL);
        }
        return openssl_h.SSL_set_options(s, op);
    }

    public static long SSL_CTX_clear_options(MemorySegment ctx, long op) {
        if (LIBRESSL) {
            return openssl_h.SSL_CTX_ctrl(ctx, 77, op, MemorySegment.NULL);
        }
        return openssl_h.SSL_CTX_clear_options(ctx, op);
    }

    public static int OPENSSL_sk_num(MemorySegment x0) {
        if (LIBRESSL) {
            class Holder {
                static final String NAME = "sk_num";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_INT, openssl_h.C_POINTER);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("sk_num"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("sk_num", x0);
                }
                return mh$.invokeExact(x0);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.OPENSSL_sk_num(x0);
    }

    public static MemorySegment OPENSSL_sk_value(MemorySegment x0, int x1) {
        if (LIBRESSL) {
            class Holder {
                static final String NAME = "sk_value";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_INT);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("sk_value"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("sk_value", x0, x1);
                }
                return mh$.invokeExact(x0, x1);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.OPENSSL_sk_value(x0, x1);
    }

    public static void SSL_set_verify_result(MemorySegment ssl, long v) {
        if (!BORINGSSL) {
            openssl_h.SSL_set_verify_result(ssl, v);
        }
    }

    public static long SSL_ctrl(MemorySegment ssl, int cmd, long larg, MemorySegment parg) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_LONG, openssl_h.C_POINTER, openssl_h.C_INT, openssl_h.C_LONG, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("SSL_ctrl"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact(ssl, cmd, larg, parg);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MemorySegment ENGINE_by_id(MemorySegment id) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_POINTER, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("ENGINE_by_id"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact(id);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int ENGINE_register_all_complete() {
        try {
            return Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("ENGINE_register_all_complete"), FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]), new Linker.Option[0]).invokeExact();
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int ENGINE_ctrl_cmd_string(MemorySegment e, MemorySegment cmd_name, MemorySegment arg, int cmd_optional) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_INT, openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_INT);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("ENGINE_ctrl_cmd_string"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact(e, cmd_name, arg, cmd_optional);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int ENGINE_free(MemorySegment e) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_INT, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("ENGINE_free"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact(e);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MemorySegment ENGINE_load_private_key(MemorySegment e, MemorySegment key_id, MemorySegment ui_method, MemorySegment callback_data) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("ENGINE_load_private_key"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact(e, key_id, ui_method, callback_data);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int ENGINE_set_default(MemorySegment e, int flags) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_INT, openssl_h.C_POINTER, openssl_h.C_INT);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("ENGINE_set_default"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact(e, flags);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int ENGINE_METHOD_ALL() {
        return 65535;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String versionString = openssl_h.OpenSSL_version(0).getString(0L);
        OPENSSL = versionString.contains("OpenSSL");
        OPENSSL3 = OPENSSL && openssl_h.OpenSSL_version_num() >= 0x3000000FL;
        BORINGSSL = versionString.contains("BoringSSL");
        LIBRESSL = versionString.contains("LibreSSL");
        int majorVersion = 0;
        int minorVersion = 0;
        try {
            String[] versionNumberStrings;
            String[] blocks = versionString.split("\\s");
            if (blocks.length >= 2) {
                versionString = blocks[1];
            }
            if ((versionNumberStrings = versionString.split("\\.")).length >= 2) {
                majorVersion = Integer.parseInt(versionNumberStrings[0]);
                minorVersion = Integer.parseInt(versionNumberStrings[1]);
            }
        }
        catch (Exception exception) {
        }
        finally {
            MAJOR = majorVersion;
            MINOR = minorVersion;
        }
    }

    private static class X509_STORE_CTX_get0_current_issuer {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_POINTER, openssl_h.C_POINTER);
        public static final MemorySegment ADDR = openssl_h.findOrThrow("X509_STORE_CTX_get0_current_issuer");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private X509_STORE_CTX_get0_current_issuer() {
        }
    }
}

