/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.client.util.StreamingContent;
import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.internal.ApacheHttp2Request;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;

public class ApacheHttp2AsyncEntityProducer
implements AsyncEntityProducer {
    private ByteBuffer bytebuf;
    private ByteArrayOutputStream baos;
    private final StreamingContent content;
    private final ContentType contentType;
    private final long contentLength;
    private final String contentEncoding;
    private final CompletableFuture<Void> writeFuture;
    private final AtomicReference<Exception> exception;

    public ApacheHttp2AsyncEntityProducer(StreamingContent content, ContentType contentType, String contentEncoding, long contentLength, CompletableFuture<Void> writeFuture) {
        this.content = content;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.contentLength = contentLength;
        this.writeFuture = writeFuture;
        this.bytebuf = null;
        this.baos = new ByteArrayOutputStream((int)(contentLength < 0L ? 0L : contentLength));
        this.exception = new AtomicReference();
    }

    public ApacheHttp2AsyncEntityProducer(ApacheHttp2Request request, CompletableFuture<Void> writeFuture) {
        this(request.getStreamingContent(), ContentType.parse((CharSequence)request.getContentType()), request.getContentEncoding(), request.getContentLength(), writeFuture);
    }

    public boolean isRepeatable() {
        return true;
    }

    public String getContentType() {
        return this.contentType != null ? this.contentType.toString() : null;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public int available() {
        return Integer.MAX_VALUE;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public boolean isChunked() {
        return this.contentLength == -1L;
    }

    public Set<String> getTrailerNames() {
        return null;
    }

    public void produce(DataStreamChannel channel) throws IOException {
        if (this.bytebuf == null) {
            if (this.content != null) {
                try {
                    this.content.writeTo((OutputStream)this.baos);
                }
                catch (IOException e) {
                    this.failed(e);
                    throw e;
                }
            }
            this.bytebuf = ByteBuffer.wrap(this.baos.toByteArray());
        }
        if (this.bytebuf.hasRemaining()) {
            channel.write(this.bytebuf);
        }
        if (!this.bytebuf.hasRemaining()) {
            channel.endStream();
            this.writeFuture.complete(null);
            this.releaseResources();
        }
    }

    public void failed(Exception cause) {
        if (this.exception.compareAndSet(null, cause)) {
            this.releaseResources();
            this.writeFuture.completeExceptionally(cause);
        }
    }

    public final Exception getException() {
        return this.exception.get();
    }

    public void releaseResources() {
        if (this.bytebuf != null) {
            this.bytebuf.clear();
        }
    }

    @VisibleForTesting
    ByteBuffer getBytebuf() {
        return this.bytebuf;
    }
}

