function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { keysOf } from '../common';
import { OuiIcon } from '../icon';
var colorToClassNameMap = {
  subdued: 'ouiExpression--subdued',
  primary: 'ouiExpression--primary',
  success: 'ouiExpression--success',
  secondary: 'ouiExpression--secondary',
  accent: 'ouiExpression--accent',
  warning: 'ouiExpression--warning',
  danger: 'ouiExpression--danger'
};
var textWrapToClassNameMap = {
  'break-word': null,
  truncate: 'ouiExpression--truncate'
};
export var COLORS = keysOf(colorToClassNameMap);
var displayToClassNameMap = {
  inline: null,
  columns: 'ouiExpression--columns'
};
export var OuiExpression = function OuiExpression(_ref) {
  var className = _ref.className,
    description = _ref.description,
    descriptionProps = _ref.descriptionProps,
    value = _ref.value,
    valueProps = _ref.valueProps,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'success' : _ref$color,
    _ref$uppercase = _ref.uppercase,
    uppercase = _ref$uppercase === void 0 ? true : _ref$uppercase,
    _ref$isActive = _ref.isActive,
    isActive = _ref$isActive === void 0 ? false : _ref$isActive,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'inline' : _ref$display,
    _ref$descriptionWidth = _ref.descriptionWidth,
    descriptionWidth = _ref$descriptionWidth === void 0 ? '20%' : _ref$descriptionWidth,
    onClick = _ref.onClick,
    _ref$isInvalid = _ref.isInvalid,
    isInvalid = _ref$isInvalid === void 0 ? false : _ref$isInvalid,
    _ref$textWrap = _ref.textWrap,
    textWrap = _ref$textWrap === void 0 ? 'break-word' : _ref$textWrap,
    rest = _objectWithoutProperties(_ref, ["className", "description", "descriptionProps", "value", "valueProps", "color", "uppercase", "isActive", "display", "descriptionWidth", "onClick", "isInvalid", "textWrap"]);
  var calculatedColor = isInvalid ? 'danger' : color;
  var classes = classNames('ouiExpression', className, {
    'ouiExpression-isActive': isActive,
    'ouiExpression-isClickable': onClick,
    'ouiExpression-isUppercase': uppercase
  }, displayToClassNameMap[display], colorToClassNameMap[calculatedColor], textWrapToClassNameMap[textWrap]);
  var Component = onClick ? 'button' : 'span';
  var descriptionStyle = descriptionProps && descriptionProps.style;
  var customWidth = display === 'columns' && descriptionWidth ? _objectSpread({
    flexBasis: descriptionWidth
  }, descriptionStyle) : undefined;
  var invalidIcon = isInvalid ? /*#__PURE__*/React.createElement(OuiIcon, {
    className: "ouiExpression__icon",
    type: "alert",
    color: calculatedColor
  }) : undefined;
  return /*#__PURE__*/React.createElement(Component, _extends({
    className: classes,
    onClick: onClick
  }, rest), /*#__PURE__*/React.createElement("span", _extends({
    className: "ouiExpression__description",
    style: customWidth
  }, descriptionProps), description), ' ', value && /*#__PURE__*/React.createElement("span", _extends({
    className: "ouiExpression__value"
  }, valueProps), value), invalidIcon);
};

/* OUI -> EUI Aliases: Build-Time */
OuiExpression.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  /**
     * First part of the expression
     */
  /**
     * First part of the expression
     */
  description: PropTypes.node.isRequired,
  descriptionProps: PropTypes.any,
  /**
     * Second part of the expression
     */
  /**
     * Second part of the expression
     */
  value: PropTypes.node,
  valueProps: PropTypes.any,
  /**
     * Color of the `description`
     * **`secondary` color is DEPRECATED, use `success` instead**
     */
  /**
     * Color of the `description`
     * **`secondary` color is DEPRECATED, use `success` instead**
     */
  color: PropTypes.oneOf(["subdued", "primary", "success", "secondary", "accent", "warning", "danger"]),
  /**
     * Should the `description` auto-uppercase?
     */
  /**
     * Should the `description` auto-uppercase?
     */
  uppercase: PropTypes.bool,
  /**
     * Adds an solid border at the bottom
     */
  /**
     * Adds an solid border at the bottom
     */
  isActive: PropTypes.bool,
  /**
     * Turns the component into a button and adds an editable style border at the bottom
     */
  /**
     * Turns the component into a button and adds an editable style border at the bottom
     */
  onClick: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.func, PropTypes.func.isRequired]), PropTypes.func]),
  /**
     * Sets the display style for the expression. Defaults to `inline`
     */
  /**
     * Sets the display style for the expression. Defaults to `inline`
     */
  display: PropTypes.oneOf(["inline", "columns"]),
  /**
     * Forces color to display as `danger` and shows an `alert` icon
     */
  /**
     * Forces color to display as `danger` and shows an `alert` icon
     */
  isInvalid: PropTypes.bool,
  /**
     * Sets a custom width for the description when using the columns layout.
     * Set to a number for a custom width in `px`.
     * Set to a string for a custom width in custom measurement.
     * Defaults to `20%`
     */
  /**
     * Sets a custom width for the description when using the columns layout.
     * Set to a number for a custom width in `px`.
     * Set to a string for a custom width in custom measurement.
     * Defaults to `20%`
     */
  descriptionWidth: PropTypes.oneOfType([PropTypes.number.isRequired, PropTypes.string.isRequired]),
  /**
     * Sets how to handle the wrapping of long text.
     */
  /**
     * Sets how to handle the wrapping of long text.
     */
  textWrap: PropTypes.oneOf(["break-word", "truncate"])
};
/* OUI -> EUI Aliases: Build-Time */export { EuiExpression } from '../../eui_components/expression/expression';