/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.architect.swingui.ArchitectSwingProject;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.critic.ModelBadge;
import ca.sqlpower.architect.swingui.olap.UsageComponent;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sqlobject.SQLDatabase;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlayPenContentPane
extends AbstractSPObject {
    private static final Logger logger = Logger.getLogger(PlayPenContentPane.class);
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.singletonList(PlayPenComponent.class);
    private static final List<Class<? extends PlayPenComponent>> dependentComponentTypes = Collections.unmodifiableList(new ArrayList<Class>(Arrays.asList(Relationship.class, UsageComponent.class)));
    private PlayPen playPen;
    private List<PlayPenComponent> components = new ArrayList<PlayPenComponent>();
    private List<PlayPenComponent> dependentComponents = new ArrayList<PlayPenComponent>();
    private final SPObject modelContainer;
    private HashMap<SPListener, SPListener> componentListeners = new HashMap();
    private final SPListener modelContainerListener = new AbstractSPListener(){

        public void childRemoved(SPChildEvent e) {
            if (e.getChild() == PlayPenContentPane.this.modelContainer && e.getSource().isMagicEnabled()) {
                try {
                    PlayPenContentPane.this.getParent().removeChild((SPObject)PlayPenContentPane.this);
                }
                catch (ObjectDependentException ex) {
                    throw new RuntimeException(ex);
                }
                e.getSource().removeSPListener((SPListener)this);
            }
        }
    };
    private final SPListener componentBoundChanges = new AbstractSPListener(){

        public void propertyChanged(PropertyChangeEvent evt) {
            if ((evt.getPropertyName().equals("topLeftCorner") || evt.getPropertyName().equals("lengths")) && PlayPenContentPane.this.playPen != null) {
                PlayPenContentPane.this.playPen.revalidate();
            }
        }
    };
    private final Map<Object, ModelBadge> badges = new HashMap<Object, ModelBadge>();

    @Constructor
    public PlayPenContentPane(@ConstructorParameter(propertyName="modelContainer") SPObject modelContainer) {
        this.setName("PlayPenContentPane");
        if (!(modelContainer instanceof SQLDatabase) && !(modelContainer instanceof OLAPSession)) {
            throw new IllegalArgumentException("modelContainer must either be a SQLDatabase or OLAPSession");
        }
        this.modelContainer = modelContainer;
        if (modelContainer instanceof OLAPSession) {
            modelContainer.getParent().addSPListener(this.modelContainerListener);
        }
    }

    @Accessor
    public SPObject getModelContainer() {
        return this.modelContainer;
    }

    @Transient
    @Accessor
    public PlayPen getPlayPen() {
        return this.playPen;
    }

    @Transient
    @Mutator
    public void setPlayPen(PlayPen owner) {
        if (this.playPen != null) {
            throw new IllegalStateException("Cannot change PlayPen once it is already set!");
        }
        this.playPen = owner;
        this.setPlayPenListeningToComponents();
        if (owner != null) {
            owner.addPropertyChangeListener("zoom", new ZoomFixer());
            this.firePropertyChange("playPen", null, owner);
        }
        for (PlayPenComponent c : this.components) {
            c.revalidate();
        }
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int x, int y) {
        return true;
    }

    @NonBound
    public boolean isValidateRoot() {
        logger.debug((Object)"isValidateRoot returning true");
        return true;
    }

    @Transient
    @Accessor
    public String getToolTipText(MouseEvent e) {
        String text = null;
        PlayPenComponent c = this.getComponentAt(e.getPoint());
        if (c != null) {
            text = c.getToolTipText();
        }
        logger.debug((Object)("Checking for tooltip component at " + e.getPoint() + " is " + c + ". tooltipText is " + text));
        return text;
    }

    @NonBound
    public PlayPenComponent getComponentAt(Point p) {
        for (PlayPenComponent playPenComponent : this.getAllChildren()) {
            if (!playPenComponent.contains(p)) continue;
            return playPenComponent;
        }
        return null;
    }

    @NonBound
    public int getFirstDependentComponentIndex() {
        return this.components.size();
    }

    @NonBound
    public static boolean isDependentComponentType(Class<? extends PlayPenComponent> componentType) {
        for (Class<? extends PlayPenComponent> dependentType : dependentComponentTypes) {
            if (!dependentType.isAssignableFrom(componentType)) continue;
            return true;
        }
        return false;
    }

    protected void addChildImpl(SPObject child, int pos) {
        PlayPenComponent ppc = (PlayPenComponent)child;
        if (dependentComponentTypes.contains(ppc.getClass())) {
            this.dependentComponents.add(pos - this.components.size(), ppc);
        } else {
            this.components.add(pos, ppc);
        }
        ppc.setParent((SPObject)this);
        if (this.getPlayPen() != null) {
            ppc.addSelectionListener(this.getPlayPen());
        }
        ppc.addSPListener(this.componentBoundChanges);
        ppc.connect();
        this.fireChildAdded(ppc.getClass(), (SPObject)ppc, pos);
        ppc.revalidate();
        if (this.playPen != null) {
            this.playPen.revalidate();
        }
    }

    protected boolean removeChildImpl(SPObject child) {
        int index = this.getChildren().indexOf(child);
        boolean removed = dependentComponentTypes.contains(child.getClass()) ? this.dependentComponents.remove(child) : this.components.remove(child);
        if (!removed) {
            return false;
        }
        this.fireChildRemoved(child.getClass(), child, index);
        child.setParent(null);
        if (this.getPlayPen() != null) {
            ((PlayPenComponent)child).removeSelectionListener(this.getPlayPen());
        }
        child.removeSPListener(this.componentBoundChanges);
        if (this.playPen != null) {
            this.playPen.repaint();
        }
        return true;
    }

    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    public List<? extends PlayPenComponent> getChildren() {
        ArrayList<PlayPenComponent> children = new ArrayList<PlayPenComponent>();
        children.addAll(this.components);
        children.addAll(this.dependentComponents);
        return children;
    }

    @NonProperty
    public List<? extends PlayPenComponent> getAllChildren() {
        ArrayList<PlayPenComponent> children = new ArrayList<PlayPenComponent>();
        children.addAll(this.components);
        children.addAll(this.badges.values());
        children.addAll(this.dependentComponents);
        return children;
    }

    @Accessor
    public ArchitectSwingProject getParent() {
        return (ArchitectSwingProject)super.getParent();
    }

    @Mutator
    public void setParent(SPObject parent) {
        if (!(parent instanceof ArchitectSwingProject) && parent != null) {
            throw new IllegalArgumentException("Parent of PlayPenContentPane must be ArchitectProject, not " + parent.getClass().getSimpleName());
        }
        super.setParent(parent);
    }

    @NonBound
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    public void removeDependency(SPObject dependency) {
        throw new IllegalArgumentException("That is not a dependency, since this object has no depencies");
    }

    public void addComponentPropertyListener(String[] propertyNames, final SPListener listener) {
        final List<Object> filter = propertyNames == null ? Collections.emptyList() : Arrays.asList(propertyNames);
        AbstractSPListener filteredListener = new AbstractSPListener(){

            public void propertyChanged(PropertyChangeEvent evt) {
                if (filter.size() == 0 || filter.contains(evt.getPropertyName())) {
                    listener.propertyChanged(evt);
                }
            }
        };
        this.componentListeners.put(listener, (SPListener)filteredListener);
        for (PlayPenComponent playPenComponent : this.getChildren()) {
            playPenComponent.addSPListener((SPListener)filteredListener);
        }
        this.addSPListener((SPListener)new AbstractSPListener((SPListener)filteredListener){
            final /* synthetic */ SPListener val$filteredListener;
            {
                this.val$filteredListener = sPListener;
            }

            public void childAdded(SPChildEvent e) {
                e.getChild().addSPListener(this.val$filteredListener);
            }

            public void childRemoved(SPChildEvent e) {
                e.getChild().removeSPListener(this.val$filteredListener);
            }
        });
    }

    public void addComponentPropertyListener(String propertyName, SPListener listener) {
        this.addComponentPropertyListener(new String[]{propertyName}, listener);
    }

    public void addComponentPropertyListener(SPListener listener) {
        this.addComponentPropertyListener(new String[0], listener);
    }

    public void removeComponentPropertyListener(SPListener listener) {
        this.componentListeners.remove(listener);
    }

    @NonBound
    public HashMap<SPListener, SPListener> getComponentListeners() {
        return this.componentListeners;
    }

    @NonBound
    public void setComponentListeners(HashMap<SPListener, SPListener> componentListeners) {
        this.componentListeners = componentListeners;
    }

    private void setPlayPenListeningToComponents() {
        for (PlayPenComponent playPenComponent : this.getChildren()) {
            playPenComponent.removeSelectionListener(this.getPlayPen());
            playPenComponent.addSelectionListener(this.getPlayPen());
        }
    }

    public void removeModelBadge(ModelBadge badge) {
        this.badges.remove(badge.getSubject());
        badge.cleanup();
    }

    public void addModelBadge(ModelBadge badge) {
        badge.setParent((SPObject)this);
        this.badges.put(badge.getSubject(), badge);
    }

    @Transient
    @Accessor
    public ModelBadge getBadge(Object subject) {
        return this.badges.get(subject);
    }

    private class ZoomFixer
    implements PropertyChangeListener {
        private ZoomFixer() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                PlayPenContentPane.this.begin("Revalidating all UI components.");
                for (PlayPenComponent playPenComponent : PlayPenContentPane.this.getChildren()) {
                    if (playPenComponent instanceof Relationship) continue;
                    playPenComponent.revalidate();
                }
                PlayPenContentPane.this.commit();
            }
            catch (Throwable t) {
                PlayPenContentPane.this.rollback("Failed to revalidate UI. " + t.getMessage());
                throw new RuntimeException(t);
            }
        }
    }
}

